/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.internal.snmp.SnmpTools;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpUnknownMsgProcModelException;
import com.sun.management.snmp.usm.SnmpUserSecurityModel;
import com.sun.management.snmp.usm.SnmpUsmAuthAlgorithmException;
import com.sun.management.snmp.usm.SnmpUsmAuthException;
import com.sun.management.snmp.usm.SnmpUsmAuthPair;
import com.sun.management.snmp.usm.SnmpUsmEngineIdException;
import com.sun.management.snmp.usm.SnmpUsmException;
import com.sun.management.snmp.usm.SnmpUsmExceptionGenerator;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmSecurityCache;
import com.sun.management.snmp.usm.SnmpUsmSecurityParameters;
import com.sun.management.snmp.usm.SnmpUsmSecurityParametersImpl;
import com.sun.management.snmp.usm.SnmpUsmUserNameException;

class SnmpUsmAuthModule {
    SnmpUserSecurityModel model = null;
    SnmpUsmLcd lcd = null;
    SnmpUsmExceptionGenerator genExp = null;
    byte[] zeroedArray = new byte[12];
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmAuthModule");
    String dbgTag = "SnmpUsmAuthModule";

    SnmpUsmAuthModule(SnmpUserSecurityModel snmpUserSecurityModel, SnmpUsmLcd snmpUsmLcd, SnmpUsmExceptionGenerator snmpUsmExceptionGenerator) {
        this.model = snmpUserSecurityModel;
        this.lcd = snmpUsmLcd;
        this.genExp = snmpUsmExceptionGenerator;
    }

    void authMsg(SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem, SnmpUsmSecurityParameters snmpUsmSecurityParameters, SnmpUsmSecurityCache snmpUsmSecurityCache, int n, int n2, int n3, byte by, int n4, byte[] byArray) throws SnmpStatusException, SnmpSecurityException {
        if (logger.finestOn()) {
            logger.finest("authMsg", "Will authenticate a new message");
        }
        byte[] byArray2 = snmpUsmSecurityParameters.getAuthParameters();
        if (logger.finestOn()) {
            logger.finest("authMsg", "Received HMAC : " + snmpUsmSecurityParameters.getAuthParameters());
        }
        try {
            byte[] byArray3 = this.signMsg(snmpMsgProcessingSubSystem, snmpUsmSecurityParameters, snmpUsmSecurityCache, n, n2, n3, by, n4, byArray);
            if (logger.finerOn()) {
                logger.finer("authMsg", " userName : " + snmpUsmSecurityParameters.getUserName() + " /\n Received HMAC : [" + SnmpTools.binary2ascii(byArray2) + "]");
                logger.finer("authMsg", "Calculated HMAC : [" + SnmpTools.binary2ascii(byArray3) + "]");
            }
            this.checkHMAC(snmpUsmSecurityParameters, byArray2, byArray3);
        }
        catch (SnmpUsmAuthException snmpUsmAuthException) {
            this.genExp.genAuthenticationException(null, null, by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmUserNameException snmpUsmUserNameException) {
            this.genExp.genUserNameException(null, null, by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmEngineIdException snmpUsmEngineIdException) {
            this.genExp.genEngineIdException(null, null, by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmAuthAlgorithmException snmpUsmAuthAlgorithmException) {
            this.genExp.genSecurityLevelException(null, null, by, snmpUsmSecurityParameters);
        }
        catch (Exception exception) {
            throw new SnmpSecurityException("unknown Security Exception");
        }
    }

    void authMsg(SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem, SnmpUsmSecurityParameters snmpUsmSecurityParameters, SnmpUsmSecurityCache snmpUsmSecurityCache, int n, int n2, int n3, byte by, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3) throws SnmpStatusException, SnmpSecurityException {
        if (logger.finestOn()) {
            logger.finest("authMsg", "Will authenticate a new message");
        }
        byte[] byArray4 = snmpUsmSecurityParameters.getAuthParameters();
        if (logger.finestOn()) {
            logger.finest("authMsg", "Received HMAC : " + SnmpTools.binary2ascii(snmpUsmSecurityParameters.getAuthParameters()) + " data : " + byArray3);
        }
        try {
            byte[] byArray5 = this.signMsg(snmpMsgProcessingSubSystem, snmpUsmSecurityParameters, snmpUsmSecurityCache, n, n2, n3, by, n4, byArray, byArray2, byArray3, byArray3 == null ? 0 : byArray3.length);
            if (logger.finerOn()) {
                logger.finer("authMsg", " userName : " + snmpUsmSecurityParameters.getUserName() + " /\n Received HMAC : [" + SnmpTools.binary2ascii(byArray4) + "]");
                logger.finer("authMsg", "Calculated HMAC : [" + SnmpTools.binary2ascii(byArray5) + "]");
            }
            this.checkHMAC(snmpUsmSecurityParameters, byArray4, byArray5);
        }
        catch (SnmpUsmAuthException snmpUsmAuthException) {
            this.genExp.genAuthenticationException(byArray, byArray2, by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmUserNameException snmpUsmUserNameException) {
            this.genExp.genUserNameException(byArray, byArray2, by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmEngineIdException snmpUsmEngineIdException) {
            this.genExp.genEngineIdException(byArray, byArray2, by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmAuthAlgorithmException snmpUsmAuthAlgorithmException) {
            this.genExp.genSecurityLevelException(byArray, byArray2, by, snmpUsmSecurityParameters);
        }
        catch (Exception exception) {
            throw new SnmpSecurityException("unknown Security Exception");
        }
    }

    byte[] signMsg(SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem, SnmpUsmSecurityParameters snmpUsmSecurityParameters, SnmpUsmSecurityCache snmpUsmSecurityCache, int n, int n2, int n3, byte by, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3, int n5) throws SnmpUsmException, SnmpStatusException, SnmpTooBigException, SnmpUnknownMsgProcModelException {
        byte[] byArray4 = new byte[n3];
        int n6 = 0;
        if (logger.finerOn()) {
            logger.finer("signMsg", " Will encode.");
        }
        n6 = snmpMsgProcessingSubSystem.encode(n, n2, n3, by, n4, this.createAuthPrivNullParams(snmpUsmSecurityParameters), byArray, byArray2, byArray3, n5, byArray4);
        return this.sign(snmpUsmSecurityCache, snmpUsmSecurityParameters, byArray4, n6);
    }

    private SnmpUsmSecurityParameters createAuthPrivNullParams(SnmpUsmSecurityParameters snmpUsmSecurityParameters) {
        SnmpUsmSecurityParametersImpl snmpUsmSecurityParametersImpl = new SnmpUsmSecurityParametersImpl(snmpUsmSecurityParameters);
        snmpUsmSecurityParametersImpl.setAuthParameters(this.zeroedArray);
        if (logger.finestOn()) {
            logger.finer("createAuthPrivNullParams", "parameters : " + snmpUsmSecurityParametersImpl);
        }
        return snmpUsmSecurityParametersImpl;
    }

    private SnmpUsmSecurityParameters createAuthNullParams(SnmpUsmSecurityParameters snmpUsmSecurityParameters) {
        SnmpUsmSecurityParametersImpl snmpUsmSecurityParametersImpl = new SnmpUsmSecurityParametersImpl(snmpUsmSecurityParameters);
        snmpUsmSecurityParametersImpl.setAuthParameters(this.zeroedArray);
        snmpUsmSecurityParametersImpl.setPrivParameters(snmpUsmSecurityParameters.getPrivParameters());
        if (logger.finestOn()) {
            logger.finer("createAuthNullParams", "parameters : " + snmpUsmSecurityParametersImpl);
        }
        return snmpUsmSecurityParametersImpl;
    }

    byte[] signMsg(SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem, SnmpUsmSecurityParameters snmpUsmSecurityParameters, SnmpUsmSecurityCache snmpUsmSecurityCache, int n, int n2, int n3, byte by, int n4, byte[] byArray) throws SnmpUsmException, SnmpStatusException, SnmpTooBigException, SnmpUnknownMsgProcModelException {
        byte[] byArray2 = new byte[n3];
        int n5 = 0;
        if (logger.finerOn()) {
            logger.finer("signMsg", " Will encode.");
        }
        n5 = snmpMsgProcessingSubSystem.encodePriv(n, n2, n3, by, n4, this.createAuthNullParams(snmpUsmSecurityParameters), byArray, byArray2);
        return this.sign(snmpUsmSecurityCache, snmpUsmSecurityParameters, byArray2, n5);
    }

    private byte[] sign(SnmpUsmSecurityCache snmpUsmSecurityCache, SnmpUsmSecurityParameters snmpUsmSecurityParameters, byte[] byArray, int n) throws SnmpUsmException {
        SnmpUsmAuthPair snmpUsmAuthPair = null;
        if (logger.finerOn()) {
            logger.finer("sign", "Data :" + byArray + " length :" + n + " userName : " + snmpUsmSecurityParameters.getUserName());
        }
        snmpUsmAuthPair = snmpUsmSecurityCache != null ? (snmpUsmSecurityCache.auth == null ? this.lcd.getUserAuthPair(snmpUsmSecurityParameters.getAuthoritativeEngineId(), snmpUsmSecurityParameters.getUserName()) : snmpUsmSecurityCache.auth) : this.lcd.getUserAuthPair(snmpUsmSecurityParameters.getAuthoritativeEngineId(), snmpUsmSecurityParameters.getUserName());
        byte[] byArray2 = snmpUsmAuthPair.algo.sign(snmpUsmAuthPair.key, byArray, n);
        if (logger.finerOn()) {
            logger.finer("sign", " userName : " + snmpUsmSecurityParameters.getUserName() + " /\n HMAC : [" + SnmpTools.binary2ascii(byArray2) + "]");
        }
        return byArray2;
    }

    private void checkHMAC(SnmpUsmSecurityParameters snmpUsmSecurityParameters, byte[] byArray, byte[] byArray2) throws SnmpUsmAuthException {
        int n = byArray.length;
        int n2 = byArray2.length;
        if (n != n2) {
            throw new SnmpUsmAuthException("User " + snmpUsmSecurityParameters.getUserName() + " not authenticated");
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            throw new SnmpUsmAuthException("User " + snmpUsmSecurityParameters.getUserName() + " not authenticated");
        }
        if (logger.finerOn()) {
            logger.finer("checkHMAC", "HMAC [" + SnmpTools.binary2ascii(byArray) + "] is VALID.");
        }
    }
}

