/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm.usmmib;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpIndex;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpMibTable;
import com.sun.management.snmp.usm.SnmpUsmAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmMibTable;
import com.sun.management.snmp.usm.SnmpUsmSecureUser;
import com.sun.management.snmp.usm.usmmib.EnumUsmUserStatus;
import com.sun.management.snmp.usm.usmmib.TableUsmUserTable;
import com.sun.management.snmp.usm.usmmib.UsmUserEntryImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class TableUsmUserTableImpl
extends TableUsmUserTable
implements SnmpUsmMibTable {
    private static final long serialVersionUID = -1488698159987685211L;
    public static final int MAX_USM_USER_NAME_LENGTH = 32;
    SnmpUsmLcd lcd = null;
    SnmpEngine engine = null;
    Hashtable templates = new Hashtable();
    String dbgTag = "TableUsmUserTableImpl";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "TableUsmUserTableImpl");

    public Object createUsmUserEntryMBean(SnmpMibSubRequest snmpMibSubRequest, SnmpOid snmpOid, int n, ObjectName objectName, SnmpMibTable snmpMibTable, Byte[] byteArray, String string) throws SnmpStatusException {
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        if (logger.finestOn()) {
            logger.finest("createUsmUserEntryMBean", "Creating new user : " + string);
        }
        if (string == null || string.length() > 32) {
            if (logger.finestOn()) {
                logger.finest("createUsmUserEntryMBean", "Invalid userName : " + string);
            }
            throw new SnmpStatusException(10);
        }
        SnmpUsmSecureUser snmpUsmSecureUser = null;
        snmpUsmSecureUser = this.lcd.createNewUser(byArray, string);
        snmpUsmSecureUser.setStorageType(3);
        snmpUsmSecureUser.setAuthAlgorithm("1.3.6.1.6.3.10.1.1.1.0");
        snmpUsmSecureUser.setPrivAlgorithm("1.3.6.1.6.3.10.1.2.1.0");
        UsmUserEntryImpl usmUserEntryImpl = this.createUsmUserEntry(this.engine, this.theMib, this.lcd, snmpUsmSecureUser, snmpMibTable);
        return usmUserEntryImpl;
    }

    UsmUserEntryImpl getCloneFromUser(String string) throws SnmpStatusException {
        UsmUserEntryImpl usmUserEntryImpl = null;
        if (logger.finestOn()) {
            logger.finest("getCloneFromUser", "cloneFromUser : " + string);
        }
        if ((usmUserEntryImpl = (UsmUserEntryImpl)this.templates.get(string)) == null) {
            SnmpOid snmpOid = new SnmpOid(string);
            usmUserEntryImpl = (UsmUserEntryImpl)this.meta.getEntry(snmpOid);
        }
        if (logger.finestOn()) {
            logger.finest("getCloneFromUser", "cloneFromUser : " + usmUserEntryImpl);
        }
        return usmUserEntryImpl;
    }

    protected UsmUserEntryImpl createUsmUserEntry(SnmpEngine snmpEngine, SnmpMib snmpMib, SnmpUsmLcd snmpUsmLcd, SnmpUsmSecureUser snmpUsmSecureUser, SnmpMibTable snmpMibTable) {
        return new UsmUserEntryImpl(snmpEngine, this.theMib, snmpUsmLcd, snmpUsmSecureUser, this);
    }

    public void userAdded(SnmpUsmSecureUser snmpUsmSecureUser) {
        block4: {
            if (logger.finestOn()) {
                logger.finest("userAdded", "engineId : " + snmpUsmSecureUser.getEngineId().toString() + "\nname : " + snmpUsmSecureUser.getName() + "\nsecurityName : " + snmpUsmSecureUser.getSecurityName() + "\nauthAlgo : " + this.convertAuthAlgorithm(snmpUsmSecureUser.getAuthPair().algo) + "\nprivAlgo : " + this.convertPrivAlgorithm(snmpUsmSecureUser.getPrivPair().algo) + "\nstorageType : " + snmpUsmSecureUser.getStorageType());
            }
            UsmUserEntryImpl usmUserEntryImpl = new UsmUserEntryImpl(this.engine, this.theMib, this.lcd, snmpUsmSecureUser, this);
            if (this.server != null) {
                usmUserEntryImpl.addInMBeanServer(this.server);
            }
            try {
                this.addEntry(usmUserEntryImpl);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (!logger.finestOn()) break block4;
                logger.finest("userAdded", snmpStatusException);
            }
        }
    }

    public void userUpdated(SnmpUsmSecureUser snmpUsmSecureUser) {
        block7: {
            SnmpOid snmpOid;
            block6: {
                if (logger.finestOn()) {
                    logger.finest("userUpdated", "engineId : " + snmpUsmSecureUser.getEngineId().toString() + "\nname : " + snmpUsmSecureUser.getName() + "\nsecurityName : " + snmpUsmSecureUser.getSecurityName() + "\nauthAlgo : " + this.convertAuthAlgorithm(snmpUsmSecureUser.getAuthPair().algo) + "\nprivAlgo : " + this.convertPrivAlgorithm(snmpUsmSecureUser.getPrivPair().algo) + "\nsorageType : " + snmpUsmSecureUser.getStorageType());
                }
                snmpOid = null;
                byte[] byArray = snmpUsmSecureUser.getEngineId().getBytes();
                Byte[] byteArray = new Byte[byArray.length];
                for (int i = 0; i < byteArray.length; ++i) {
                    byteArray[i] = new Byte(byArray[i]);
                }
                try {
                    snmpOid = this.buildOidFromIndexVal(byteArray, snmpUsmSecureUser.getName());
                }
                catch (SnmpStatusException snmpStatusException) {
                    if (!logger.finestOn()) break block6;
                    logger.finest("userUpdated", snmpStatusException);
                }
            }
            try {
                UsmUserEntryImpl usmUserEntryImpl = (UsmUserEntryImpl)this.meta.getEntry(snmpOid);
                usmUserEntryImpl.setUser(snmpUsmSecureUser);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (!logger.finestOn()) break block7;
                logger.finest("userUpdated", snmpStatusException);
            }
        }
    }

    public void userRemoved(SnmpUsmSecureUser snmpUsmSecureUser) {
        UsmUserEntryImpl usmUserEntryImpl;
        block4: {
            if (logger.finestOn()) {
                logger.finest("userUpdated", "engineId : " + snmpUsmSecureUser.getEngineId().toString() + "\nname : " + snmpUsmSecureUser.getName() + "\nsecurityName : " + snmpUsmSecureUser.getSecurityName() + "\nauthAlgo : " + this.convertAuthAlgorithm(snmpUsmSecureUser.getAuthPair().algo) + "\nprivAlgo : " + this.convertPrivAlgorithm(snmpUsmSecureUser.getPrivPair().algo) + "\nsorageType : " + snmpUsmSecureUser.getStorageType());
            }
            usmUserEntryImpl = new UsmUserEntryImpl(this.engine, this.theMib, this.lcd, snmpUsmSecureUser, this);
            try {
                this.removeEntry(usmUserEntryImpl);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (!logger.finestOn()) break block4;
                logger.finest("userRemoved", snmpStatusException);
            }
        }
        if (this.server != null) {
            usmUserEntryImpl.removeFromMBeanServer(this.server);
        }
    }

    public TableUsmUserTableImpl(SnmpEngine snmpEngine, SnmpMib snmpMib, SnmpUsmLcd snmpUsmLcd) {
        super(snmpMib);
        this.init(snmpUsmLcd, snmpEngine);
    }

    public TableUsmUserTableImpl(SnmpEngine snmpEngine, SnmpMib snmpMib, MBeanServer mBeanServer, SnmpUsmLcd snmpUsmLcd) {
        super(snmpMib, mBeanServer);
        this.init(snmpUsmLcd, snmpEngine);
    }

    public void addEntryCb(int n, SnmpOid snmpOid, ObjectName objectName, Object object, SnmpMibTable snmpMibTable) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("addEntryCb", "");
        }
    }

    public void removeEntryCb(int n, SnmpOid snmpOid, ObjectName objectName, Object object, SnmpMibTable snmpMibTable) throws SnmpStatusException {
        super.removeEntryCb(n, snmpOid, objectName, object, snmpMibTable);
        if (logger.finestOn()) {
            logger.finest("removeEntryCb", "");
        }
        this.lcd.removeUser(((UsmUserEntryImpl)object).getUser().getEngineId(), ((UsmUserEntryImpl)object).getUser().getName(), false);
    }

    private void init(SnmpUsmLcd snmpUsmLcd, SnmpEngine snmpEngine) {
        this.lcd = snmpUsmLcd;
        this.engine = snmpEngine;
        snmpUsmLcd.setMibTable(this);
        Enumeration enumeration = snmpUsmLcd.getAllUsers();
        while (enumeration.hasMoreElements()) {
            String string;
            UsmUserEntryImpl usmUserEntryImpl;
            block14: {
                SnmpUsmSecureUser snmpUsmSecureUser;
                block12: {
                    snmpUsmSecureUser = (SnmpUsmSecureUser)enumeration.nextElement();
                    usmUserEntryImpl = this.createUsmUserEntry(snmpEngine, this.theMib, snmpUsmLcd, snmpUsmSecureUser, this.meta);
                    try {
                        usmUserEntryImpl.setUsmUserStatus(new EnumUsmUserStatus("active"));
                    }
                    catch (Exception exception) {
                        if (!logger.finestOn()) break block12;
                        logger.finest("init", exception);
                    }
                }
                if (logger.finestOn()) {
                    logger.finest("init", "Adding :" + snmpUsmSecureUser.getEngineId().toString() + "/" + snmpUsmSecureUser.getName());
                }
                if (!snmpUsmSecureUser.isTemplate()) {
                    block13: {
                        try {
                            this.addEntry(usmUserEntryImpl);
                            if (logger.finestOn()) {
                                logger.finest("init", "Added :" + snmpUsmSecureUser.getEngineId().toString() + "/" + snmpUsmSecureUser.getName());
                            }
                        }
                        catch (SnmpStatusException snmpStatusException) {
                            if (!logger.finestOn()) break block13;
                            logger.finest("init", snmpStatusException);
                        }
                    }
                    if (this.server == null) continue;
                    usmUserEntryImpl.addInMBeanServer(this.server);
                    continue;
                }
                if (logger.finestOn()) {
                    logger.finest("init", "Template user detected :" + snmpUsmSecureUser.getEngineId().toString() + "/" + snmpUsmSecureUser.getName());
                }
                string = null;
                try {
                    SnmpIndex snmpIndex = this.buildSnmpIndex(usmUserEntryImpl);
                    string = "1.3.6.1.6.3.15.1.2.2.1.3." + this.buildOidFromIndex(snmpIndex).toString();
                    if (logger.finestOn()) {
                        logger.finest("init", "template user oid :" + string);
                    }
                    usmUserEntryImpl.setUsmUserStatus(new EnumUsmUserStatus("active"));
                }
                catch (SnmpStatusException snmpStatusException) {
                    if (!logger.finestOn()) break block14;
                    logger.finest("init", snmpStatusException);
                }
            }
            this.templates.put(string, usmUserEntryImpl);
        }
    }

    private String convertAuthAlgorithm(SnmpUsmAlgorithm snmpUsmAlgorithm) {
        if (snmpUsmAlgorithm == null) {
            return "usmNoAuthProtocol";
        }
        return snmpUsmAlgorithm.getAlgorithm();
    }

    private String convertPrivAlgorithm(SnmpUsmAlgorithm snmpUsmAlgorithm) {
        if (snmpUsmAlgorithm == null) {
            return "usmNoPrivProtocol";
        }
        return snmpUsmAlgorithm.getAlgorithm();
    }
}

