/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.cacao;

import com.sun.cns.basicreg.cacao.CacaoAdapter;
import com.sun.cns.basicreg.cacao.CacaoAdapterException;
import com.sun.scn.jmx.SCNNetworkProxyConfigMBean;
import java.util.logging.Logger;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;

public abstract class NetworkProxyCacaoAdapter
extends CacaoAdapter {
    private static SCNNetworkProxyConfigMBean scnNetworkProxyConfigMBean = null;
    private static final Logger LOG = Logger.getLogger(NetworkProxyCacaoAdapter.class.getName());

    private static SCNNetworkProxyConfigMBean getSCNNetworkProxyConfigMBean() throws CacaoAdapterException {
        if (scnNetworkProxyConfigMBean == null) {
            ObjectName objectName = NetworkProxyCacaoAdapter.getSCNBaseServiceFactoryMBean().getInstanceName("SCNNetworkProxyConfig");
            scnNetworkProxyConfigMBean = MBeanServerInvocationHandler.newProxyInstance(NetworkProxyCacaoAdapter.getMBeanServerConnection(), objectName, SCNNetworkProxyConfigMBean.class, false);
        }
        return scnNetworkProxyConfigMBean;
    }

    public static boolean isProxyValid(String host, String port, String user, String pass) throws CacaoAdapterException {
        return NetworkProxyCacaoAdapter.getSCNNetworkProxyConfigMBean().validate(host == null ? "" : host, port == null ? "" : port, user == null ? "" : user, pass == null ? "" : pass, "");
    }

    public static boolean isProxyEnabled() throws CacaoAdapterException {
        return NetworkProxyCacaoAdapter.getSCNNetworkProxyConfigMBean().getHost() != null;
    }

    public static boolean isProxyAuthEnabled() throws CacaoAdapterException {
        return NetworkProxyCacaoAdapter.getSCNNetworkProxyConfigMBean().getUser() != null;
    }

    public static String getProxyHost() throws CacaoAdapterException {
        LOG.info("SCNNetworkProxyConfigMBean.getHost() = " + NetworkProxyCacaoAdapter.getSCNNetworkProxyConfigMBean().getHost());
        return NetworkProxyCacaoAdapter.getSCNNetworkProxyConfigMBean().getHost();
    }

    public static String getProxyPort() throws CacaoAdapterException {
        LOG.info("SCNNetworkProxyConfigMBean.getPort() = " + NetworkProxyCacaoAdapter.getSCNNetworkProxyConfigMBean().getPort());
        return NetworkProxyCacaoAdapter.getSCNNetworkProxyConfigMBean().getPort();
    }

    public static String getProxyAuthUser() throws CacaoAdapterException {
        LOG.info("SCNNetworkProxyConfigMBean.getUser() = " + NetworkProxyCacaoAdapter.getSCNNetworkProxyConfigMBean().getUser());
        return NetworkProxyCacaoAdapter.getSCNNetworkProxyConfigMBean().getUser();
    }

    public static String getProxyAuthPass() throws CacaoAdapterException {
        LOG.info("SCNNetworkProxyConfigMBean.getPassword() = " + NetworkProxyCacaoAdapter.getSCNNetworkProxyConfigMBean().getPassword());
        return NetworkProxyCacaoAdapter.getSCNNetworkProxyConfigMBean().getPassword();
    }

    public static void setProxy(boolean isProxyEnabled, String proxyHost, String proxyPort, boolean isAuthEnabled, String authUser, String authPass) throws CacaoAdapterException {
        SCNNetworkProxyConfigMBean scnNetworkProxyConfigMBean = NetworkProxyCacaoAdapter.getSCNNetworkProxyConfigMBean();
        LOG.info("SCNNetworkProxyConfigMBean.setHost() = " + (isProxyEnabled ? proxyHost : "null"));
        LOG.info("SCNNetworkProxyConfigMBean.setPort() = " + (isProxyEnabled ? proxyPort : "null"));
        LOG.info("SCNNetworkProxyConfigMBean.setUser() = " + (isProxyEnabled && isAuthEnabled ? authUser : "null"));
        LOG.info("SCNNetworkProxyConfigMBean.setPassword() = " + (isProxyEnabled && isAuthEnabled ? authPass : "null"));
        if (isProxyEnabled) {
            scnNetworkProxyConfigMBean.setHost(proxyHost);
            scnNetworkProxyConfigMBean.setPort(proxyPort);
            if (isAuthEnabled) {
                scnNetworkProxyConfigMBean.setUser(authUser);
                scnNetworkProxyConfigMBean.setPassword(authPass);
            } else {
                scnNetworkProxyConfigMBean.setUser(null);
                scnNetworkProxyConfigMBean.setPassword(null);
            }
        } else {
            scnNetworkProxyConfigMBean.setHost(null);
            scnNetworkProxyConfigMBean.setPort(null);
            scnNetworkProxyConfigMBean.setUser(null);
            scnNetworkProxyConfigMBean.setPassword(null);
        }
    }
}

