/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.cacao;

import com.sun.cns.basicreg.cacao.CacaoAdapter;
import com.sun.cns.basicreg.cacao.CacaoAdapterException;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.scn.base.OfferingCatalogEntryImpl;
import com.sun.scn.base.OfferingCatalogImpl;
import com.sun.scn.common.OfferingCatalog;
import com.sun.scn.common.OfferingCatalogEntry;
import com.sun.scn.jmx.SCNClientConfigMBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Logger;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.w3c.dom.Document;

public class OfferingCacaoAdapter
extends CacaoAdapter {
    private static SCNClientConfigMBean scnClientConfigMBean = null;
    private static ArrayList<OfferingCatalog> _offCatalog = null;
    private static final Logger LOG = Logger.getLogger(OfferingCacaoAdapter.class.getName());
    public static final String SWUP_OFFERING_NAME = "Use Sun Update Manager and Sun Update Connection to manage updates";
    public static final String LOCAL_OFFERING_NAME = "Use Sun Update Manager using a local update source, such as Sun Connection Proxy";
    public static final String PROM_OFFERING_NAME = "Register the Solaris software without choosing an update option";
    private static String activatedOfferingName = null;
    private static final String SWUP_OFFERING_MODULE_NAME = "com.sun.scn.offering.SoftwareUpdate";
    private static final String SWUP_INSTANCE_NAME = "SoftwareUpdateOfferingInstance";
    private static final String PROM_OFFERING_MODULE_NAME = "com.sun.scn.offering.ProductRegistration";
    private static final String PROM_INSTANCE_NAME = "ProductRegOfferingInstance";

    private static SCNClientConfigMBean getSCNClientConfigMBean() throws CacaoAdapterException {
        if (scnClientConfigMBean == null) {
            ObjectName objectName = OfferingCacaoAdapter.getSCNBaseServiceFactoryMBean().getInstanceName("SCNClientConfig");
            scnClientConfigMBean = MBeanServerInvocationHandler.newProxyInstance(OfferingCacaoAdapter.getMBeanServerConnection(), objectName, SCNClientConfigMBean.class, false);
        }
        return scnClientConfigMBean;
    }

    protected static Collection getOfferingCatalogs() throws CacaoAdapterException {
        _offCatalog = (ArrayList)OfferingCacaoAdapter.getSCNClientConfigMBean().getOfferingCatalogs();
        for (int i = 0; i < _offCatalog.size(); ++i) {
            LOG.info("catalog: " + i);
            OfferingCatalog a = _offCatalog.get(i);
            LOG.info("catalog.scopname: " + OfferingCacaoAdapter.getCatalogSCOPName(a));
            LOG.info("catalog.scopURI: " + OfferingCacaoAdapter.getCatalogSCOPURI(a));
        }
        return _offCatalog;
    }

    protected static String getCatalogSCOPName(OfferingCatalog catalog) {
        return catalog.getSCOPName();
    }

    protected static URI getCatalogSCOPURI(OfferingCatalog catalog) {
        return catalog.getSCOPURI();
    }

    protected static Collection getOfferingCatalogEntries(OfferingCatalog catalog) throws CacaoAdapterException {
        ArrayList oelist = (ArrayList)catalog.getOfferings();
        for (int j = 0; j < oelist.size(); ++j) {
            LOG.info("entry: " + j);
            LOG.info("entry name: " + ((OfferingCatalogEntry)oelist.get(j)).getName());
            LOG.info("entry module name: " + ((OfferingCatalogEntry)oelist.get(j)).getModuleName());
            LOG.info("entry instance name: " + ((OfferingCatalogEntry)oelist.get(j)).getInstanceName());
            LOG.info("entry config profile: " + ((OfferingCatalogEntry)oelist.get(j)).getConfigProfile());
        }
        return oelist;
    }

    public static void activate(OfferingCatalogEntry oe, Document config) throws CacaoAdapterException {
        if (activatedOfferingName != null) {
            LOG.info("Before activation, deactivate current activation: " + activatedOfferingName);
            OfferingCacaoAdapter.deactivate(activatedOfferingName);
        }
        LOG.info("OCA activate: " + oe.getName());
        LOG.info("with config: " + (config == null ? "null" : config.toString()));
        try {
            if (config == null) {
                OfferingCacaoAdapter.getSCNClientConfigMBean().activate(oe);
            } else {
                OfferingCacaoAdapter.getSCNClientConfigMBean().activate(oe, config);
            }
        }
        catch (Exception ex) {
            LOG.severe("Error - activating offering: " + oe.getName());
            LOG.severe(ex.getMessage());
            LOG.severe(CommonUtil.getStackTrace(ex));
            throw new CacaoAdapterException("Error: exception during offering activation", ex);
        }
        activatedOfferingName = oe.getName();
    }

    public static void deactivate(OfferingCatalogEntry oe) throws CacaoAdapterException {
        LOG.info("OCA deactivate: " + oe.getName());
        try {
            OfferingCacaoAdapter.getSCNClientConfigMBean().deactivate(oe);
        }
        catch (Exception ex) {
            LOG.severe("Error - deactivating offering: " + oe.getName());
            LOG.severe(ex.getMessage());
            LOG.severe(CommonUtil.getStackTrace(ex));
            throw new CacaoAdapterException("Error: exception during offering deactivation", ex);
        }
        activatedOfferingName = null;
    }

    public static Vector getOfferingNames() throws CacaoAdapterException {
        Vector<String> catalogNames = new Vector<String>();
        ArrayList cats = _offCatalog != null ? _offCatalog : (ArrayList)OfferingCacaoAdapter.getOfferingCatalogs();
        for (int i = 0; i < cats.size(); ++i) {
            ArrayList oe = (ArrayList)OfferingCacaoAdapter.getOfferingCatalogEntries((OfferingCatalog)cats.get(i));
            for (int j = 0; j < oe.size(); ++j) {
                catalogNames.add(((OfferingCatalogEntry)oe.get(j)).getName());
            }
        }
        return catalogNames;
    }

    public static void activate(String offeringName, Document config) throws CacaoAdapterException {
        if (offeringName != null) {
            ArrayList cats = _offCatalog != null ? _offCatalog : (ArrayList)OfferingCacaoAdapter.getOfferingCatalogs();
            for (int i = 0; i < cats.size(); ++i) {
                ArrayList oe = (ArrayList)OfferingCacaoAdapter.getOfferingCatalogEntries((OfferingCatalog)cats.get(i));
                for (int j = 0; j < oe.size(); ++j) {
                    if (!offeringName.equals(((OfferingCatalogEntry)oe.get(j)).getName())) continue;
                    OfferingCacaoAdapter.activate((OfferingCatalogEntry)oe.get(j), config);
                    return;
                }
            }
        }
    }

    public static void deactivate(String offeringName) throws CacaoAdapterException {
        if (offeringName != null) {
            ArrayList cats = _offCatalog != null ? _offCatalog : (ArrayList)OfferingCacaoAdapter.getOfferingCatalogs();
            for (int i = 0; i < cats.size(); ++i) {
                ArrayList oe = (ArrayList)OfferingCacaoAdapter.getOfferingCatalogEntries((OfferingCatalog)cats.get(i));
                for (int j = 0; j < oe.size(); ++j) {
                    if (!offeringName.equals(((OfferingCatalogEntry)oe.get(j)).getName())) continue;
                    OfferingCacaoAdapter.deactivate((OfferingCatalogEntry)oe.get(j));
                    return;
                }
            }
        }
    }

    public static void deactivate() {
        if (activatedOfferingName == null) {
            LOG.info("No currently activated offering to be deactivated");
        }
        try {
            OfferingCacaoAdapter.deactivate(activatedOfferingName);
        }
        catch (Exception ex) {
            LOG.severe("Failure to deactivate currently activated offering: " + activatedOfferingName);
            LOG.severe(ex.getMessage());
            LOG.severe(CommonUtil.getStackTrace(ex));
        }
    }

    public static Vector myGetOfferingNames() throws CacaoAdapterException {
        Vector<String> catalogNames = new Vector<String>();
        ArrayList cats = _offCatalog != null ? _offCatalog : (ArrayList)OfferingCacaoAdapter.myGetOfferingCatalogs();
        for (int i = 0; i < cats.size(); ++i) {
            ArrayList oe = (ArrayList)OfferingCacaoAdapter.getOfferingCatalogEntries((OfferingCatalog)cats.get(i));
            for (int j = 0; j < oe.size(); ++j) {
                catalogNames.add(((OfferingCatalogEntry)oe.get(j)).getName());
            }
        }
        return catalogNames;
    }

    public static void myActivate(String offeringName, Document config) throws CacaoAdapterException {
        if (offeringName != null) {
            ArrayList cats = _offCatalog != null ? _offCatalog : (ArrayList)OfferingCacaoAdapter.myGetOfferingCatalogs();
            for (int i = 0; i < cats.size(); ++i) {
                ArrayList oe = (ArrayList)OfferingCacaoAdapter.getOfferingCatalogEntries((OfferingCatalog)cats.get(i));
                for (int j = 0; j < oe.size(); ++j) {
                    if (!offeringName.equals(((OfferingCatalogEntry)oe.get(j)).getName())) continue;
                    OfferingCacaoAdapter.activate((OfferingCatalogEntry)oe.get(j), config);
                    return;
                }
            }
        }
    }

    public static void myDeactivate(String offeringName) throws CacaoAdapterException {
        if (offeringName != null) {
            ArrayList cats = _offCatalog != null ? _offCatalog : (ArrayList)OfferingCacaoAdapter.myGetOfferingCatalogs();
            for (int i = 0; i < cats.size(); ++i) {
                ArrayList oe = (ArrayList)OfferingCacaoAdapter.getOfferingCatalogEntries((OfferingCatalog)cats.get(i));
                for (int j = 0; j < oe.size(); ++j) {
                    if (!offeringName.equals(((OfferingCatalogEntry)oe.get(j)).getName())) continue;
                    OfferingCacaoAdapter.deactivate((OfferingCatalogEntry)oe.get(j));
                    return;
                }
            }
        }
    }

    public static void myDeactivate() {
        if (activatedOfferingName == null) {
            LOG.info("No currently activated offering to be deactivated");
        }
        try {
            OfferingCacaoAdapter.myDeactivate(activatedOfferingName);
        }
        catch (Exception ex) {
            LOG.severe("Failure to deactivate currently activated offering: " + activatedOfferingName);
            LOG.severe(ex.getMessage());
            LOG.severe(CommonUtil.getStackTrace(ex));
        }
    }

    protected static Collection myGetOfferingCatalogs() {
        LOG.info("Get offering catalogs without scn connection");
        ArrayList<OfferingCatalogImpl> list = new ArrayList<OfferingCatalogImpl>();
        OfferingCatalogImpl cat = new OfferingCatalogImpl();
        cat.setSCOPName("Sun Connection Network");
        list.add(cat);
        OfferingCatalogEntryImpl entry = new OfferingCatalogEntryImpl();
        entry.setName(SWUP_OFFERING_NAME);
        entry.setModuleName(SWUP_OFFERING_MODULE_NAME);
        entry.setInstanceName(SWUP_INSTANCE_NAME);
        cat.addOffering((OfferingCatalogEntry)entry);
        entry = new OfferingCatalogEntryImpl();
        entry.setName(LOCAL_OFFERING_NAME);
        entry.setModuleName(SWUP_OFFERING_MODULE_NAME);
        entry.setInstanceName(SWUP_INSTANCE_NAME);
        cat.addOffering((OfferingCatalogEntry)entry);
        entry = new OfferingCatalogEntryImpl();
        entry.setName(PROM_OFFERING_NAME);
        entry.setModuleName(PROM_OFFERING_MODULE_NAME);
        entry.setInstanceName(PROM_INSTANCE_NAME);
        cat.addOffering((OfferingCatalogEntry)entry);
        return list;
    }
}

