/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.cacao;

import com.sun.cns.basicreg.cacao.CacaoAdapter;
import com.sun.cns.basicreg.cacao.CacaoAdapterException;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.scn.offering.prom.AssetRegistrationException;
import com.sun.scn.offering.swupom.SWUPOfferingFactoryMBean;
import com.sun.scn.offering.swupom.SWUPOfferingInstanceMBean;
import com.sun.scn.util.Utils;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class SWUPOMCacaoAdapter
extends CacaoAdapter {
    public static final int FULL_SYSTEM_INFORMATION = 1;
    public static final int LIMITED_SYSTEM_INFORMATION = 2;
    public static final int NO_REGISTER_RESULT = -1;
    public static final int OK_REGISTER_RESULT = 0;
    public static final int ENTITLEMENT_INVALID_REGISTER_RESULT = 1;
    public static final int ENTITLEMENT_IN_USE_REGISTER_RESULT = 2;
    public static final int REMOTE_FAULT_REGISTER_RESULT = 3;
    private static final Logger LOG = Logger.getLogger(SWUPOMCacaoAdapter.class.getName());
    private static SWUPOfferingFactoryMBean swupOfferingFactoryMBean = null;
    private static SWUPOfferingInstanceMBean swupOfferingInstanceMBean = null;
    private static String lpsURLString = "";
    private static String subscriptionKey = "";
    private static String systemDisplayName = "";
    private static boolean isSWUPPortalEnabled = false;

    protected static SWUPOfferingFactoryMBean getSWUPOfferingFactoryMBean() throws CacaoAdapterException {
        if (swupOfferingFactoryMBean == null) {
            Hashtable<String, String> map = new Hashtable<String, String>();
            map.put("name", "SWUPOfferingFactory");
            map.put("host", Utils.getLocalHostNames()[0]);
            map.put("Vendor", "Sun Microsystems Inc");
            map.put("scnType", "OfferingFactory");
            map.put("assetProfile", "OperatingSystem");
            map.put("assetSubProfile", "TODO");
            ObjectName objectName = null;
            try {
                objectName = new ObjectName("com.sun.scn", map);
            }
            catch (MalformedObjectNameException monEx) {
                LOG.severe("Error: unable to obtain SWUPOfferingFactoryMBean");
                LOG.severe(CommonUtil.getStackTrace(monEx));
                LOG.severe(monEx.getMessage());
                throw new CacaoAdapterException("Error: unable to obtain SWUPOfferingFactoryMBean", monEx);
            }
            LOG.info("\nSWUPOfferingFactory ObjectName =\n\t" + objectName.getCanonicalName());
            swupOfferingFactoryMBean = MBeanServerInvocationHandler.newProxyInstance(SWUPOMCacaoAdapter.getMBeanServerConnection(), objectName, SWUPOfferingFactoryMBean.class, false);
        }
        return swupOfferingFactoryMBean;
    }

    private static SWUPOfferingInstanceMBean getSWUPOfferingInstanceMBean() throws CacaoAdapterException {
        if (swupOfferingInstanceMBean == null) {
            ObjectName workaroundObjectName = SWUPOMCacaoAdapter.getSWUPOfferingFactoryMBean().getOfferingInstanceName("SWUPOfferingInstance");
            swupOfferingInstanceMBean = MBeanServerInvocationHandler.newProxyInstance(SWUPOMCacaoAdapter.getMBeanServerConnection(), workaroundObjectName, SWUPOfferingInstanceMBean.class, false);
        }
        return swupOfferingInstanceMBean;
    }

    public static void setSubscriptionKey(String subKey) throws CacaoAdapterException {
        if (subKey == null) {
            subKey = new String("");
        }
        SWUPOMCacaoAdapter.getSWUPOfferingInstanceMBean().setSubscriptionKey(subKey);
        subscriptionKey = subKey;
    }

    public static String getAMSSystemDisplayName() throws CacaoAdapterException {
        String sysName;
        try {
            sysName = SWUPOMCacaoAdapter.getSWUPOfferingInstanceMBean().getSystemDisplayNameFromAMS(SWUPOMCacaoAdapter.getSWUPOfferingInstanceMBean().getAssetId());
        }
        catch (AssetRegistrationException ex) {
            LOG.severe("Error: SWUPOM getSystemDisplayNameFromAMS() exception: " + ex.getMessage());
            LOG.severe(CommonUtil.getStackTrace(ex));
            throw new CacaoAdapterException("Error: exception getting SWUPOM AMS system display name", ex);
        }
        LOG.info("SWUPOfferingInstanceMBean.getAMSSystemDisplayName(): " + sysName);
        return sysName;
    }

    public static String getSystemDisplayName() throws CacaoAdapterException {
        String sysName = SWUPOMCacaoAdapter.getSWUPOfferingInstanceMBean().getSystemDisplayName();
        LOG.info("SWUPOfferingInstanceMBean.getSystemDisplayName(): " + sysName);
        return sysName;
    }

    public static void setSystemDisplayName(String sysName) throws CacaoAdapterException {
        if (sysName == null) {
            sysName = new String("");
        }
        LOG.info("CALL SWUPOfferingInstanceMBean.setSystemDisplayName(): " + sysName);
        SWUPOMCacaoAdapter.getSWUPOfferingInstanceMBean().setSystemDisplayName(sysName);
        systemDisplayName = sysName;
    }

    public static void setSWUPPortalEnabled(boolean isEnabled) throws CacaoAdapterException {
        LOG.info("CALL SWUPOfferingInstanceMBean.setSWUPPortalEnableKey(): " + isEnabled);
        SWUPOMCacaoAdapter.getSWUPOfferingInstanceMBean().setSWUPPortalEnableKey(isEnabled);
        isSWUPPortalEnabled = isEnabled;
    }

    public static String getLPSURL() {
        return lpsURLString;
    }

    public static void setLPSURL(String lpsURLStr) throws CacaoAdapterException {
        if (lpsURLStr == null) {
            lpsURLStr = new String("");
        }
        SWUPOMCacaoAdapter.getSWUPOfferingInstanceMBean().setLocalPatchSourceURL(lpsURLStr);
        lpsURLString = lpsURLStr;
        LOG.info("Set LPS URL to: " + lpsURLString);
    }

    public static int registerSystem() throws CacaoAdapterException {
        LOG.info("CALL SWUPOfferingInstanceMBean.register()");
        try {
            SWUPOMCacaoAdapter.getSWUPOfferingInstanceMBean().register();
        }
        catch (AssetRegistrationException ex) {
            LOG.severe("Error: SWUPOM register() exception: " + ex.getMessage());
            LOG.severe(CommonUtil.getStackTrace(ex));
            return SWUPOMCacaoAdapter.getRegisterResult(ex.getMessage());
        }
        return 0;
    }

    private static int getRegisterResult(String promFault) {
        LOG.info("SWUPOM Fault: " + promFault);
        if (promFault == null) {
            return -1;
        }
        if (promFault.indexOf("InvalidEntitlementCodeException") >= 0) {
            return 1;
        }
        if (promFault.indexOf("EntitlementCodeAlreadyInUseException") >= 0) {
            return 2;
        }
        if (promFault.indexOf("RemoteException") > 0) {
            return 3;
        }
        return -1;
    }
}

