/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.common;

import java.util.logging.Logger;

public class Semaphore {
    private int counter;
    private static final Logger LOG = Logger.getLogger(Semaphore.class.getName());

    public Semaphore() {
        this(0);
    }

    public Semaphore(int i) {
        if (i < 0) {
            throw new IllegalArgumentException(i + " < 0");
        }
        this.counter = i;
    }

    public synchronized void release() {
        LOG.info("release() called!");
        if (this.counter == 0) {
            this.notify();
        }
        ++this.counter;
    }

    public synchronized void acquire() throws InterruptedException {
        LOG.info("acquire() called!");
        while (this.counter == 0) {
            this.wait();
        }
        --this.counter;
    }
}

