/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.tcp;

import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterDeployer;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.ClusterValve;
import org.apache.catalina.ha.session.ClusterSessionListener;
import org.apache.catalina.ha.session.DeltaManager;
import org.apache.catalina.ha.session.JvmRouteBinderValve;
import org.apache.catalina.ha.session.JvmRouteSessionIDBinderListener;
import org.apache.catalina.ha.session.SessionMessage;
import org.apache.catalina.ha.tcp.ReplicationValve;
import org.apache.catalina.ha.tcp.SendMessageData;
import org.apache.catalina.ha.util.IDynamicProperty;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.group.interceptors.MessageDispatch15Interceptor;
import org.apache.catalina.tribes.group.interceptors.TcpFailureDetector;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;

public class SimpleTcpCluster
implements CatalinaCluster,
Lifecycle,
LifecycleListener,
IDynamicProperty,
MembershipListener,
ChannelListener {
    public static Log log = LogFactory.getLog(SimpleTcpCluster.class);
    protected static final String info = "SimpleTcpCluster/2.2";
    public static final String BEFORE_MEMBERREGISTER_EVENT = "before_member_register";
    public static final String AFTER_MEMBERREGISTER_EVENT = "after_member_register";
    public static final String BEFORE_MANAGERREGISTER_EVENT = "before_manager_register";
    public static final String AFTER_MANAGERREGISTER_EVENT = "after_manager_register";
    public static final String BEFORE_MANAGERUNREGISTER_EVENT = "before_manager_unregister";
    public static final String AFTER_MANAGERUNREGISTER_EVENT = "after_manager_unregister";
    public static final String BEFORE_MEMBERUNREGISTER_EVENT = "before_member_unregister";
    public static final String AFTER_MEMBERUNREGISTER_EVENT = "after_member_unregister";
    public static final String SEND_MESSAGE_FAILURE_EVENT = "send_message_failure";
    public static final String RECEIVE_MESSAGE_FAILURE_EVENT = "receive_message_failure";
    protected Channel channel = new GroupChannel();
    protected String clusterImpName = "SimpleTcpCluster";
    protected StringManager sm = StringManager.getManager((String)"org.apache.catalina.ha.tcp");
    protected String clusterName;
    protected boolean heartbeatBackgroundEnabled = false;
    protected Container container = null;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Map managers = new HashMap();
    protected ClusterManager managerTemplate = new DeltaManager();
    private List valves = new ArrayList();
    private ClusterDeployer clusterDeployer;
    protected List clusterListeners = new ArrayList();
    private boolean notifyLifecycleListenerOnFailure = false;
    private Map properties = new HashMap();
    private int channelSendOptions = 8;
    private int channelStartOptions = 15;
    protected boolean hasMembers = false;

    public String getInfo() {
        return info;
    }

    public boolean isHeartbeatBackgroundEnabled() {
        return this.heartbeatBackgroundEnabled;
    }

    public void setHeartbeatBackgroundEnabled(boolean heartbeatBackgroundEnabled) {
        this.heartbeatBackgroundEnabled = heartbeatBackgroundEnabled;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        if (this.clusterName == null && this.container != null) {
            return this.container.getName();
        }
        return this.clusterName;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public Container getContainer() {
        return this.container;
    }

    public boolean isNotifyLifecycleListenerOnFailure() {
        return this.notifyLifecycleListenerOnFailure;
    }

    public void setNotifyLifecycleListenerOnFailure(boolean notifyListenerOnFailure) {
        boolean oldNotifyListenerOnFailure = this.notifyLifecycleListenerOnFailure;
        this.notifyLifecycleListenerOnFailure = notifyListenerOnFailure;
        this.support.firePropertyChange("notifyLifecycleListenerOnFailure", oldNotifyListenerOnFailure, this.notifyLifecycleListenerOnFailure);
    }

    public String getManagerClassName() {
        return this.managerTemplate.getClass().getName();
    }

    public void setManagerClassName(String managerClassName) {
        log.warn((Object)"setManagerClassName is deprecated, use nested <Manager> element inside the <Cluster> element instead, this request will be ignored.");
    }

    public void addValve(Valve valve) {
        if (valve instanceof ClusterValve && !this.valves.contains(valve)) {
            this.valves.add(valve);
        }
    }

    public Valve[] getValves() {
        return this.valves.toArray(new Valve[this.valves.size()]);
    }

    public ClusterListener[] findClusterListeners() {
        if (this.clusterListeners.size() > 0) {
            ClusterListener[] listener = new ClusterListener[this.clusterListeners.size()];
            this.clusterListeners.toArray(listener);
            return listener;
        }
        return new ClusterListener[0];
    }

    public void addClusterListener(ClusterListener listener) {
        if (listener != null && !this.clusterListeners.contains(listener)) {
            this.clusterListeners.add(listener);
            listener.setCluster(this);
        }
    }

    public void removeClusterListener(ClusterListener listener) {
        if (listener != null) {
            this.clusterListeners.remove(listener);
            listener.setCluster(null);
        }
    }

    public ClusterDeployer getClusterDeployer() {
        return this.clusterDeployer;
    }

    public void setClusterDeployer(ClusterDeployer clusterDeployer) {
        this.clusterDeployer = clusterDeployer;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setManagerTemplate(ClusterManager managerTemplate) {
        this.managerTemplate = managerTemplate;
    }

    public void setChannelSendOptions(int channelSendOptions) {
        this.channelSendOptions = channelSendOptions;
    }

    public boolean hasMembers() {
        return this.hasMembers;
    }

    public Member[] getMembers() {
        return this.channel.getMembers();
    }

    public Member getLocalMember() {
        return this.channel.getLocalMember(true);
    }

    public boolean setProperty(String name, String value) {
        return this.setProperty(name, (Object)value);
    }

    public boolean setProperty(String name, Object value) {
        this.properties.put(name, value);
        return false;
    }

    public Object getProperty(String key) {
        if (log.isTraceEnabled()) {
            log.trace((Object)this.sm.getString("SimpleTcpCluster.getProperty", (Object)key));
        }
        return this.properties.get(key);
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    protected void transferProperty(String prefix, Object bean) {
        if (prefix != null) {
            Iterator iter = this.getPropertyNames();
            while (iter.hasNext()) {
                String pkey = (String)iter.next();
                if (!pkey.startsWith(prefix)) continue;
                String key = pkey.substring(prefix.length() + 1);
                Object value = this.getProperty(pkey);
                IntrospectionUtils.setProperty((Object)bean, (String)key, (String)value.toString());
            }
        }
    }

    public Map getManagers() {
        return this.managers;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ClusterManager getManagerTemplate() {
        return this.managerTemplate;
    }

    public int getChannelSendOptions() {
        return this.channelSendOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Manager createManager(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating ClusterManager for context " + name + " using class " + this.getManagerClassName()));
        }
        ClusterManager manager = null;
        try {
            manager = this.managerTemplate.cloneFromTemplate();
            manager.setName(name);
        }
        catch (Exception x) {
            log.error((Object)"Unable to clone cluster manager, defaulting to org.apache.catalina.ha.session.DeltaManager", (Throwable)x);
            manager = new DeltaManager();
        }
        finally {
            if (manager != null && manager instanceof ClusterManager) {
                manager.setCluster(this);
            }
        }
        return manager;
    }

    public void registerManager(Manager manager) {
        if (!(manager instanceof ClusterManager)) {
            log.warn((Object)("Manager [ " + manager + "] does not implement ClusterManager, addition to cluster has been aborted."));
            return;
        }
        ClusterManager cmanager = (ClusterManager)manager;
        this.lifecycle.fireLifecycleEvent(BEFORE_MANAGERREGISTER_EVENT, (Object)manager);
        String clusterName = this.getManagerName(cmanager.getName(), manager);
        cmanager.setName(clusterName);
        cmanager.setCluster(this);
        cmanager.setDefaultMode(false);
        this.managers.put(clusterName, manager);
        this.lifecycle.fireLifecycleEvent(AFTER_MANAGERREGISTER_EVENT, (Object)manager);
    }

    public void removeManager(Manager manager) {
        if (manager != null && manager instanceof ClusterManager) {
            ClusterManager cmgr = (ClusterManager)manager;
            this.lifecycle.fireLifecycleEvent(BEFORE_MANAGERUNREGISTER_EVENT, (Object)manager);
            this.managers.remove(this.getManagerName(cmgr.getName(), manager));
            cmgr.setCluster(null);
            this.lifecycle.fireLifecycleEvent(AFTER_MANAGERUNREGISTER_EVENT, (Object)manager);
        }
    }

    public String getManagerName(String name, Manager manager) {
        Context context;
        Container host;
        String clusterName = name;
        if (clusterName == null) {
            clusterName = manager.getContainer().getName();
        }
        if (this.getContainer() instanceof Engine && (host = (context = (Context)manager.getContainer()).getParent()) instanceof Host && clusterName != null && !clusterName.startsWith(host.getName() + "#")) {
            clusterName = host.getName() + "#" + clusterName;
        }
        return clusterName;
    }

    public Manager getManager(String name) {
        return (Manager)this.managers.get(name);
    }

    public void backgroundProcess() {
        if (this.clusterDeployer != null) {
            this.clusterDeployer.backgroundProcess();
        }
        if (this.isHeartbeatBackgroundEnabled() && this.channel != null) {
            this.channel.heartbeat();
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if (log.isTraceEnabled()) {
            log.trace((Object)this.sm.getString("SimpleTcpCluster.event.log", (Object)lifecycleEvent.getType(), lifecycleEvent.getData()));
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("cluster.alreadyStarted"));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Cluster is about to start");
        }
        this.lifecycle.fireLifecycleEvent("before_start", (Object)this);
        try {
            this.checkDefaults();
            this.registerClusterValve();
            this.channel.addMembershipListener((MembershipListener)this);
            this.channel.addChannelListener((ChannelListener)this);
            this.channel.start(this.channelStartOptions);
            if (this.clusterDeployer != null) {
                this.clusterDeployer.start();
            }
            this.started = true;
            this.lifecycle.fireLifecycleEvent("after_start", (Object)this);
        }
        catch (Exception x) {
            log.error((Object)"Unable to start cluster.", (Throwable)x);
            throw new LifecycleException((Throwable)x);
        }
    }

    protected void checkDefaults() {
        if (this.clusterListeners.size() == 0) {
            this.addClusterListener(new JvmRouteSessionIDBinderListener());
            this.addClusterListener(new ClusterSessionListener());
        }
        if (this.valves.size() == 0) {
            this.addValve(new JvmRouteBinderValve());
            this.addValve(new ReplicationValve());
        }
        if (this.clusterDeployer != null) {
            this.clusterDeployer.setCluster(this);
        }
        if (this.channel == null) {
            this.channel = new GroupChannel();
        }
        if (this.channel instanceof GroupChannel && !((GroupChannel)this.channel).getInterceptors().hasNext()) {
            this.channel.addInterceptor((ChannelInterceptor)new MessageDispatch15Interceptor());
            this.channel.addInterceptor((ChannelInterceptor)new TcpFailureDetector());
        }
    }

    protected void registerClusterValve() throws Exception {
        if (this.container != null) {
            for (ClusterValve valve : this.valves) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoking addValve on " + this.getContainer() + " with class=" + valve.getClass().getName()));
                }
                if (valve != null) {
                    IntrospectionUtils.callMethodN((Object)this.getContainer(), (String)"addValve", (Object[])new Object[]{valve}, (Class[])new Class[]{Valve.class});
                }
                valve.setCluster(this);
            }
        }
    }

    protected void unregisterClusterValve() throws Exception {
        for (ClusterValve valve : this.valves) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking removeValve on " + this.getContainer() + " with class=" + valve.getClass().getName()));
            }
            if (valve != null) {
                IntrospectionUtils.callMethodN((Object)this.getContainer(), (String)"removeValve", (Object[])new Object[]{valve}, (Class[])new Class[]{Valve.class});
            }
            valve.setCluster(this);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new IllegalStateException(this.sm.getString("cluster.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("before_stop", (Object)this);
        if (this.clusterDeployer != null) {
            this.clusterDeployer.stop();
        }
        this.managers.clear();
        try {
            if (this.clusterDeployer != null) {
                this.clusterDeployer.setCluster(null);
            }
            this.channel.stop(this.channelStartOptions);
            this.channel.removeChannelListener((ChannelListener)this);
            this.channel.removeMembershipListener((MembershipListener)this);
            this.unregisterClusterValve();
        }
        catch (Exception x) {
            log.error((Object)"Unable to stop cluster valve.", (Throwable)x);
        }
        this.started = false;
        this.lifecycle.fireLifecycleEvent("after_stop", (Object)this);
    }

    public void send(ClusterMessage msg) {
        this.send(msg, null);
    }

    public void sendClusterDomain(ClusterMessage msg) {
        this.send(msg, null);
    }

    public void send(ClusterMessage msg, Member dest) {
        try {
            msg.setAddress(this.getLocalMember());
            int sendOptions = this.channelSendOptions;
            if (msg instanceof SessionMessage && ((SessionMessage)msg).getEventType() == 12) {
                sendOptions = 6;
            }
            if (dest != null) {
                if (!this.getLocalMember().equals(dest)) {
                    this.channel.send(new Member[]{dest}, (Serializable)msg, sendOptions);
                } else {
                    log.error((Object)("Unable to send message to local member " + msg));
                }
            } else if (this.channel.getMembers().length > 0) {
                this.channel.send(this.channel.getMembers(), (Serializable)msg, sendOptions);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No members in cluster, ignoring message:" + msg));
            }
        }
        catch (Exception x) {
            log.error((Object)"Unable to send message through cluster sender.", (Throwable)x);
        }
    }

    public void memberAdded(Member member) {
        try {
            this.hasMembers = this.channel.hasMembers();
            if (log.isInfoEnabled()) {
                log.info((Object)("Replication member added:" + member));
            }
            this.lifecycle.fireLifecycleEvent(BEFORE_MEMBERREGISTER_EVENT, (Object)member);
            this.lifecycle.fireLifecycleEvent(AFTER_MEMBERREGISTER_EVENT, (Object)member);
        }
        catch (Exception x) {
            log.error((Object)"Unable to connect to replication system.", (Throwable)x);
        }
    }

    public void memberDisappeared(Member member) {
        try {
            this.hasMembers = this.channel.hasMembers();
            if (log.isInfoEnabled()) {
                log.info((Object)("Received member disappeared:" + member));
            }
            this.lifecycle.fireLifecycleEvent(BEFORE_MEMBERUNREGISTER_EVENT, (Object)member);
            this.lifecycle.fireLifecycleEvent(AFTER_MEMBERUNREGISTER_EVENT, (Object)member);
        }
        catch (Exception x) {
            log.error((Object)"Unable remove cluster node from replication system.", (Throwable)x);
        }
    }

    public boolean accept(Serializable msg, Member sender) {
        return msg instanceof ClusterMessage;
    }

    public void messageReceived(Serializable message, Member sender) {
        ClusterMessage fwd = (ClusterMessage)message;
        fwd.setAddress(sender);
        this.messageReceived(fwd);
    }

    public void messageReceived(ClusterMessage message) {
        long start = 0L;
        if (log.isDebugEnabled() && message != null) {
            log.debug((Object)("Assuming clocks are synched: Replication for " + message.getUniqueId() + " took=" + (System.currentTimeMillis() - message.getTimestamp()) + " ms."));
        }
        boolean accepted = false;
        if (message != null) {
            for (ClusterListener listener : this.clusterListeners) {
                if (!listener.accept(message)) continue;
                accepted = true;
                listener.messageReceived(message);
            }
        }
        if (!accepted && log.isDebugEnabled()) {
            if (this.notifyLifecycleListenerOnFailure) {
                Member dest = message.getAddress();
                this.lifecycle.fireLifecycleEvent(RECEIVE_MESSAGE_FAILURE_EVENT, (Object)new SendMessageData(message, dest, null));
            }
            log.debug((Object)("Message " + message.toString() + " from type " + message.getClass().getName() + " transfered but no listener registered"));
        }
    }

    public Log getLogger() {
        return log;
    }

    public void setProtocol(String protocol) {
    }

    public String getProtocol() {
        return null;
    }

    public int getChannelStartOptions() {
        return this.channelStartOptions;
    }

    public void setChannelStartOptions(int channelStartOptions) {
        this.channelStartOptions = channelStartOptions;
    }
}

