/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.multitabs.ButtonFactory;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.TabDisplayer;
import org.netbeans.core.multitabs.impl.ControlsToolbar;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.multitabs.impl.ScrollAction;
import org.netbeans.core.multitabs.impl.TabTableUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;

abstract class AbstractTabDisplayer
extends TabDisplayer
implements MouseWheelListener,
Autoscroll {
    protected Controller controller;
    protected final JScrollPane scrollPane;
    protected final int orientation;
    private final JToolBar controls;
    private final JLabel lblFullPath = new JLabel();
    private final ScrollAction scrollLeft;
    private final ScrollAction scrollRight;
    private final ChangeListener fullPathListener;
    private final ChangeListener projectsListener;
    private final Autoscroller autoscroller = new Autoscroller();

    public AbstractTabDisplayer(TabDataModel tabDataModel, int n) {
        super(tabDataModel);
        this.setLayout(new BorderLayout(3, 3));
        this.orientation = n == 1 || n == 3 ? 0 : 1;
        this.scrollPane = new JScrollPane();
        this.controls = new ControlsToolbar();
        this.lblFullPath.setBorder(BorderFactory.createEmptyBorder(0, 3, 2, 3));
        Font font = this.lblFullPath.getFont();
        this.lblFullPath.setFont(font.deriveFont(font.getSize2D() - 2.0f));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        if (TabTableUI.IS_AQUA) {
            Color color = UIManager.getColor("NbSplitPane.background");
            if (null != color) {
                this.setBackground(color);
                this.setOpaque(true);
            }
            Color color2 = Color.white;
            color2 = color2.darker();
            this.lblFullPath.setForeground(color2);
        }
        switch (n) {
            case 1: 
            case 3: {
                this.add((Component)this.scrollPane, "Center");
                jPanel.add((Component)this.controls, "North");
                this.add((Component)jPanel, "East");
                if (!Settings.getDefault().isShowFullPath()) break;
                this.add((Component)this.lblFullPath, "South");
                break;
            }
            case 2: 
            case 4: {
                this.add((Component)this.scrollPane, "Center");
                jPanel.add((Component)this.controls, "East");
                this.add((Component)jPanel, "North");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid orientation: " + n);
            }
        }
        this.configureScrollPane(this.scrollPane);
        this.scrollLeft = new ScrollAction(this.scrollPane, n, true);
        this.scrollRight = new ScrollAction(this.scrollPane, n, false);
        this.controls.add(ButtonFactory.createScrollLeftButton(this.scrollLeft));
        this.controls.add(ButtonFactory.createScrollRightButton(this.scrollRight));
        this.addMouseWheelListener(this);
        this.projectsListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AbstractTabDisplayer.this.repaint();
            }
        };
        this.fullPathListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTabDisplayer.this.updateFullPath();
                    }
                });
            }
        };
        tabDataModel.addChangeListener(this.fullPathListener);
    }

    private void configureScrollPane(JScrollPane jScrollPane) {
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setFocusable(false);
        jScrollPane.setWheelScrollingEnabled(false);
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                AbstractTabDisplayer.this.showSelectedTab();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    @Override
    public void attach(Controller controller) {
        this.controller = controller;
        this.controls.add(ButtonFactory.createDropDownButton(controller));
        this.controls.add(ButtonFactory.createMaximizeButton(controller));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ProjectSupport projectSupport = ProjectSupport.getDefault();
        if (projectSupport.isEnabled()) {
            projectSupport.addChangeListener(this.projectsListener);
        }
        if (null != this.controller) {
            this.controller.addSelectionChangeListener(this.fullPathListener);
        }
        this.updateFullPath();
    }

    @Override
    public void removeNotify() {
        ProjectSupport.getDefault().removeChangeListener(this.projectsListener);
        super.removeNotify();
        if (null != this.controller) {
            this.controller.removeSelectionChangeListener(this.fullPathListener);
        }
    }

    private void updateFullPath() {
        TabData tabData;
        if (!this.lblFullPath.isVisible() || null == this.controller) {
            return;
        }
        String string = null;
        int n = this.controller.getSelectedIndex();
        if (n >= 0 && n < this.tabModel.size() && null != (tabData = this.tabModel.getTab(n))) {
            string = tabData.getTooltip();
        }
        this.lblFullPath.setText(string);
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.scrollLeft.mouseWheelMoved(mouseWheelEvent);
        if (mouseWheelEvent.isConsumed()) {
            return;
        }
        this.scrollRight.mouseWheelMoved(mouseWheelEvent);
    }

    private void showSelectedTab() {
        if (null == this.controller) {
            return;
        }
        int n = this.controller.getSelectedIndex();
        if (n < 0 || n >= this.controller.getTabModel().size()) {
            return;
        }
        Rectangle rectangle = this.getTabBounds(n);
        if (null == rectangle) {
            return;
        }
        this.scrollPane.getViewport().scrollRectToVisible(rectangle);
    }

    @Override
    public Rectangle getTabsArea() {
        return this.scrollPane.getBounds();
    }

    @Override
    public Insets getAutoscrollInsets() {
        if (this.orientation == 0) {
            return new Insets(0, 25, 0, 25);
        }
        return new Insets(25, 0, 25, 0);
    }

    @Override
    public void autoscroll(Point point) {
        Rectangle rectangle = this.getTabsArea();
        if (!rectangle.contains(point)) {
            this.autoscroller.stop();
            return;
        }
        if (this.orientation == 0) {
            if (point.x < rectangle.x + 25) {
                this.autoscroller.start(true);
            } else if (point.x > rectangle.x + rectangle.width - 25) {
                this.autoscroller.start(false);
            } else {
                this.autoscroller.stop();
            }
        } else if (point.y < rectangle.y + 25) {
            this.autoscroller.start(true);
        } else if (point.y > rectangle.y + rectangle.height - 25) {
            this.autoscroller.start(false);
        } else {
            this.autoscroller.stop();
        }
    }

    private class Autoscroller
    implements ActionListener {
        private int direction = 0;
        private Timer timer;

        private Autoscroller() {
        }

        public void start(boolean bl) {
            int n;
            int n2 = n = bl ? -1 : 1;
            if (null == this.timer || !this.timer.isRunning() || this.direction != n) {
                if (null == this.timer) {
                    this.timer = new Timer(300, this);
                    this.timer.setRepeats(true);
                }
                this.direction = n;
                this.timer.start();
            }
        }

        public void stop() {
            if (null != this.timer) {
                this.timer.stop();
            }
            this.direction = 0;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.direction < 0) {
                if (AbstractTabDisplayer.this.scrollLeft.isEnabled()) {
                    AbstractTabDisplayer.this.scrollLeft.actionPerformed(actionEvent);
                } else {
                    this.timer.stop();
                }
            } else if (this.direction > 0) {
                if (AbstractTabDisplayer.this.scrollRight.isEnabled()) {
                    AbstractTabDisplayer.this.scrollRight.actionPerformed(actionEvent);
                } else {
                    this.timer.stop();
                }
            }
        }
    }
}

