/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oic.oics;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsCheckPointIndexReader;
import oracle.sysman.oic.oics.OicsCheckPointIndexReaderFailedChecks;
import oracle.sysman.oic.oics.OicsCheckPointSession;
import oracle.sysman.oic.oics.OicsCheckPointUtil;
import oracle.sysman.oic.oics.OicsICheckPointIndexSession;
import oracle.sysman.oic.oics.OicsICheckPointSession;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OicsCheckPointIndexSession
implements OicsICheckPointIndexSession {
    public String component;
    public String oracleBase;
    public String indexLoc;
    public Vector checkPointSessions = null;
    private static HashMap checkPointSession_List = null;
    public HashMap m_failedCheckPointFiles = null;
    public HashMap m_allCheckPointFiles = null;
    private String sFileName = "";

    public OicsCheckPointIndexSession(String oracleBase, String component) {
        this.oracleBase = oracleBase;
        this.component = component;
        this.sFileName = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)oracleBase, (String)"checkpoints"));
        this.sFileName = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)this.sFileName, (String)component));
        this.indexLoc = this.sFileName = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)this.sFileName, (String)"index.xml"));
        if (this.isIndexFileExists()) {
            OiiolTextLogger.appendText((String)("Checkpoint:Index file :" + this.sFileName + " found."));
            OicsCheckPointIndexReader chkPointIndxReader = new OicsCheckPointIndexReader(this.indexLoc);
            try {
                chkPointIndxReader.buildIndex();
            }
            catch (OicsCheckPointException oce) {
                OiiolTextLogger.appendText((String)("Checkpoint:" + oce.getMessage()));
            }
            if (OicsCheckPointIndexReader.m_allCheckPointFiles != null) {
                this.m_allCheckPointFiles = new HashMap();
                this.m_allCheckPointFiles.putAll(OicsCheckPointIndexReader.m_allCheckPointFiles);
                Set keySet = this.m_allCheckPointFiles.keySet();
                Iterator iter = keySet.iterator();
                OicsCheckPointUtil util = new OicsCheckPointUtil();
                while (iter.hasNext()) {
                    String nameOfChkPointFile = (String)iter.next();
                    if (util.fileExists(nameOfChkPointFile)) {
                        OicsCheckPointSession oicsSession = new OicsCheckPointSession(nameOfChkPointFile);
                        if (this.m_allCheckPointFiles.get(nameOfChkPointFile) != null) {
                            oicsSession.setNodeList(this.m_allCheckPointFiles.get(nameOfChkPointFile).toString());
                        }
                        if (this.checkPointSessions != null) {
                            this.checkPointSessions.add(oicsSession);
                        } else {
                            this.checkPointSessions = new Vector();
                            this.checkPointSessions.add(oicsSession);
                        }
                        if (checkPointSession_List != null) {
                            checkPointSession_List.put(nameOfChkPointFile, oicsSession);
                        } else {
                            checkPointSession_List = new HashMap();
                            checkPointSession_List.put(nameOfChkPointFile, oicsSession);
                        }
                        if (oicsSession.getFailedCheckPointFiles() != null) {
                            this.m_failedCheckPointFiles = new HashMap(oicsSession.getFailedCheckPointFiles());
                        }
                        oicsSession.setIndexSessionObject(this);
                        continue;
                    }
                    OiiolTextLogger.appendText((String)("Checkpoint:Entry in index.xml for file:" + nameOfChkPointFile + " is invalid,file does not exist"));
                }
            } else {
                OiiolTextLogger.appendText((String)"Checkpoint:No checkpoint file written .");
            }
        } else {
            OiiolTextLogger.appendText((String)("Checkpoint:Index file :" + this.sFileName + " not found."));
        }
    }

    public OicsICheckPointSession initCheckPointSession(String checkPointFileLocation) {
        OicsCheckPointSession oicsSessionForInit = null;
        if (checkPointSession_List != null) {
            if (checkPointSession_List.get(checkPointFileLocation) != null) {
                return (OicsICheckPointSession)checkPointSession_List.get(checkPointFileLocation);
            }
            oicsSessionForInit = new OicsCheckPointSession(checkPointFileLocation);
            oicsSessionForInit.setIndexSessionObject(this);
            checkPointSession_List.put(checkPointFileLocation, oicsSessionForInit);
            if (this.checkPointSessions != null) {
                this.checkPointSessions.add(oicsSessionForInit);
            } else {
                this.checkPointSessions = new Vector();
                this.checkPointSessions.add(oicsSessionForInit);
            }
            return oicsSessionForInit;
        }
        if (checkPointSession_List == null) {
            checkPointSession_List = new HashMap();
        }
        oicsSessionForInit = new OicsCheckPointSession(checkPointFileLocation);
        checkPointSession_List.put(checkPointFileLocation, oicsSessionForInit);
        if (this.checkPointSessions != null) {
            this.checkPointSessions.add(oicsSessionForInit);
        } else {
            this.checkPointSessions = new Vector();
            this.checkPointSessions.add(oicsSessionForInit);
        }
        oicsSessionForInit.setIndexSessionObject(this);
        return oicsSessionForInit;
    }

    public OicsICheckPointSession initCheckPointSession(String checkPointFileLocation, String[] nodeList) {
        OicsCheckPointSession oicsSessionForInit = null;
        OicsCheckPointUtil util = new OicsCheckPointUtil();
        if (nodeList != null) {
            util.createDirOnNodes(this.oracleBase, this.component, nodeList);
        }
        if (checkPointSession_List != null) {
            if (checkPointSession_List.get(checkPointFileLocation) != null) {
                return (OicsICheckPointSession)checkPointSession_List.get(checkPointFileLocation);
            }
            oicsSessionForInit = new OicsCheckPointSession(checkPointFileLocation);
            oicsSessionForInit.setIndexSessionObject(this);
            checkPointSession_List.put(checkPointFileLocation, oicsSessionForInit);
            if (this.checkPointSessions != null) {
                this.checkPointSessions.add(oicsSessionForInit);
            } else {
                this.checkPointSessions = new Vector();
                this.checkPointSessions.add(oicsSessionForInit);
            }
            if (nodeList != null) {
                String listofNodes = OiixFunctionOps.implodeList((String[])nodeList, (String)",");
                oicsSessionForInit.setNodeList(listofNodes);
            }
            return oicsSessionForInit;
        }
        if (checkPointSession_List == null) {
            checkPointSession_List = new HashMap();
        }
        oicsSessionForInit = new OicsCheckPointSession(checkPointFileLocation);
        checkPointSession_List.put(checkPointFileLocation, oicsSessionForInit);
        if (nodeList != null) {
            String listofNodes = OiixFunctionOps.implodeList((String[])nodeList, (String)",");
            oicsSessionForInit.setNodeList(listofNodes);
        }
        if (this.checkPointSessions != null) {
            this.checkPointSessions.add(oicsSessionForInit);
        } else {
            this.checkPointSessions = new Vector();
            this.checkPointSessions.add(oicsSessionForInit);
        }
        oicsSessionForInit.setIndexSessionObject(this);
        return oicsSessionForInit;
    }

    public OicsICheckPointSession getCheckPointSession(String checkPointFileLocation) {
        if (checkPointSession_List.get(checkPointFileLocation) != null) {
            return (OicsICheckPointSession)checkPointSession_List.get(checkPointFileLocation);
        }
        return null;
    }

    public boolean isIndexFileExists() {
        OicsCheckPointUtil util = new OicsCheckPointUtil();
        return util.fileExists(this.indexLoc);
    }

    public HashMap getFailedCheckPointFiles() {
        return this.m_failedCheckPointFiles;
    }

    public HashMap getAllCheckPointFiles() {
        return this.m_allCheckPointFiles;
    }

    public void closeCheckPointIndexSession() throws OicsCheckPointException {
        boolean state_indexFile = true;
        File s_IndexFile = null;
        OicsCheckPointUtil util = new OicsCheckPointUtil();
        String sIndexFileNameWritten = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)this.oracleBase, (String)"checkpoints"));
        String componentLocation = sIndexFileNameWritten = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sIndexFileNameWritten, (String)this.component));
        sIndexFileNameWritten = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)sIndexFileNameWritten, (String)"index.xml"));
        try {
            s_IndexFile = new File(sIndexFileNameWritten);
        }
        catch (Exception e) {
            OiiolTextLogger.appendText((String)"Checkpoint:Error accessing index file");
            throw new OicsCheckPointException(e.getMessage());
        }
        if (s_IndexFile.exists()) {
            OiiolTextLogger.appendText((String)("Checkpoint:Index file :" + sIndexFileNameWritten + " written in this session, found."));
            OicsCheckPointIndexReaderFailedChecks chkPointIndxStatusReader = new OicsCheckPointIndexReaderFailedChecks(sIndexFileNameWritten);
            try {
                state_indexFile = chkPointIndxStatusReader.getIndexState();
            }
            catch (OicsCheckPointException oce) {
                OiiolTextLogger.appendText((String)("Checkpoint:" + oce.getMessage()));
            }
            if (state_indexFile) {
                util.removeDir(componentLocation, this.checkPointSessions);
            }
        } else {
            OiiolTextLogger.appendText((String)"Checkpoint:No Index File Written in this session.");
        }
    }
}

