/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oic.oics;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsCheckPointIndexSession;
import oracle.sysman.oic.oics.OicsCheckPointSession;
import oracle.sysman.oic.oics.OicsCheckPointUtil;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OicsCheckPointIndexWriter {
    private String oracleBase = null;
    private String component = null;
    private String fileName = "";
    private static OicsCheckPointIndexSession oicsIndexSess = null;

    public OicsCheckPointIndexWriter(OicsCheckPointIndexSession oicsIndexSessObj) throws OicsCheckPointException {
        oicsIndexSess = oicsIndexSessObj;
        try {
            this.updateObjects();
        }
        catch (IOException io) {
            OiiolTextLogger.appendText((String)("Checkpoint:" + io.getMessage()));
        }
    }

    private void updateObjects() throws IOException, OicsCheckPointException {
        if (oicsIndexSess != null) {
            if (OicsCheckPointIndexWriter.oicsIndexSess.checkPointSessions != null) {
                int size = OicsCheckPointIndexWriter.oicsIndexSess.checkPointSessions.size();
                this.oracleBase = OicsCheckPointIndexWriter.oicsIndexSess.oracleBase;
                this.component = OicsCheckPointIndexWriter.oicsIndexSess.component;
                this.fileName = OiixPathOps.concatPath((String)this.oracleBase, (String)"checkpoints");
                this.fileName = OiixPathOps.concatPath((String)this.fileName, (String)this.component);
                this.fileName = OiixPathOps.concatPath((String)this.fileName, (String)"index.xml");
                File oOutputFile = new File(this.fileName);
                File oOutputDir = oOutputFile.getParentFile();
                if (!oOutputDir.exists()) {
                    OiixFileOps.mkdirs((File)oOutputDir);
                }
                FileOutputStream fWriter = new FileOutputStream(this.fileName);
                OutputStreamWriter oWriter = new OutputStreamWriter((OutputStream)fWriter, "UTF-8");
                BufferedWriter bWriter = new BufferedWriter(oWriter);
                PrintWriter pWriter = new PrintWriter(bWriter);
                pWriter.println(OixsXMLOps.createXMLDirective((boolean)true));
                pWriter.println(OixsXMLOps.getStandardHeader());
                XMLElement m_elemCheckPoints = new XMLElement("INDEX");
                if (OicsCheckPointIndexWriter.oicsIndexSess.checkPointSessions.size() > 0) {
                    m_elemCheckPoints = this.generateCheckPointIndexNode(m_elemCheckPoints);
                    m_elemCheckPoints.print(pWriter);
                    try {
                        pWriter.close();
                        bWriter.close();
                        oWriter.close();
                        fWriter.close();
                    }
                    catch (IOException e) {
                        OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
                        throw new OicsCheckPointException(e.getMessage());
                    }
                } else {
                    OicsCheckPointUtil util = new OicsCheckPointUtil();
                    util.removeFile(this.fileName);
                }
            }
        } else {
            OiiolTextLogger.appendText((String)"Checkpoint:No Index Session Found");
        }
    }

    private XMLElement generateCheckPointIndexNode(XMLElement elemCheckPoints) {
        String xmlLoc = null;
        String[] nodeList = null;
        Vector m_checkPointSessions = OicsCheckPointIndexWriter.oicsIndexSess.checkPointSessions;
        int count_checkpoints = m_checkPointSessions.size();
        for (int i = 0; i < count_checkpoints; ++i) {
            OicsCheckPointSession oicsChkPointSession = null;
            nodeList = null;
            if (m_checkPointSessions.get(i) == null) continue;
            XMLElement CHECKPOINTSESSIONElement = new XMLElement("CHECKPOINT_SESSION");
            oicsChkPointSession = (OicsCheckPointSession)m_checkPointSessions.get(i);
            xmlLoc = oicsChkPointSession.checkPointXMLLoc;
            if (oicsChkPointSession.getNodeList() != null) {
                nodeList = oicsChkPointSession.getNodeList();
            }
            if (nodeList != null) {
                CHECKPOINTSESSIONElement.appendChild((Node)this.generatePropertiesNode(xmlLoc, nodeList, oicsChkPointSession));
            } else {
                CHECKPOINTSESSIONElement.appendChild((Node)this.generatePropertiesNode(xmlLoc, oicsChkPointSession));
            }
            elemCheckPoints.appendChild((Node)CHECKPOINTSESSIONElement);
        }
        return elemCheckPoints;
    }

    private XMLElement generatePropertiesNode(String xmlFile, OicsCheckPointSession oicsChkPointSession) {
        XMLElement CHECKPOINTSESSIONElement = new XMLElement("PROPERTY_LIST");
        XMLElement elemProperty = new XMLElement("PROPERTY");
        elemProperty.setAttribute("NAME", "CHECKPOINT_FILE_LOCATION");
        elemProperty.setAttribute("VAL", xmlFile);
        if (oicsChkPointSession.getLastFailedCheckPoint() != null) {
            elemProperty.setAttribute("STATUS", "FAIL");
        } else {
            elemProperty.setAttribute("STATUS", "SUCCESS");
        }
        CHECKPOINTSESSIONElement.appendChild((Node)elemProperty);
        return CHECKPOINTSESSIONElement;
    }

    private XMLElement generatePropertiesNode(String xmlFile, String[] nodes, OicsCheckPointSession oicsChkPointSession) {
        XMLElement CHECKPOINTSESSIONElement = new XMLElement("PROPERTY_LIST");
        XMLElement elemProperty = new XMLElement("PROPERTY");
        elemProperty.setAttribute("NAME", "CHECKPOINT_FILE_LOCATION");
        elemProperty.setAttribute("VAL", xmlFile);
        if (oicsChkPointSession.getLastFailedCheckPoint() != null) {
            elemProperty.setAttribute("STATUS", "FAIL");
            OiiolTextLogger.appendText((String)"Checkpoint:Setting status in index file as failed,as last checkpoint failed is available.");
        } else {
            elemProperty.setAttribute("STATUS", "SUCCESS");
            OiiolTextLogger.appendText((String)"Checkpoint:Setting status in index file as passed,as no last failed checkpoint is available.");
        }
        XMLElement elemProperty1 = new XMLElement("PROPERTY");
        elemProperty1.setAttribute("NAME", "NODE_LIST");
        if (nodes.length > 1) {
            elemProperty1.setAttribute("TYPE", "STRINGLIST");
        } else {
            elemProperty1.setAttribute("TYPE", "STRING");
        }
        String nodeList = OiixFunctionOps.implodeList((String[])nodes, (String)",");
        elemProperty1.setAttribute("VAL", nodeList);
        CHECKPOINTSESSIONElement.appendChild((Node)elemProperty);
        CHECKPOINTSESSIONElement.appendChild((Node)elemProperty1);
        return CHECKPOINTSESSIONElement;
    }
}

