/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oic.oics;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsICheckPoint;
import oracle.sysman.oic.oics.OicsICheckPointProperty;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OicsCheckPointWriter {
    private String m_checkPointFileName = null;
    private Vector m_checkPoints = null;

    public OicsCheckPointWriter(String fileName) {
        this.m_checkPointFileName = fileName;
    }

    public void updateObjects(Vector checkpoints) throws OicsCheckPointException {
        this.m_checkPoints = new Vector(checkpoints);
        try {
            this.writeCheckPoint();
        }
        catch (IOException io) {
            OiiolTextLogger.appendText((String)("Checkpoint:" + io.getMessage()));
            throw new OicsCheckPointException(io.getMessage());
        }
    }

    private void writeCheckPoint() throws IOException, OicsCheckPointException {
        File oOutputFile = new File(this.m_checkPointFileName);
        File oOutputDir = oOutputFile.getParentFile();
        if (!oOutputDir.exists()) {
            OiixFileOps.mkdirs((File)oOutputDir);
        }
        FileOutputStream fWriter = new FileOutputStream(this.m_checkPointFileName);
        OutputStreamWriter oWriter = new OutputStreamWriter((OutputStream)fWriter, "UTF-8");
        BufferedWriter bWriter = new BufferedWriter(oWriter);
        PrintWriter pWriter = new PrintWriter(bWriter);
        pWriter.println(OixsXMLOps.createXMLDirective((boolean)true));
        pWriter.println(OixsXMLOps.getStandardHeader());
        XMLElement m_elemCheckPoints = new XMLElement("CHECKPOINTS");
        m_elemCheckPoints = this.generateMainCheckPointNode(m_elemCheckPoints, this.m_checkPoints);
        m_elemCheckPoints.print(pWriter);
        try {
            pWriter.close();
            bWriter.close();
            oWriter.close();
            fWriter.close();
        }
        catch (IOException e) {
            OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
            throw new OicsCheckPointException(e.getMessage());
        }
    }

    private XMLElement generateMainCheckPointNode(XMLElement elemCheckPoints, Vector m_checkPoints) {
        int count_checkpoints = m_checkPoints.size();
        for (int i = 0; i < count_checkpoints; ++i) {
            XMLElement propertiesList;
            OicsICheckPoint oicsChkPoint = null;
            if (m_checkPoints.get(i) == null) continue;
            oicsChkPoint = (OicsICheckPoint)m_checkPoints.get(i);
            XMLElement checkpointList = this.generateCheckPointNode(oicsChkPoint);
            List childCheckPoints = null;
            if (oicsChkPoint.getChildCheckPoints() != null && (childCheckPoints = oicsChkPoint.getChildCheckPoints()) != null) {
                XMLElement childCheckpointList = this.generateElementChildCheckpoints(childCheckPoints);
                checkpointList.appendChild((Node)childCheckpointList);
            }
            if ((propertiesList = this.generatePropertiesNode(oicsChkPoint)) != null) {
                checkpointList.appendChild((Node)propertiesList);
            }
            elemCheckPoints.appendChild((Node)checkpointList);
        }
        return elemCheckPoints;
    }

    private XMLElement generateCheckPointNode(OicsICheckPoint oicsChkPoint) {
        String name_checkpoint = oicsChkPoint.getCheckPointName();
        String desc_checkpoint = oicsChkPoint.getCheckPointDesc();
        int num_level_checkpoint = oicsChkPoint.getCheckPointLevel();
        int num_state_checkpoint = oicsChkPoint.getCheckPointState();
        String level_checkpoint = this.getStrLevel(num_level_checkpoint);
        String state_checkpoint = this.getStrState(num_state_checkpoint);
        XMLElement CHECKPOINTElement = new XMLElement("CHECKPOINT");
        CHECKPOINTElement.setAttribute("LEVEL", level_checkpoint);
        CHECKPOINTElement.setAttribute("NAME", name_checkpoint);
        CHECKPOINTElement.setAttribute("DESC", desc_checkpoint);
        CHECKPOINTElement.setAttribute("STATE", state_checkpoint);
        return CHECKPOINTElement;
    }

    private XMLElement generatePropertiesNode(OicsICheckPoint oicsChkPoint) {
        XMLElement elemPropertyList = new XMLElement("PROPERTY_LIST");
        List checkpointprop = null;
        String value_prop = null;
        int size = -1;
        if (oicsChkPoint != null && (checkpointprop = oicsChkPoint.getAllCheckPointProperties()) != null) {
            size = checkpointprop.size();
            for (int k = 0; k < size; ++k) {
                XMLElement elemProperty = new XMLElement("PROPERTY");
                OicsICheckPointProperty oicsProp = (OicsICheckPointProperty)checkpointprop.get(k);
                String name_prop = oicsProp.getName();
                int num_type_prop = oicsProp.getType();
                if (num_type_prop == 3) {
                    Boolean value = (Boolean)oicsProp.getValue();
                    value_prop = value.booleanValue() ? "TRUE" : "FALSE";
                } else if (num_type_prop == 4) {
                    if (oicsProp.getValue() != null) {
                        String[] prop = (String[])oicsProp.getValue();
                        value_prop = OiixFunctionOps.implodeList((String[])prop, (String)",");
                    } else {
                        value_prop = "";
                    }
                } else {
                    value_prop = num_type_prop == 2 ? String.valueOf(oicsProp.getValue()) : (String)oicsProp.getValue();
                }
                String type_prop = this.getStrType(num_type_prop);
                elemProperty.setAttribute("NAME", name_prop);
                elemProperty.setAttribute("TYPE", type_prop);
                elemProperty.setAttribute("VAL", value_prop);
                elemPropertyList.appendChild((Node)elemProperty);
            }
            return elemPropertyList;
        }
        return null;
    }

    private XMLElement generateElementChildCheckpoints(List childCheckPoints) {
        int sizeOfList = childCheckPoints.size();
        Vector childCheckpoints_vector = new Vector(childCheckPoints);
        XMLElement elemChildCheckPointList = new XMLElement("CHECKPOINTS");
        elemChildCheckPointList = this.generateMainCheckPointNode(elemChildCheckPointList, childCheckpoints_vector);
        return elemChildCheckPointList;
    }

    private String getStrState(int state) {
        if (state == 1) {
            return "START";
        }
        if (state == 2) {
            return "FAIL";
        }
        if (state == 3) {
            return "SUCCESS";
        }
        return "START";
    }

    private String getStrLevel(int level) {
        if (level == 1) {
            return "MAJOR";
        }
        if (level == 2) {
            return "MINOR";
        }
        return null;
    }

    private String getStrType(int type) {
        if (type == 1) {
            return "STRING";
        }
        if (type == 2) {
            return "NUMBER";
        }
        if (type == 3) {
            return "BOOLEAN";
        }
        if (type == 4) {
            return "STRINGLIST";
        }
        return "STRING";
    }
}

