/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oic.oics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsCheckPointReader;
import oracle.sysman.oic.oics.OicsCheckPointUtil;
import oracle.sysman.oic.oics.OicsICheckPoint;
import oracle.sysman.oic.oics.OicsIRemoteCheckPointSession;
import oracle.sysman.oic.oics.OicsRemoteCheckPointIndexSession;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;

public class OicsRemoteCheckPointSession
implements OicsIRemoteCheckPointSession {
    public String checkPointXMLLoc = null;
    public Vector checkPoints = null;
    private Vector failedCheckPoints = null;
    private HashMap failedCheckpointFiles = null;
    private String remoteNode = null;
    private boolean fileSet = true;
    private static OicsRemoteCheckPointIndexSession oicsIndexSess;
    private String checkpointFileNameOnLocalNode = "";

    public OicsRemoteCheckPointSession(String remoteNode, String checkPointXMLLoc) {
        OicsCheckPointUtil util = new OicsCheckPointUtil();
        this.checkpointFileNameOnLocalNode = checkPointXMLLoc + "." + remoteNode;
        if (util.fileExists(this.checkpointFileNameOnLocalNode)) {
            this.checkPointXMLLoc = checkPointXMLLoc;
            this.remoteNode = remoteNode;
            OicsCheckPointReader checkpointReader = new OicsCheckPointReader(this.checkpointFileNameOnLocalNode);
            try {
                checkpointReader.buildCheckpoint();
            }
            catch (OicsCheckPointException e) {
                OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
            }
            if (OicsCheckPointReader.checkPoints != null) {
                this.checkPoints = new Vector(OicsCheckPointReader.checkPoints);
            }
            Iterator itr = this.checkPoints.iterator();
            while (itr.hasNext()) {
                OicsICheckPoint oics = (OicsICheckPoint)itr.next();
                if (oics.getCheckPointState() != 2) continue;
                if (this.failedCheckPoints == null) {
                    this.failedCheckPoints = new Vector();
                }
                if (this.fileSet) {
                    if (this.failedCheckpointFiles == null) {
                        this.failedCheckpointFiles = new HashMap();
                    }
                    this.failedCheckpointFiles.put(checkPointXMLLoc, remoteNode);
                    this.fileSet = false;
                }
                this.failedCheckPoints.add(oics);
            }
        } else {
            OiiolTextLogger.appendText((String)("Checkpoint:CheckpointFile :" + checkPointXMLLoc + " not found,creating one for this session"));
        }
    }

    public OicsICheckPoint getCheckPoint(String checkPointName) {
        boolean checkPointFound = false;
        if (this.checkPoints != null) {
            int sizeofList = this.checkPoints.size();
            for (int k = 0; k < sizeofList; ++k) {
                OicsICheckPoint obj = (OicsICheckPoint)this.checkPoints.get(k);
                if (!obj.getCheckPointName().equalsIgnoreCase(checkPointName)) continue;
                checkPointFound = true;
                return obj;
            }
        }
        return null;
    }

    public List getAllCheckPoints() {
        if (this.checkPoints != null) {
            return this.checkPoints;
        }
        return null;
    }

    public List getAllFailedCheckPoints() {
        if (this.failedCheckPoints != null) {
            return this.failedCheckPoints;
        }
        return null;
    }

    public OicsICheckPoint getLastFailedCheckPoint() {
        if (this.failedCheckPoints != null) {
            return (OicsICheckPoint)this.failedCheckPoints.lastElement();
        }
        return null;
    }

    public HashMap getFailedCheckPointFiles() {
        if (this.failedCheckpointFiles != null) {
            return this.failedCheckpointFiles;
        }
        return null;
    }

    public void setIndexSessionObject(OicsRemoteCheckPointIndexSession oicsIndexSessref) {
        oicsIndexSess = oicsIndexSessref;
    }

    public String getRemoteNode() {
        if (this.remoteNode != null) {
            return this.remoteNode;
        }
        return null;
    }
}

