/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1Utils;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1ConstructedInputStream
extends FilterInputStream {
    private int c;
    private int d = 0;
    private int e = -1;

    public boolean markSupported() {
        return false;
    }

    private void a(ASN1Header aSN1Header) {
        this.c = aSN1Header.getBodyLength();
    }

    public ASN1ConstructedInputStream(InputStream inputStream, int n) throws IOException {
        this(inputStream, n, 128);
    }

    public void terminate(boolean bl) throws IOException {
        if (bl) {
            while (this.hasMoreData()) {
                ASN1Utils.inputASN1Object(this);
            }
        }
        if (this.c >= 0) {
            if (this.d < this.c) {
                throw new ASN1FormatException("End of constructed encoding expected.");
            }
        } else {
            if (this.read() != 0) {
                throw new ASN1FormatException("First end-of-contents octet expected.");
            }
            if (this.read() != 0) {
                throw new ASN1FormatException("Second end-of-contents octet expected.");
            }
        }
    }

    public boolean hasMoreData() throws IOException {
        if (this.c >= 0) {
            return this.d < this.c;
        }
        int n = this.read();
        if (n == -1) {
            throw new ASN1FormatException("End of input.");
        }
        this.unread(n);
        return n != 0;
    }

    public void terminate() throws IOException {
        this.terminate(false);
    }

    public ASN1ConstructedInputStream(InputStream inputStream, ASN1Header aSN1Header) {
        super(inputStream);
        this.a(aSN1Header);
    }

    public int available() throws IOException {
        return (this.e != -1 ? 1 : 0) + super.available();
    }

    public int getCurrentTag() throws IOException {
        int n = this.read();
        if (n == -1) {
            return -1;
        }
        this.b(n);
        int n2 = n & 0x1F;
        return n2;
    }

    public ASN1ConstructedInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        ASN1Header aSN1Header = new ASN1Header(this.in);
        aSN1Header.checkTagClass(128);
        if (aSN1Header.getEncodingMethod() == 0) {
            throw new ASN1FormatException("Constructed encoding expected");
        }
        this.a(aSN1Header);
    }

    public ASN1ConstructedInputStream(InputStream inputStream, int n, int n2) throws IOException {
        super(inputStream);
        ASN1Header aSN1Header = new ASN1Header(this.in);
        aSN1Header.checkTag(n);
        aSN1Header.checkTagClass(n2);
        if (aSN1Header.getEncodingMethod() == 0) {
            throw new ASN1FormatException("Constructed encoding expected");
        }
        this.a(aSN1Header);
    }

    public int read() throws IOException {
        if (this.e == -1) {
            if (this.c != -1 && this.d >= this.c) {
                return -1;
            }
            int n = super.read();
            if (n == -1) {
                throw new ASN1FormatException("End of input.");
            }
            ++this.d;
            return n;
        }
        int n = this.e;
        this.e = -1;
        ++this.d;
        return n;
    }

    private void b(int n) {
        if (this.e == -1) {
            this.e = n & 0xFF;
            --this.d;
        } else {
            throw new IllegalStateException("Pushback buffer is full.");
        }
    }

    public void unread(int n) {
        this.b(n);
    }

    public void setCurrentTag(int n) throws IOException {
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        this.b((n2 & 0x20) + n);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.c == -1 || this.d + n2 <= this.c) {
            int n3 = 0;
            if (this.e != -1) {
                byArray[n] = (byte)this.e;
                n3 = 1;
            }
            int n4 = n3 + super.read(byArray, n, n2 - n3);
            this.d += n4;
            return n4;
        }
        throw new ASN1FormatException("Contents length exceeded.");
    }

    public int getCurrentIDByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            return -1;
        }
        this.b(n);
        return n;
    }
}

