/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Date;

public class ASN1Date
implements ASN1TaggedObject {
    private Date e;
    private ASN1Header f;
    private boolean g;

    public void setUseGeneralizedTime(boolean bl) {
        this.g = bl;
    }

    public static void outputValue(OutputStream outputStream, Date date, boolean bl) throws IOException {
        ASN1Date.d(outputStream, date, bl, bl ? 24 : 23, 0);
    }

    public String toString() {
        return (this.g ? "GeneralizedTime " : "UTCTime ") + this.e.toString();
    }

    public Date getValue() {
        return this.e;
    }

    public ASN1Date() {
        this(new Date());
    }

    private void a(Date date, boolean bl) {
        this.e = date;
        this.g = bl;
        this.f = new ASN1Header(bl ? 24 : 23, 0, 0, bl ? 15 : 13);
    }

    public boolean getUseGeneralizedTime() {
        return this.g;
    }

    public static Date inputValue(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        int n = aSN1Header.getTag();
        if (n != 23 && n != 24) {
            throw new ASN1FormatException("Got tag " + n + " instead of " + 23 + " or " + 24 + ".");
        }
        return Utils.parseDate(Utils.fromUTF8(ASN1Date.b(inputStream, aSN1Header, 0)), n == 24);
    }

    private static byte[] b(InputStream inputStream, ASN1Header aSN1Header, int n) throws IOException {
        if (aSN1Header == null) {
            aSN1Header = new ASN1Header(inputStream);
            aSN1Header.checkTagClass(0);
            aSN1Header.checkTag(n);
        }
        if (aSN1Header.getEncodingMethod() == 0) {
            return aSN1Header.readBody(inputStream);
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
        while (aSN1ConstructedInputStream.hasMoreData()) {
            unsyncByteArrayOutputStream.write(ASN1Date.b(aSN1ConstructedInputStream, null, n));
        }
        aSN1ConstructedInputStream.terminate();
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public static void outputValueWithTag(OutputStream outputStream, Date date, boolean bl, int n) throws IOException {
        ASN1Date.d(outputStream, date, bl, n, 128);
    }

    public ASN1Date(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1Header getHeader() {
        return this.f;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.f.output(outputStream);
        ASN1Date.c(outputStream, this.e, this.g);
    }

    private static void c(OutputStream outputStream, Date date, boolean bl) throws IOException {
        outputStream.write(Utils.toUTF8(Utils.formatDate(date, bl)));
    }

    public static void outputValueWithTag(OutputStream outputStream, Date date, int n) throws IOException {
        ASN1Date.outputValueWithTag(outputStream, date, false, n);
    }

    public static void outputValue(OutputStream outputStream, Date date) throws IOException {
        ASN1Date.outputValue(outputStream, date, false);
    }

    public ASN1Date(Date date) {
        this(date, false);
    }

    public ASN1Date(Date date, boolean bl) {
        this.a(date, bl);
    }

    private static void d(OutputStream outputStream, Date date, boolean bl, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        outputStream.write(bl ? 15 : 13);
        ASN1Date.c(outputStream, date, bl);
    }

    public void input(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        int n = Utils.inputByte(pushbackInputStream) & 0xFF;
        pushbackInputStream.unread(n);
        int n2 = ASN1Utils.getTag(n);
        this.a(ASN1Date.inputValue(pushbackInputStream), n2 == 24);
    }

    public int length() {
        return this.f.totalLength();
    }
}

