/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1Constructed;
import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class ASN1GenericConstructed
implements ASN1TaggedObject,
ASN1Constructed {
    private int b = 0;
    private ASN1Header c = null;
    private Vector d = new Vector();
    private int e;
    private ASN1Object[] f = null;
    private int g = 0;
    private int h;

    public int getTagClass() {
        return this.e;
    }

    public ASN1GenericConstructed(Vector vector, int n) {
        this(vector, n, 128);
    }

    public ASN1GenericConstructed(Vector vector, int n, int n2) {
        this(n, n2);
        this.d = vector;
        this.g = 0;
        int n3 = 0;
        int n4 = this.d.size();
        while (n3 < n4) {
            this.g += ((ASN1Object)this.d.elementAt(n3)).length();
            ++n3;
        }
    }

    public ASN1GenericConstructed(int n) {
        this(n, 128);
    }

    public static void outputValue(OutputStream outputStream, Vector vector, int n) throws IOException {
        ASN1GenericConstructed.outputValue(outputStream, vector, n, 128);
    }

    public int getTag() {
        return this.h;
    }

    public ASN1Object elementAt(int n) {
        return (ASN1Object)this.d.elementAt(n);
    }

    public ASN1Object lastElement() {
        return (ASN1Object)this.d.lastElement();
    }

    public ASN1GenericConstructed(ASN1Object aSN1Object, int n, int n2) {
        this(n, n2);
        this.addElement(aSN1Object);
    }

    public ASN1GenericConstructed(byte[] byArray) throws IOException {
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public ASN1GenericConstructed(ASN1Object aSN1Object, int n) {
        this(aSN1Object, n, 128);
    }

    public int length() {
        return this.getHeader().totalLength();
    }

    public void setEncodingType(int n) {
        this.b = n;
    }

    public ASN1GenericConstructed(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void output(OutputStream outputStream) throws IOException {
        this.getHeader().output(outputStream);
        if (this.b == 0) {
            int n = 0;
            int n2 = this.d.size();
            while (n < n2) {
                ((ASN1Object)this.d.elementAt(n)).output(outputStream);
                ++n;
            }
        } else {
            ASN1Object[] aSN1ObjectArray = this.a();
            int n = 0;
            while (n < aSN1ObjectArray.length) {
                aSN1ObjectArray[n].output(outputStream);
                ++n;
            }
        }
    }

    public int size() {
        return this.d.size();
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        if (aSN1Header.getEncodingMethod() == 0) {
            throw new ASN1FormatException("Constructed encoding expected.");
        }
        ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
        this.h = aSN1Header.getTag();
        this.e = aSN1Header.getTagClass();
        this.d = new Vector();
        this.g = 0;
        while (aSN1ConstructedInputStream.hasMoreData()) {
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(aSN1ConstructedInputStream);
            this.d.addElement(aSN1Object);
            this.g += aSN1Object.length();
        }
        aSN1ConstructedInputStream.terminate();
        this.c = null;
        this.f = null;
    }

    public static void outputValue(OutputStream outputStream, Vector vector, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        int n5 = vector.size();
        while (n4 < n5) {
            n3 += ((ASN1Object)vector.elementAt(n4)).length();
            ++n4;
        }
        outputStream.write(32 + n2 + n);
        ASN1Utils.outputLengthBytes(outputStream, n3);
        int n6 = 0;
        int n7 = vector.size();
        while (n6 < n7) {
            ((ASN1Object)vector.elementAt(n6)).output(outputStream);
            ++n6;
        }
    }

    public ASN1Object firstElement() {
        return (ASN1Object)this.d.firstElement();
    }

    public ASN1GenericConstructed(int n, int n2) {
        this.h = n;
        this.e = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GENERIC CONSTRUCTED [");
        switch (this.e) {
            case 0: {
                stringBuffer.append("UNIVERSAL");
                break;
            }
            case 64: {
                stringBuffer.append("APPLICATION");
                break;
            }
            case 128: {
                stringBuffer.append("CONTEXT SPECIFIC");
                break;
            }
            case 192: {
                stringBuffer.append("PRIVATE");
                break;
            }
            default: {
                stringBuffer.append(this.e);
            }
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.h);
        stringBuffer.append("] ");
        stringBuffer.append(Utils.toString(this.d));
        return stringBuffer.toString();
    }

    public void addElement(ASN1Object aSN1Object) {
        this.d.addElement(aSN1Object);
        this.g += aSN1Object.length();
        this.c = null;
        this.f = null;
    }

    private ASN1Object[] a() {
        if (this.f == null) {
            this.f = ASN1Set.c(this.d, this.b);
        }
        return this.f;
    }

    public int getEncodingType() {
        return this.b;
    }

    public ASN1Sequence toSequence() {
        return new ASN1Sequence(this.d);
    }

    public ASN1Header getHeader() {
        if (this.c == null) {
            this.c = new ASN1Header(this.h, this.e, 1, this.g);
        }
        return this.c;
    }

    public Vector elements() {
        return this.d;
    }
}

