/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1Constructed;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class ASN1Sequence
implements ASN1TaggedObject,
ASN1Constructed {
    private int a;
    private ASN1Header b = null;
    private Vector c = new Vector();

    public byte[] getEncoded() {
        return Utils.toBytes(this);
    }

    public int length() {
        return this.getHeader().totalLength();
    }

    public void addElement(ASN1Object aSN1Object) {
        this.c.addElement(aSN1Object);
        this.a += aSN1Object.length();
        this.b = null;
    }

    public static ASN1Header makeHeader(int n) {
        return new ASN1Header(16, 0, 1, n);
    }

    public ASN1Object lastElement() {
        return (ASN1Object)this.c.lastElement();
    }

    public ASN1Object firstElement() {
        return (ASN1Object)this.c.firstElement();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.getHeader().output(outputStream);
        int n = 0;
        int n2 = this.c.size();
        while (n < n2) {
            ((ASN1Object)this.c.elementAt(n)).output(outputStream);
            ++n;
        }
    }

    public int size() {
        return this.c.size();
    }

    public ASN1Sequence() {
    }

    public ASN1Header getHeader() {
        if (this.b == null) {
            this.b = ASN1Sequence.makeHeader(this.a);
        }
        return this.b;
    }

    public Vector elements() {
        return this.c;
    }

    public ASN1Object elementAt(int n) {
        return (ASN1Object)this.c.elementAt(n);
    }

    public ASN1Sequence(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1Sequence(Vector vector) {
        this.c = vector;
        this.a = 0;
        int n = 0;
        int n2 = this.c.size();
        while (n < n2) {
            this.a += ((ASN1Object)this.c.elementAt(n)).length();
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SEQUENCE {");
        int n = 0;
        int n2 = this.c.size();
        while (n < n2) {
            stringBuffer.append(this.c.elementAt(n).toString());
            if (n != this.c.size() - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public ASN1Sequence(ASN1Object aSN1Object) {
        this.addElement(aSN1Object);
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.c = new Vector();
        this.a = 0;
        while (aSN1SequenceInputStream.hasMoreData()) {
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(aSN1SequenceInputStream);
            this.c.addElement(aSN1Object);
            this.a += aSN1Object.length();
        }
        aSN1SequenceInputStream.terminate();
        this.b = null;
    }
}

