/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1GenericPrimitive;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.CRLDistPointName;
import com.phaos.cert.CRLReason;
import com.phaos.cert.GeneralName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class CRLDistPoint
implements ASN1Object {
    private Vector d = null;
    private transient ASN1Object e = null;
    private boolean[] f;
    private CRLDistPointName g = null;
    private int h;

    public boolean hasReasonFlag(CRLReason cRLReason) {
        int n = cRLReason.getValue();
        return this.f != null && n < this.f.length ? this.f[n] : false;
    }

    public Vector getCRLIssuerNames() {
        return this.d;
    }

    private void a(CRLReason cRLReason) {
        if (this.f == null || this.f.length < CRLReason.LIST.length) {
            boolean[] blArray = new boolean[CRLReason.LIST.length];
            if (this.f != null) {
                System.arraycopy(this.f, 0, blArray, 0, this.f.length);
            }
            this.f = blArray;
        }
        this.f[cRLReason.getValue()] = true;
        ++this.h;
    }

    public CRLDistPointName getDistPointName() {
        return this.g;
    }

    private void b() {
        this.e = null;
    }

    public CRLDistPoint(CRLDistPointName cRLDistPointName) {
        this.g = cRLDistPointName;
    }

    public void setReasonFlags(CRLReason[] cRLReasonArray) {
        int n = 0;
        int n2 = cRLReasonArray.length;
        while (n < n2) {
            this.a(cRLReasonArray[n]);
            ++n;
        }
        this.b();
    }

    public void input(InputStream inputStream) throws IOException {
        Object object;
        this.b();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 0) {
            object = new ASN1ConstructedInputStream((InputStream)aSN1SequenceInputStream, 0);
            this.g = new CRLDistPointName((InputStream)object);
            ((ASN1ConstructedInputStream)object).terminate();
        } else {
            this.g = null;
        }
        if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 1) {
            aSN1SequenceInputStream.setCurrentTag(3);
            object = new ASN1BitString(aSN1SequenceInputStream);
            this.f = new boolean[((ASN1BitString)object).bitLength()];
            int n = 0;
            try {
                while (n < this.f.length) {
                    this.f[n] = ((ASN1BitString)object).testBit(n);
                    ++this.h;
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ASN1FormatException("Unknown reasons flag: " + n);
            }
        } else {
            this.f = null;
            this.h = 0;
        }
        if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 2) {
            aSN1SequenceInputStream.setCurrentTag(16);
            this.d = new Vector();
            object = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            while (((ASN1ConstructedInputStream)object).hasMoreData()) {
                this.d.addElement(new GeneralName((InputStream)object));
            }
            ((ASN1ConstructedInputStream)object).terminate();
        } else {
            this.d = null;
        }
        aSN1SequenceInputStream.terminate();
        if (this.g == null && this.f == null && this.d == null) {
            throw new ASN1FormatException("Empty DRLDistPoint input");
        }
    }

    public void clearAllReasonFlags() {
        if (this.f != null) {
            int n = 0;
            int n2 = this.f.length;
            while (n < n2) {
                this.f[n] = false;
                ++n;
            }
            this.b();
        }
    }

    public void addCRLIssuerName(GeneralName generalName) {
        if (this.d == null) {
            this.d = new Vector();
        }
        this.d.addElement(generalName);
        this.b();
    }

    public CRLDistPoint(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public int length() {
        return this.c().length();
    }

    public void setReasonFlag(CRLReason cRLReason) {
        this.a(cRLReason);
        this.b();
    }

    private ASN1Object c() {
        if (this.e == null) {
            if (this.g == null && this.f == null && this.d == null) {
                throw new IllegalStateException("Invalid CRLDistPoint, all fields missing");
            }
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            if (this.g != null) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(this.g, 0));
            }
            if (this.f != null && this.h > 0) {
                ASN1BitString aSN1BitString = new ASN1BitString(this.f.length);
                int n = 0;
                while (n < this.f.length) {
                    if (this.f[n]) {
                        aSN1BitString.setBit(n);
                    }
                    ++n;
                }
                aSN1Sequence.addElement(new ASN1GenericPrimitive(aSN1BitString, 1));
            }
            if (this.d != null) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(this.d, 2));
            }
            this.e = aSN1Sequence;
        }
        return this.e;
    }

    public CRLDistPoint(GeneralName generalName) {
        this.d = new Vector();
        this.d.addElement(generalName);
    }

    public void clearReasonFlag(CRLReason cRLReason) {
        int n = cRLReason.getValue();
        if (this.f != null && n < this.f.length) {
            this.f[n] = false;
        }
        this.b();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.c().output(outputStream);
    }

    public void setDistPointName(CRLDistPointName cRLDistPointName) {
        this.g = cRLDistPointName;
        this.b();
    }
}

