/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.GeneralName;
import com.phaos.cert.X500RDN;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Vector;

public class CRLDistPointName
implements ASN1Object {
    private transient ASN1Object b;
    private Vector c;
    private X500RDN d;

    public CRLDistPointName(GeneralName generalName) {
        this.c = new Vector();
        this.c.addElement(generalName);
    }

    public void addGeneralName(GeneralName generalName) {
        if (this.c == null) {
            this.c = new Vector();
        }
        this.c.addElement(generalName);
    }

    public X500RDN getRelativeName() {
        return this.d;
    }

    public CRLDistPointName(Vector vector) {
        this.c = vector;
    }

    public CRLDistPointName(X500RDN x500RDN) {
        this.d = x500RDN;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.a().output(outputStream);
    }

    public void input(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        int n = pushbackInputStream.read();
        int n2 = ASN1Utils.getTag(n);
        if (n2 == 0) {
            pushbackInputStream.unread((n & 0x20) + 16);
            if (this.c == null) {
                this.c = new Vector();
            } else {
                this.c.removeAllElements();
            }
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(pushbackInputStream);
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.c.addElement(new GeneralName(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            this.d = null;
        } else if (n2 == 1) {
            pushbackInputStream.unread((n & 0x20) + 17);
            this.c = null;
            this.d = new X500RDN(pushbackInputStream);
        }
        if ((this.c == null || this.c.size() == 0) && this.d == null) {
            throw new ASN1FormatException("No name elements found in CRLDistPointName");
        }
    }

    public Vector getFullName() {
        return this.c;
    }

    private ASN1Object a() {
        if (this.b == null) {
            this.b = this.c != null ? new ASN1GenericConstructed(this.c, 0) : ASN1Utils.addImplicitTag(this.d, 1);
        }
        return this.b;
    }

    public int length() {
        return this.a().length();
    }

    public CRLDistPointName(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }
}

