/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.Attribute;
import com.phaos.cert.AttributeSet;
import com.phaos.cert.PKIX;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509Extension;
import com.phaos.cert.X509ExtensionSet;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.OutputGenerationException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class CertificateRequest
implements ASN1Object {
    private byte[] e;
    private ASN1Sequence f = null;
    private PublicKey g;
    private AlgorithmIdentifier h;
    private boolean i;
    private PrivateKey j;
    private ASN1Sequence k;
    private AttributeSet l;
    private X500Name m;

    public X509ExtensionSet setExtensions(X509ExtensionSet x509ExtensionSet) {
        Attribute attribute = this.addAttribute(PKIX.extensionRequest, x509ExtensionSet);
        if (attribute != null) {
            try {
                return new X509ExtensionSet(Utils.toStream((ASN1Object)attribute.getValues().elementAt(0)));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
        }
        return null;
    }

    public void setUseWrongFormat(boolean bl) {
        this.i = bl;
        this.d();
    }

    public X509ExtensionSet getExtensions() {
        Attribute attribute = this.getAttribute(PKIX.extensionRequest);
        if (attribute != null) {
            try {
                return new X509ExtensionSet(Utils.toStream((ASN1Object)attribute.getValues().elementAt(0)));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
        }
        return null;
    }

    public void setSigAlgID(AlgorithmIdentifier algorithmIdentifier) {
        this.h = algorithmIdentifier;
        this.d();
    }

    public void setPrivateKey(PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.j = privateKey;
        this.setSigAlgID(algorithmIdentifier);
    }

    public String toString() {
        return "subject = " + this.m + ", pubKey = " + this.g;
    }

    ASN1Sequence a() throws SignatureException {
        if (this.f == null) {
            this.getSigBytes();
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.k);
            aSN1Sequence.addElement(this.h);
            aSN1Sequence.addElement(new ASN1BitString(this.e));
            this.f = aSN1Sequence;
        }
        return this.f;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.g = publicKey;
        this.d();
    }

    public void setSubject(X500Name x500Name) {
        this.m = x500Name;
        this.d();
    }

    public X500Name getSubject() {
        return this.m;
    }

    public CertificateRequest(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public PublicKey getPublicKey() {
        return this.g;
    }

    public boolean getUseWrongFormat() {
        return this.i;
    }

    public CertificateRequest(X500Name x500Name, KeyPair keyPair, boolean bl) {
        this.m = x500Name;
        this.g = keyPair.getPublic();
        this.j = keyPair.getPrivate();
        this.i = bl;
    }

    public void sign(RandomBitsSource randomBitsSource) throws SignatureException {
        this.c();
        try {
            Signature signature = Signature.getInstance(this.j);
            if (this.h != null) {
                signature.setAlgID(this.h);
            } else {
                this.h = signature.getAlgID();
            }
            signature.setRandomBitsSource(randomBitsSource);
            signature.setDocument(Utils.toBytes(this.k));
            this.e = signature.sign();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new SignatureException(algorithmIdentifierException.toString());
        }
        this.b();
    }

    public Attribute getAttribute(ASN1ObjectID aSN1ObjectID) {
        return this.l != null ? this.l.getAttribute(aSN1ObjectID) : null;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.setPrivateKey(privateKey, null);
    }

    private void b() {
        this.f = null;
    }

    public AttributeSet getAttributes() {
        return this.l;
    }

    public void input(InputStream inputStream) throws IOException {
        this.d();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.k = new ASN1Sequence(aSN1SequenceInputStream);
        this.h = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.e = ASN1BitString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        aSN1SequenceInputStream = new ASN1SequenceInputStream(Utils.toStream(this.k));
        int n = ASN1Integer.inputValue(aSN1SequenceInputStream).intValue();
        if (n != 0) {
            throw new ASN1FormatException("Expected version 0, got " + n);
        }
        this.m = new X500Name(aSN1SequenceInputStream);
        this.g = CryptoUtils.inputSPKI(aSN1SequenceInputStream);
        if (aSN1SequenceInputStream.hasMoreData()) {
            if (aSN1SequenceInputStream.getCurrentTag() == 0) {
                aSN1SequenceInputStream.setCurrentTag(17);
                this.l = new AttributeSet(aSN1SequenceInputStream);
            } else {
                throw new ASN1FormatException("Expected tag 0, got " + aSN1SequenceInputStream.getCurrentTag());
            }
        }
        aSN1SequenceInputStream.terminate();
        try {
            this.verifySignature();
        }
        catch (AuthenticationException authenticationException) {
            throw new IOException(authenticationException.toString());
        }
    }

    private ASN1Sequence c() {
        if (this.k == null) {
            this.k = new ASN1Sequence();
            this.k.addElement(new ASN1Integer(0L));
            this.k.addElement(this.m);
            this.k.addElement(CryptoUtils.subjectPublicKeyInfo(this.g));
            if (this.l != null) {
                this.k.addElement(new ASN1GenericConstructed(this.l.toASN1Set().elements(), 0));
            } else if (!this.i) {
                this.k.addElement(new ASN1GenericConstructed(new Vector(), 0));
            }
        }
        return this.k;
    }

    public CertificateRequest(X500Name x500Name, KeyPair keyPair) {
        this(x500Name, keyPair, false);
    }

    public void output(OutputStream outputStream) throws IOException {
        try {
            this.a().output(outputStream);
        }
        catch (SignatureException signatureException) {
            throw new OutputGenerationException(signatureException.toString());
        }
    }

    public X509Extension addExtension(X509Extension x509Extension) {
        X509ExtensionSet x509ExtensionSet = this.getExtensions();
        if (x509ExtensionSet == null) {
            x509ExtensionSet = new X509ExtensionSet();
        }
        X509Extension x509Extension2 = x509ExtensionSet.getExtension(x509Extension.getType());
        x509ExtensionSet.addExtension(x509Extension);
        this.setExtensions(x509ExtensionSet);
        return x509Extension2;
    }

    public Attribute addAttribute(Attribute attribute) {
        this.d();
        if (this.l == null) {
            this.l = new AttributeSet();
        }
        return this.l.addAttribute(attribute);
    }

    public CertificateRequest(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private void d() {
        this.b();
        this.k = null;
        this.e = null;
    }

    public boolean verifySignature() throws AuthenticationException {
        try {
            Signature signature = Signature.getInstance(this.h);
            signature.setPublicKey(this.g);
            signature.setDocument(Utils.toBytes(this.k));
            signature.setSigBytes(this.e);
            return signature.verify();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new AuthenticationException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
    }

    public Attribute addAttribute(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        return this.addAttribute(new Attribute(aSN1ObjectID, aSN1Object));
    }

    public void sign() throws SignatureException {
        this.sign(RandomBitsSource.getDefault());
    }

    public int length() {
        try {
            return this.a().length();
        }
        catch (SignatureException signatureException) {
            return 0;
        }
    }

    public CertificateRequest() {
    }

    public byte[] getSigBytes() throws SignatureException {
        if (this.e == null) {
            this.sign();
        }
        return this.e;
    }
}

