/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1String;
import com.phaos.cert.GeneralName;
import com.phaos.cert.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class GeneralNames
implements ASN1Object {
    private ASN1Sequence c;
    private Vector d = new Vector();

    public GeneralNames(X500Name x500Name) {
        this(x500Name, null);
    }

    public boolean removeGeneralName(GeneralName generalName) {
        boolean bl = false;
        if (generalName != null) {
            bl = this.d.removeElement(generalName);
            if (bl) {
                // empty if block
            }
            this.a();
        }
        return bl;
    }

    public boolean containsGeneralName(GeneralName generalName) {
        if (generalName == null || this.d == null || this.d.size() < 1) {
            return false;
        }
        return this.d.contains(generalName);
    }

    public void addGeneralName(X500Name x500Name) {
        if (x500Name != null) {
            this.addGeneralName(new GeneralName(x500Name));
        }
    }

    public boolean removeGeneralName(String string) {
        if (string != null) {
            return this.removeGeneralName(new GeneralName(GeneralName.Type.RFC822_NAME, string));
        }
        return false;
    }

    public GeneralNames(X500Name x500Name, String string) {
        if (x500Name != null) {
            this.addGeneralName(x500Name);
        }
        if (string != null) {
            this.addGeneralName(string);
        }
    }

    public GeneralName generalNameAt(int n) {
        return (GeneralName)this.d.elementAt(n);
    }

    public void addGeneralName(GeneralName generalName) {
        if (generalName != null) {
            this.d.addElement(generalName);
            this.a();
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        if (this.d == null || this.d.size() < 1) {
            throw new IOException("General Names is Empty");
        }
        this.b().output(outputStream);
    }

    public Enumeration generalNames() {
        if (this.d == null) {
            return new Vector().elements();
        }
        return this.d.elements();
    }

    public void input(InputStream inputStream) throws IOException {
        this.a();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        if (aSN1SequenceInputStream.hasMoreData()) {
            this.d = new Vector();
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.d.addElement(new GeneralName(aSN1SequenceInputStream));
            }
        }
        aSN1SequenceInputStream.terminate();
        if (this.d == null || this.d.size() < 1) {
            throw new IOException("General Names can not be Empty");
        }
    }

    public GeneralNames() {
    }

    public GeneralNames(GeneralName generalName) {
        this.addGeneralName(generalName);
    }

    private void a() {
        this.c = null;
    }

    public GeneralNames(String string) {
        this(null, string);
    }

    public void addGeneralNames(Vector vector) {
        if (vector != null) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                this.d.addElement(vector.elementAt(n));
                ++n;
            }
            this.a();
        }
    }

    public int size() {
        return this.d.size();
    }

    public boolean removeGeneralNames(Vector vector) {
        boolean bl = false;
        if (vector != null && vector.size() != 0) {
            boolean bl2 = false;
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                bl2 = this.d.removeElement(vector.elementAt(n));
                if (!bl) {
                    bl = bl2;
                }
                ++n;
            }
        }
        if (bl) {
            this.a();
        }
        return bl;
    }

    public int length() {
        return this.b().length();
    }

    public Vector getGeneralNames() {
        return this.d;
    }

    public GeneralNames(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public boolean removeGeneralName(X500Name x500Name) {
        if (x500Name != null) {
            return this.removeGeneralName(new GeneralName(x500Name));
        }
        return false;
    }

    public Vector getRFC822Names() {
        if (this.d == null || this.d.size() < 1) {
            return null;
        }
        Vector<String> vector = null;
        int n = 0;
        int n2 = this.d.size();
        while (n < n2) {
            GeneralName generalName = (GeneralName)this.d.elementAt(n);
            if (generalName.getType().equals(GeneralName.Type.RFC822_NAME)) {
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.addElement(((ASN1String)generalName.getValue()).getValue());
            }
            ++n;
        }
        return vector;
    }

    public void addGeneralName(String string) {
        if (string != null) {
            this.addGeneralName(new GeneralName(GeneralName.Type.RFC822_NAME, string));
        }
    }

    public GeneralName removeGeneralName(int n) {
        GeneralName generalName = (GeneralName)this.d.elementAt(n);
        this.d.removeElementAt(n);
        this.a();
        return generalName;
    }

    private ASN1Sequence b() {
        if (this.c == null) {
            this.c = new ASN1Sequence(this.d);
        }
        return this.c;
    }

    public GeneralNames(Vector vector) {
        this.addGeneralNames(vector);
    }

    public String toString() {
        if (this.d == null || this.d.size() < 1) {
            return "General Names: 0 Elements\n";
        }
        StringBuffer stringBuffer = new StringBuffer("GeneralNames: " + this.d.size() + " Elements\n");
        int n = 0;
        int n2 = this.d.size();
        while (n < n2) {
            stringBuffer.append(n + ". " + (GeneralName)this.d.elementAt(n) + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

