/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Constructed;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.CRL;
import com.phaos.cert.PKCS12Bag;
import com.phaos.cert.PKCS12Safe;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PKCS12CRLBag
extends PKCS12Bag {
    private ASN1Sequence c;
    private CRL d;
    private PKCS12Safe e;

    public void output(OutputStream outputStream) throws IOException {
        this.b().output(outputStream);
    }

    public PKCS12CRLBag(PKCS12Safe pKCS12Safe, CRL cRL) {
        this(pKCS12Safe);
        this.d = cRL;
    }

    public PKCS12CRLBag(PKCS12Safe pKCS12Safe) {
        this.e = pKCS12Safe;
    }

    public CRL getCRL() {
        return this.d;
    }

    public PKCS12CRLBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    void a() {
        this.c = null;
        if (this.e != null) {
            this.e.b();
        }
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.a();
        try {
            ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.elementAt(1);
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.elementAt(0);
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence2.elementAt(0);
            if (!aSN1ObjectID.equals(ASN1Utils.pkcsID, 9, 23, 1)) {
                throw new IOException("Unsupported CRL type " + aSN1ObjectID);
            }
            ASN1GenericConstructed aSN1GenericConstructed2 = (ASN1GenericConstructed)aSN1Sequence2.elementAt(1);
            this.d = new CRL(new UnsyncByteArrayInputStream(((ASN1OctetString)aSN1GenericConstructed2.elementAt(0)).getValue()));
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    public void setCRL(CRL cRL) {
        this.d = cRL;
        this.a();
    }

    public String toString() {
        String string = "";
        if (((PKCS12Bag)this).c != null) {
            string = string + "friendlyName = \"" + ((PKCS12Bag)this).c + "\", ";
        }
        if (this.b != null) {
            string = string + "localKeyID = " + Utils.toHexString(this.b) + ", ";
        }
        return string + this.d.toString();
    }

    public PKCS12CRLBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.input(aSN1Sequence);
    }

    public int length() {
        return this.b().length();
    }

    private ASN1Sequence b() {
        if (this.c != null) {
            return this.c;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 4));
        ASN1Constructed aSN1Constructed = new ASN1Sequence();
        aSN1Constructed.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 23, 1));
        aSN1Constructed.addElement(new ASN1GenericConstructed(new ASN1OctetString(Utils.toBytes(this.d)), 0));
        aSN1Sequence.addElement(new ASN1GenericConstructed(aSN1Constructed, 0));
        aSN1Constructed = this.outputAttrsASN1();
        if (aSN1Constructed != null) {
            aSN1Sequence.addElement(aSN1Constructed);
        }
        this.c = aSN1Sequence;
        return aSN1Sequence;
    }
}

