/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.PKCS12Bag;
import com.phaos.cert.PKCS12Safe;
import com.phaos.crypto.PrivateKey;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PKCS12KeyBag
extends PKCS12Bag {
    private ASN1Sequence c;
    private PrivateKey d;
    private PKCS12Safe e;

    public int length() {
        return this.b().length();
    }

    public PKCS12KeyBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.a();
        ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.elementAt(1);
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.elementAt(0);
        this.d = CryptoUtils.inputPrivateKey(Utils.toStream(aSN1Sequence2));
    }

    public void output(OutputStream outputStream) throws IOException {
        this.b().output(outputStream);
    }

    public ASN1Sequence getPrivateKeyInfo() {
        return CryptoUtils.privateKeyInfo(this.d);
    }

    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    private ASN1Sequence b() {
        if (this.c == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 1));
            aSN1Sequence.addElement(new ASN1GenericConstructed(this.d, 0));
            ASN1Set aSN1Set = this.outputAttrsASN1();
            if (aSN1Set != null) {
                aSN1Sequence.addElement(aSN1Set);
            }
            this.c = aSN1Sequence;
        }
        return this.c;
    }

    public PKCS12KeyBag(PKCS12Safe pKCS12Safe) {
        this.e = pKCS12Safe;
    }

    public PrivateKey getPrivateKey() {
        return this.d;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.d = privateKey;
        this.a();
    }

    public PKCS12KeyBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.input(aSN1Sequence);
    }

    public PKCS12KeyBag(PKCS12Safe pKCS12Safe, PrivateKey privateKey) {
        this(pKCS12Safe);
        this.d = privateKey;
    }

    void a() {
        this.c = null;
        if (this.e != null) {
            this.e.b();
        }
    }

    public String toString() {
        String string = "";
        if (((PKCS12Bag)this).c != null) {
            string = string + "friendlyName = \"" + ((PKCS12Bag)this).c + "\", ";
        }
        if (this.b != null) {
            string = string + "localKeyID = " + Utils.toHexString(this.b) + ", ";
        }
        return string + this.d.toString();
    }
}

