/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Constructed;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.CRL;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;

public class PKCS7
implements ASN1Object {
    private byte[] d;
    private RSAPublicKey e;
    private ASN1Sequence f;
    private AlgorithmIdentifier g;
    private Signature h;
    private Vector i;
    private Vector j;
    private X500Name k;
    protected static final int[] pkcs7 = new int[]{1, 2, 840, 113549, 1, 7};
    private BigInteger l;
    private byte[] m;
    private byte[] n;
    private byte[] o;

    public void sign(X509 x509, RSAPrivateKey rSAPrivateKey, byte[] byArray) throws SignatureException {
        this.k = x509.getIssuer();
        this.l = x509.getSerialNo();
        if (!x509.getPublicKey().getAlgorithm().equals("RSA")) {
            throw new SignatureException("Only RSA signatures are supported");
        }
        this.e = (RSAPublicKey)x509.getPublicKey();
        this.h = Signature.getInstance(rSAPrivateKey);
        this.g = PKCS7.b(this.h.getAlgID());
        this.h.setDocument(byArray);
        this.h.sign();
        this.n = this.h.getSigBytes();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.a().output(outputStream);
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        try {
            int n;
            ASN1Constructed aSN1Constructed;
            this.f = aSN1Sequence;
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence.elementAt(0);
            if (!aSN1ObjectID.equals(pkcs7, 2)) {
                throw new IOException("contentType has to be signedData");
            }
            if (aSN1Sequence.elements().size() < 2) {
                throw new IOException("No content");
            }
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1GenericConstructed)aSN1Sequence.elementAt(1)).elementAt(0);
            this.i = null;
            this.j = null;
            int n2 = 3;
            while (!(aSN1Sequence2.elementAt(n2) instanceof ASN1Set)) {
                aSN1Constructed = (ASN1GenericConstructed)aSN1Sequence2.elementAt(n2);
                switch (((ASN1GenericConstructed)aSN1Constructed).getTag()) {
                    case 0: {
                        this.i = new Vector();
                        int n3 = 0;
                        int n4 = ((ASN1GenericConstructed)aSN1Constructed).size();
                        while (n3 < n4) {
                            this.i.addElement(new X509(Utils.toStream(((ASN1GenericConstructed)aSN1Constructed).elementAt(n3))));
                            ++n3;
                        }
                        break;
                    }
                    case 1: {
                        this.j = new Vector();
                        int n5 = 0;
                        n = ((ASN1GenericConstructed)aSN1Constructed).size();
                        while (n5 < n) {
                            this.j.addElement(new CRL(Utils.toStream(((ASN1GenericConstructed)aSN1Constructed).elementAt(n5))));
                            ++n5;
                        }
                        break;
                    }
                }
                ++n2;
            }
            aSN1Constructed = (ASN1Set)aSN1Sequence2.elementAt(n2);
            if (((ASN1Set)aSN1Constructed).elements().size() > 0) {
                n2 = 0;
                ASN1Sequence aSN1Sequence3 = (ASN1Sequence)((ASN1Set)aSN1Constructed).elementAt(0);
                int n6 = ++n2;
                ASN1TaggedObject aSN1TaggedObject = (ASN1Sequence)aSN1Sequence3.elementAt(n6);
                this.k = new X500Name((ASN1Sequence)((ASN1Sequence)aSN1TaggedObject).elementAt(0));
                this.l = ((ASN1Integer)((ASN1Sequence)aSN1TaggedObject).elementAt(1)).getValue();
                int n7 = ++n2;
                this.g = new AlgorithmIdentifier(Utils.toStream((ASN1Sequence)aSN1Sequence3.elementAt(n7)));
                if (aSN1Sequence3.elementAt(++n2) instanceof ASN1GenericConstructed) {
                    aSN1TaggedObject = new ASN1Set(((ASN1GenericConstructed)aSN1Sequence3.elementAt(n2++)).elements());
                    this.d = Utils.toBytes(aSN1TaggedObject);
                    this.o = null;
                    Vector vector = ((ASN1Set)aSN1TaggedObject).elements();
                    n = 0;
                    int n8 = vector.size();
                    while (n < n8) {
                        ASN1Sequence aSN1Sequence4 = (ASN1Sequence)vector.elementAt(n);
                        ASN1ObjectID aSN1ObjectID2 = (ASN1ObjectID)aSN1Sequence4.elementAt(0);
                        if (aSN1ObjectID2.equals(ASN1Utils.pkcsID, 9, 4)) {
                            this.o = ((ASN1OctetString)((ASN1Set)aSN1Sequence4.elementAt(1)).elementAt(0)).getValue();
                        }
                        ++n;
                    }
                    if (this.o == null) {
                        throw new IOException("No message digest found in authenticatedAttributes");
                    }
                }
                if (!((ASN1ObjectID)(aSN1TaggedObject = (ASN1ObjectID)((ASN1Sequence)aSN1Sequence3.elementAt(n2++)).elementAt(0))).equals(AlgID.rsaEncryption.getOID())) {
                    throw new IOException("Unsupported encryption algorithm " + aSN1TaggedObject);
                }
                this.n = ((ASN1OctetString)aSN1Sequence3.elementAt(n2++)).getValue();
            }
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    public Vector getCRLs() {
        return this.j;
    }

    public void setPublicKey(RSAPublicKey rSAPublicKey) {
        this.e = rSAPublicKey;
        if (this.d != null) {
            try {
                this.h = Signature.getInstance(PKCS7.c(this.g));
                this.h.setPublicKey(this.e);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IllegalStateException(invalidKeyException.toString());
            }
            this.h.setDocument(this.d);
            this.h.setSigBytes(this.n);
        }
    }

    public BigInteger getSerialNo() {
        return this.l;
    }

    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public PKCS7() {
    }

    private ASN1Sequence a() {
        if (this.f != null) {
            return this.f;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1ObjectID(pkcs7, 2));
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.addElement(new ASN1Integer(1L));
        aSN1Sequence2.addElement(new ASN1Set());
        ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
        aSN1Sequence3.addElement(new ASN1ObjectID(pkcs7, 1));
        aSN1Sequence2.addElement(aSN1Sequence3);
        if (this.i != null) {
            aSN1Sequence2.addElement(new ASN1GenericConstructed(this.i, 0));
        }
        if (this.j != null) {
            aSN1Sequence2.addElement(new ASN1GenericConstructed(this.j, 1));
        }
        if (this.h == null) {
            aSN1Sequence2.addElement(new ASN1Set());
        } else {
            aSN1Sequence3 = new ASN1Sequence();
            aSN1Sequence3.addElement(new ASN1Integer(1L));
            ASN1Sequence aSN1Sequence4 = new ASN1Sequence();
            aSN1Sequence4.addElement(this.k);
            aSN1Sequence4.addElement(new ASN1Integer(this.l));
            aSN1Sequence3.addElement(aSN1Sequence4);
            aSN1Sequence3.addElement(this.g);
            aSN1Sequence3.addElement(AlgID.rsaEncryption);
            aSN1Sequence3.addElement(new ASN1OctetString(this.n));
            aSN1Sequence2.addElement(new ASN1Set(aSN1Sequence3));
        }
        aSN1Sequence.addElement(new ASN1GenericConstructed(aSN1Sequence2, 0));
        this.f = aSN1Sequence;
        return aSN1Sequence;
    }

    public void addCertificate(X509 x509) {
        if (this.i == null) {
            this.i = new Vector();
        }
        this.i.addElement(x509);
    }

    public PKCS7(X509 x509, RSAPrivateKey rSAPrivateKey, byte[] byArray) throws SignatureException {
        this();
        this.sign(x509, rSAPrivateKey, byArray);
    }

    public int length() {
        return this.a().length();
    }

    public void addCRL(CRL cRL) {
        if (this.j == null) {
            this.j = new Vector();
        }
        this.j.addElement(cRL);
    }

    public PKCS7(Vector vector, Vector vector2) {
        this.i = vector;
        this.j = vector2;
    }

    public PKCS7(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private static AlgorithmIdentifier b(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier.getOID().equals(AlgID.md2WithRSAEncryption.getOID())) {
            return AlgID.md2;
        }
        if (algorithmIdentifier.getOID().equals(AlgID.md5WithRSAEncryption.getOID())) {
            return AlgID.md5;
        }
        if (algorithmIdentifier.getOID().equals(AlgID.sha_1WithRSAEncryption.getOID())) {
            return AlgID.sha_1;
        }
        throw new IllegalStateException("Unsupported signature algorithm identifier");
    }

    public PKCS7(X509 x509) {
        this.i = new Vector();
        this.i.addElement(x509);
    }

    private static AlgorithmIdentifier c(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier.getOID().equals(AlgID.md2.getOID())) {
            return AlgID.md2WithRSAEncryption;
        }
        if (algorithmIdentifier.getOID().equals(AlgID.md5.getOID())) {
            return AlgID.md5WithRSAEncryption;
        }
        if (algorithmIdentifier.getOID().equals(AlgID.sha_1.getOID()) || algorithmIdentifier.getOID().equals(AlgID.sha.getOID())) {
            return AlgID.sha_1WithRSAEncryption;
        }
        throw new IllegalStateException("Unsupported message digest algorithm identifier");
    }

    public void setDocument(byte[] byArray) {
        if (this.e == null) {
            throw new IllegalStateException("The public key is not set");
        }
        if (this.d == null) {
            try {
                this.h = Signature.getInstance(PKCS7.c(this.g));
                this.h.setPublicKey(this.e);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IllegalStateException(invalidKeyException.toString());
            }
            this.h.setDocument(byArray);
            this.h.setSigBytes(this.n);
        } else {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(this.g);
                messageDigest.update(byArray);
                messageDigest.computeCurrent();
                this.m = messageDigest.digestBits;
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
        }
    }

    public PKCS7(CRL cRL) {
        this.j = new Vector();
        this.j.addElement(this.j);
    }

    public PKCS7(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    public void sign(X509 x509, RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws SignatureException {
        this.k = x509.getIssuer();
        this.l = x509.getSerialNo();
        if (!x509.getPublicKey().getAlgorithm().equals("RSA")) {
            throw new SignatureException("Only RSA signatures are supported");
        }
        this.e = (RSAPublicKey)x509.getPublicKey();
        this.g = PKCS7.b(algorithmIdentifier);
        try {
            this.h = Signature.getInstance(algorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new SignatureException(algorithmIdentifierException.toString());
        }
        try {
            this.h.setPrivateKey(rSAPrivateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.toString());
        }
        this.h.setDocument(byArray);
        this.h.sign();
        this.n = this.h.getSigBytes();
    }

    public boolean verify() throws AuthenticationException {
        if (this.d == null) {
            return this.h.verify();
        }
        return this.h.verify() && MessageDigest.isEqual(this.m, this.o);
    }

    public void setSigner(X509 x509) {
        if (this.k == null) {
            this.k = x509.getIssuer();
        } else if (!this.k.equals(x509.getIssuer())) {
            throw new RuntimeException("The issuer is " + this.k + ", which is not " + x509.getIssuer());
        }
        if (this.l == null) {
            this.l = x509.getSerialNo();
        } else if (!this.l.equals(x509.getSerialNo())) {
            throw new RuntimeException("The serial number is " + this.l + ", which is not " + x509.getSerialNo());
        }
        this.setPublicKey((RSAPublicKey)x509.getPublicKey());
    }

    public byte[] getEncoded() {
        return this.a().getEncoded();
    }

    public Vector getCertificates() {
        return this.i;
    }

    public X500Name getIssuer() {
        return this.k;
    }
}

