/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Date;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.X509Extension;
import com.phaos.cert.X509ExtensionSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class RevokedCertificate
implements ASN1Object {
    private ASN1Sequence c = null;
    private Date d;
    private BigInteger e;
    private X509ExtensionSet f = null;

    public X509ExtensionSet getExtensionSet() {
        return this.f;
    }

    public RevokedCertificate(BigInteger bigInteger, Date date) {
        this.e = bigInteger;
        this.d = date;
    }

    public int length() {
        return this.b().length();
    }

    public Vector getExtensions() {
        return this.f != null ? this.f.getExtensions() : null;
    }

    public void addExtension(X509Extension x509Extension) {
        if (this.f == null) {
            this.f = new X509ExtensionSet();
        }
        this.f.addExtension(x509Extension);
    }

    public RevokedCertificate(BigInteger bigInteger, Date date, Vector vector) {
        this(bigInteger, date);
        if (vector != null && vector.size() > 0) {
            this.f = new X509ExtensionSet(vector);
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        this.b().output(outputStream);
    }

    public Enumeration extensionTypes() {
        return this.f != null ? this.f.types() : null;
    }

    public RevokedCertificate(BigInteger bigInteger, Date date, X509ExtensionSet x509ExtensionSet) {
        this(bigInteger, date);
        if (x509ExtensionSet != null && x509ExtensionSet.size() > 0) {
            this.f = x509ExtensionSet;
        }
    }

    public X509Extension getExtension(ASN1ObjectID aSN1ObjectID) {
        return this.f != null ? this.f.getExtension(aSN1ObjectID) : null;
    }

    public Date getRevocationDate() {
        return this.d;
    }

    public RevokedCertificate(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private void a() {
        this.c = null;
    }

    public String toString() {
        String string = "serialNo = " + this.e + ", revocationDate = " + this.d;
        if (this.f != null && this.f.size() > 0) {
            string = string + ", extensions = " + this.f;
        }
        return string;
    }

    public void input(InputStream inputStream) throws IOException {
        this.a();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.e = new ASN1Integer(aSN1SequenceInputStream).getValue();
        this.d = new ASN1Date(aSN1SequenceInputStream).getValue();
        this.f = aSN1SequenceInputStream.hasMoreData() ? new X509ExtensionSet(aSN1SequenceInputStream) : null;
        aSN1SequenceInputStream.terminate();
    }

    private ASN1Sequence b() {
        if (this.c == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(this.getSerialNo()));
            aSN1Sequence.addElement(new ASN1Date(this.getRevocationDate()));
            if (this.f != null && this.f.size() > 0) {
                aSN1Sequence.addElement(this.f);
            }
            this.c = aSN1Sequence;
        }
        return this.c;
    }

    public BigInteger getSerialNo() {
        return this.e;
    }
}

