/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Object;
import com.phaos.cert.CRL;
import com.phaos.cert.CertificateTrustPolicy;
import com.phaos.cert.CertificateVerifier;
import com.phaos.cert.IssuerAndSerialNo;
import com.phaos.cert.PKIX;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.cert.extension.BasicConstraintsExtension;
import com.phaos.crypto.AuthenticationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TrustedCAPolicy
implements CertificateTrustPolicy {
    private Hashtable a = new Hashtable();
    private boolean b = true;
    private boolean c = false;

    public void setRequireCRLs(boolean bl) {
        this.c = bl;
    }

    public void setTrustedCAs(Vector vector) {
        this.a.clear();
        if (vector == null) {
            return;
        }
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            X509 x509 = (X509)vector.elementAt(n);
            this.a.put(x509.getSubject(), x509);
            ++n;
        }
    }

    public boolean getRequireCAFlag() {
        return this.b;
    }

    public boolean getRequireCRLs() {
        return this.c;
    }

    public TrustedCAPolicy(Vector vector, boolean bl, boolean bl2) {
        this.setTrustedCAs(vector);
        this.c = bl;
        this.b = bl2;
    }

    public void addTrustedCA(X509 x509) {
        this.a.put(x509.getSubject(), x509);
    }

    public CertificateVerifier makeCertificateVerifier(Vector vector, Vector vector2) {
        return new TrustedCACertificateVerifier(vector, vector2);
    }

    public Enumeration trustedCAs() {
        return this.a.elements();
    }

    public void setRequireCAFlag(boolean bl) {
        this.b = bl;
    }

    public TrustedCAPolicy() {
    }

    class TrustedCACertificateVerifier
    implements CertificateVerifier {
        private Hashtable b;
        private Hashtable c;
        private Hashtable d = new Hashtable();

        public X509 getValidCertificate(IssuerAndSerialNo issuerAndSerialNo) throws AuthenticationException {
            Object object;
            X509 x509 = (X509)this.d.get(issuerAndSerialNo);
            if (x509 == null) {
                return null;
            }
            if (TrustedCAPolicy.this.a.containsKey(x509.getSubject())) {
                return x509;
            }
            Vector<X509> vector = new Vector<X509>();
            X500Name x500Name = null;
            while (x509 != null) {
                object = this.b.get(x509.getIssuer());
                if (object != null && vector.contains(object)) {
                    throw new AuthenticationException("Chain does not terminate with a trusted CA");
                }
                vector.addElement(x509);
                x500Name = x509.getIssuer();
                x509 = (X509)this.b.get(x500Name);
                if (TrustedCAPolicy.this.a.containsKey(x500Name)) break;
                if (x509 != null) continue;
                throw new AuthenticationException("Chain does not terminate with a trusted CA");
            }
            object = (X509)TrustedCAPolicy.this.a.get(x500Name);
            boolean bl = false;
            while (!vector.isEmpty()) {
                BasicConstraintsExtension basicConstraintsExtension;
                x509 = (X509)vector.lastElement();
                CRL cRL = (CRL)this.c.get(((X509)object).getSubject());
                x509.setIssuerCertificate((X509)object);
                if (cRL != null) {
                    x509.setIssuerCRL(cRL);
                } else if (TrustedCAPolicy.this.c) {
                    throw new AuthenticationException("CRL not found for certificate");
                }
                if (TrustedCAPolicy.this.b && bl && ((basicConstraintsExtension = (BasicConstraintsExtension)((X509)object).getExtension(PKIX.id_ce_basicConstraints)) == null || !basicConstraintsExtension.getCA())) {
                    throw new AuthenticationException("Certificate is not a CA");
                }
                if (!x509.verify()) {
                    throw new AuthenticationException("Certificate invalid");
                }
                object = x509;
                vector.removeElementAt(vector.size() - 1);
                bl = true;
            }
            return x509;
        }

        TrustedCACertificateVerifier(Vector vector, Vector vector2) {
            ASN1Object aSN1Object;
            int n;
            int n2;
            this.b = new Hashtable();
            this.c = new Hashtable();
            if (vector != null) {
                n2 = 0;
                n = vector.size();
                while (n2 < n) {
                    aSN1Object = (X509)vector.elementAt(n2);
                    IssuerAndSerialNo issuerAndSerialNo = new IssuerAndSerialNo((X509)aSN1Object);
                    this.d.put(issuerAndSerialNo, aSN1Object);
                    this.b.put(((X509)aSN1Object).getSubject(), aSN1Object);
                    ++n2;
                }
            }
            if (vector2 != null) {
                n2 = 0;
                n = vector2.size();
                while (n2 < n) {
                    aSN1Object = (CRL)vector2.elementAt(n2);
                    this.c.put(((CRL)aSN1Object).getIssuer(), aSN1Object);
                    ++n2;
                }
            }
        }
    }
}

