/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.cert.GeneralName;
import com.phaos.cert.PKIX;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.cert.X509Extension;
import com.phaos.cert.X509ExtensionSet;
import com.phaos.cert.extension.AuthorityKeyIDExtension;
import com.phaos.cert.extension.BasicConstraintsExtension;
import com.phaos.cert.extension.CRLNumberExtension;
import com.phaos.cert.extension.CertificatePoliciesExtension;
import com.phaos.cert.extension.KeyUsageExtension;
import com.phaos.cert.extension.NetscapeCertTypeExtension;
import com.phaos.cert.extension.SubjectKeyIDExtension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class X509Attributes {
    public static final int CR_LIST = 1;
    private boolean b;
    public static final int SET_CARD = 1;
    private boolean c;
    private X500Name d;
    public static final int NETSCAPE_SSL_CLIENT = 1;
    private byte[] e;
    private int f;
    public static final int OTHER = 2;
    private boolean g;
    public static final int DIGITAL_SIGNATURE = 1;
    public static final int SET_MER = 2;
    private boolean h;
    private byte[] i;
    private Vector j;
    private Vector k;
    public static final int KEY_AGREEMENT = 16;
    public static final int KEY_ENCIPHERMENT = 4;
    private boolean l;
    private boolean m;
    private BigInteger n;
    public static final int SET_RCA = 256;
    public static final int SET_MCA = 16;
    public static final int SET_CCA = 8;
    private boolean o;
    private BigInteger p;
    private boolean q;
    private boolean r;
    public static final int NON_REPUDIATION = 2;
    private int s;
    private boolean t;
    public static final int CERTIFICATE = 0;
    public static final int SET_GCA = 64;
    public static final int SET_BCA = 128;
    public static final int NETSCAPE_EMAIL_CA = 64;
    private boolean u;
    public static final int NETSCAPE_SSL_CA = 32;
    private int v;
    private boolean w;
    public static final int CRL_SIGN = 64;
    private boolean x;
    public static final int SET_PCA = 32;
    public static final int SET_PGWY = 4;
    public static final int DATA_ENCIPHERMENT = 8;
    public static final int DECIPHER_ONLY = 256;
    public static final int NETSCAPE_EMAIL = 4;
    private boolean y;
    private boolean z;
    private boolean A;
    public static final int NETSCAPE_OBJECT_SIGNER = 8;
    private boolean B;
    public static final int NETSCAPE_SSL_SERVER = 2;
    private boolean C;
    public static final int KEY_CERT_SIGN = 32;
    public static final int NETSCAPE_CODE_SIGNING_CA = 128;
    public static final int SET_ACQ = 512;
    public static final int ENCIPHER_ONLY = 128;

    public X500Name getAuthorityKeyIdentifierIssuer() {
        this.a(this.y);
        return this.d;
    }

    public boolean isAuthorityKeyIdentifierDefined() {
        return this.y || this.A;
    }

    public boolean getCA() {
        this.a(this.x);
        return this.u;
    }

    public void setAuthorityKeyIdentifier(X509 x509, boolean bl) {
        this.setAuthorityKeyIdentifier((X500Name)x509.getHolder(), x509.getSerialNo(), bl);
    }

    public boolean isSubjectKeyIdentifierCritical() {
        this.a(this.c);
        return this.o;
    }

    private void a(boolean bl) throws IllegalStateException {
        if (!bl) {
            throw new IllegalStateException("Attempt to access an undefined attribute");
        }
    }

    public boolean isCertificatePoliciesDefined() {
        return this.C;
    }

    public void setNetscapeCertType(int n, boolean bl) {
        this.s = n;
        this.l = bl;
        this.g = true;
    }

    public boolean isCADefined() {
        return this.x;
    }

    public boolean isAuthorityKeyIdentifierIsnDefined() {
        return this.y;
    }

    public boolean isNetscapeCertTypeCritical() {
        this.a(this.g);
        return this.l;
    }

    public void setNetscapeCertType(int n) {
        this.setNetscapeCertType(n, false);
    }

    public BigInteger getAuthorityKeyIdentifierSerialNo() {
        this.a(this.y);
        return this.p;
    }

    public void setAuthorityKeyIdentifier(byte[] byArray, boolean bl) {
        this.e = byArray;
        this.w = bl;
        this.A = true;
    }

    public void setSETCertType(int n, boolean bl) {
        this.v = n;
        this.B = bl;
        this.q = true;
    }

    public void setCA(boolean bl) {
        this.setCA(bl, true);
    }

    public void setCRLNumber(BigInteger bigInteger, boolean bl) {
        this.n = bigInteger;
        this.m = bl;
        this.z = true;
    }

    public byte[] getSubjectKeyIdentifier() {
        this.a(this.c);
        return this.i;
    }

    public void setKeyUsage(int n, boolean bl) {
        this.f = n;
        this.r = bl;
        this.t = true;
    }

    public void setAuthorityKeyIdentifier(byte[] byArray) {
        this.setAuthorityKeyIdentifier(byArray, false);
    }

    public void setSETCertType(int n) {
        this.setSETCertType(n, true);
    }

    public void setAuthorityKeyIdentifier(X500Name x500Name, BigInteger bigInteger) {
        this.setAuthorityKeyIdentifier(x500Name, bigInteger, false);
    }

    public boolean isSubjectKeyIdentifierDefined() {
        return this.c;
    }

    public boolean isNetscapeCertTypeDefined() {
        return this.g;
    }

    public void addGenericExt(X509Extension x509Extension) {
        if (this.j == null) {
            this.j = new Vector();
        }
        this.j.addElement(x509Extension);
    }

    public boolean isKeyUsageCritical() {
        this.a(this.t);
        return this.r;
    }

    public void setGenericExts(Vector vector) {
        this.j = vector;
    }

    public void setCertificatePolicies(Vector vector) {
        this.setCertificatePolicies(vector, false);
    }

    public void setCRLNumber(BigInteger bigInteger) {
        this.setCRLNumber(bigInteger, false);
    }

    public void setAuthorityKeyIdentifier(X509 x509) {
        this.setAuthorityKeyIdentifier((X500Name)x509.getHolder(), x509.getSerialNo(), false);
    }

    public boolean isSETCertTypeCritical() {
        this.a(this.q);
        return this.B;
    }

    public byte[] getAuthorityKeyIdentifierID() {
        this.a(this.A);
        return this.e;
    }

    public BigInteger getCRLNumber() {
        this.a(this.z);
        return this.n;
    }

    public boolean isAuthorityKeyIdentifierCritical() {
        this.a(this.y || this.A);
        return this.w;
    }

    public void setAuthorityKeyIdentifier(X500Name x500Name, BigInteger bigInteger, boolean bl) {
        this.d = x500Name;
        this.p = bigInteger;
        this.w = bl;
        this.y = true;
    }

    public boolean isKeyUsageDefined() {
        return this.t;
    }

    public String toString() {
        int n;
        boolean bl;
        String[] stringArray;
        String string = "";
        if (this.x) {
            string = string + ", CA = " + this.u;
        }
        if (this.t) {
            stringArray = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};
            string = string + ", keyUsage = {";
            bl = false;
            n = 0;
            while (n < 7) {
                if ((this.f & 1 << n) != 0) {
                    if (bl) {
                        string = string + ", ";
                    }
                    bl = true;
                    string = string + stringArray[n];
                }
                ++n;
            }
            string = string + "}";
        }
        if (this.C) {
            string = string + ", certificatePolicies = " + this.k;
        }
        if (this.c) {
            string = string + ", subjectKeyIdentifier = " + Utils.toHexString(this.i);
        }
        if (this.A || this.y) {
            string = string + ", authorityKeyIdentifier = ";
            string = this.y ? string + "{issuer = " + this.d + ", serialNo = " + this.p + "}" : string + "{keyID = " + Utils.toHexString(this.e) + "}";
        }
        if (this.g) {
            stringArray = new String[]{"SSL-client", "SSL-server", "E-mail", "Object-Signer", "unknown4", "SSL-CA", "E-mail-CA", "Object-Signing-CA"};
            string = string + ", netscapeCertType = {";
            bl = false;
            n = 0;
            while (n < 8) {
                if ((this.s & 1 << n) != 0) {
                    if (bl) {
                        string = string + ", ";
                    }
                    bl = true;
                    string = string + stringArray[n];
                }
                ++n;
            }
            string = string + "}";
        }
        if (this.q) {
            stringArray = new String[]{"card", "mer", "pgwy", "cca", "mca", "pca", "gca", "bca", "rca", "acq"};
            string = string + ", setCertType = {";
            bl = false;
            n = 0;
            while (n < 10) {
                if ((this.v & 1 << n) != 0) {
                    if (bl) {
                        string = string + ", ";
                    }
                    bl = true;
                    string = string + stringArray[n];
                }
                ++n;
            }
            string = string + "}";
        }
        if (this.z) {
            string = string + ", CRLNumber = " + this.n;
        }
        if (this.j != null && this.j.size() > 0) {
            string = string + ", genericExts = {";
            boolean bl2 = false;
            Enumeration enumeration = this.j.elements();
            while (enumeration.hasMoreElements()) {
                if (bl2) {
                    string = string + ", ";
                } else {
                    bl2 = true;
                }
                string = string + "[" + (X509Extension)enumeration.nextElement() + "]";
            }
            string = string + "}";
        }
        if (string.length() > 0) {
            return string.substring(2);
        }
        return string;
    }

    public static X509Attributes fromExtensionSet(X509ExtensionSet x509ExtensionSet, int n) {
        X509Attributes x509Attributes = new X509Attributes();
        Enumeration enumeration = x509ExtensionSet.getExtensions().elements();
        while (enumeration.hasMoreElements()) {
            X509Extension x509Extension;
            X509Extension x509Extension2 = (X509Extension)enumeration.nextElement();
            ASN1ObjectID aSN1ObjectID = x509Extension2.getType();
            if (n == 0 && aSN1ObjectID.equals(PKIX.id_ce_basicConstraints)) {
                x509Attributes.x = true;
                x509Attributes.h = x509Extension2.getCritical();
                x509Attributes.u = ((BasicConstraintsExtension)x509Extension2).getCA();
                continue;
            }
            if (n == 0 && aSN1ObjectID.equals(PKIX.id_ce_keyUsage)) {
                x509Attributes.t = true;
                x509Attributes.r = x509Extension2.getCritical();
                x509Extension = (KeyUsageExtension)x509Extension2;
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(0)) {
                    x509Attributes.f |= 1;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(1)) {
                    x509Attributes.f |= 2;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(2)) {
                    x509Attributes.f |= 4;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(3)) {
                    x509Attributes.f |= 8;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(4)) {
                    x509Attributes.f |= 0x10;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(5)) {
                    x509Attributes.f |= 0x20;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(6)) {
                    x509Attributes.f |= 0x40;
                }
                if (((KeyUsageExtension)x509Extension).hasUsageFlag(7)) {
                    x509Attributes.f |= 0x80;
                }
                if (!((KeyUsageExtension)x509Extension).hasUsageFlag(8)) continue;
                x509Attributes.f |= 0x100;
                continue;
            }
            if (n == 0 && aSN1ObjectID.equals(PKIX.id_ce_certificatePolicies)) {
                x509Attributes.C = true;
                x509Attributes.b = x509Extension2.getCritical();
                x509Attributes.k = ((CertificatePoliciesExtension)x509Extension2).getCertificatePolicies();
                continue;
            }
            if ((n == 0 || n == 1) && aSN1ObjectID.equals(PKIX.id_ce_authorityKeyIdentifier)) {
                x509Attributes.w = x509Extension2.getCritical();
                x509Extension = (AuthorityKeyIDExtension)x509Extension2;
                x509Attributes.e = ((AuthorityKeyIDExtension)x509Extension).getAuthorityKeyID();
                Enumeration enumeration2 = ((AuthorityKeyIDExtension)x509Extension).authorityCertIssuer();
                while (enumeration2 != null && enumeration2.hasMoreElements()) {
                    Object e = enumeration2.nextElement();
                    if (!(e instanceof X500Name)) continue;
                    x509Attributes.d = (X500Name)e;
                    break;
                }
                x509Attributes.p = ((AuthorityKeyIDExtension)x509Extension).getAuthorityCertSerialNo();
                if (x509Attributes.e != null) {
                    x509Attributes.A = true;
                }
                if (x509Attributes.d == null || x509Attributes.p == null) continue;
                x509Attributes.y = true;
                continue;
            }
            if (n == 0 && aSN1ObjectID.equals(PKIX.id_ce_subjectKeyIdentifier)) {
                x509Attributes.c = true;
                x509Attributes.o = x509Extension2.getCritical();
                x509Attributes.i = ((SubjectKeyIDExtension)x509Extension2).getSubjectKeyID();
                continue;
            }
            if (n == 0 && aSN1ObjectID.equals(X509Extension.id_netscape_ce_type)) {
                x509Attributes.g = true;
                x509Attributes.l = x509Extension2.getCritical();
                x509Extension = (NetscapeCertTypeExtension)x509Extension2;
                if (((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(0)) {
                    x509Attributes.s |= 1;
                }
                if (((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(1)) {
                    x509Attributes.s |= 2;
                }
                if (((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(2)) {
                    x509Attributes.s |= 4;
                }
                if (((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(3)) {
                    x509Attributes.s |= 8;
                }
                if (((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(5)) {
                    x509Attributes.s |= 0x20;
                }
                if (((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(6)) {
                    x509Attributes.s |= 0x40;
                }
                if (!((NetscapeCertTypeExtension)x509Extension).hasUsageFlag(7)) continue;
                x509Attributes.s |= 0x80;
                continue;
            }
            if (n == 0 && aSN1ObjectID.equals(X509Extension.id_set_ce_type)) {
                x509Attributes.q = true;
                x509Attributes.B = x509Extension2.getCritical();
                try {
                    x509Attributes.v = new ASN1BitString(new UnsyncByteArrayInputStream(x509Extension2.getValue())).intValue();
                }
                catch (IOException iOException) {
                    x509Attributes.v = 0;
                }
                continue;
            }
            if (n == 1 && aSN1ObjectID.equals(PKIX.id_ce_cRLNumber)) {
                x509Attributes.z = true;
                x509Attributes.m = x509Extension2.getCritical();
                x509Attributes.n = ((CRLNumberExtension)x509Extension2).getCRLNumber();
                continue;
            }
            x509Attributes.addGenericExt(x509Extension2);
        }
        return x509Attributes;
    }

    public boolean isCACritical() {
        this.a(this.x);
        return this.h;
    }

    public void setSubjectKeyIdentifier(byte[] byArray, boolean bl) {
        this.i = byArray;
        this.o = bl;
        this.c = true;
    }

    public void setKeyUsage(int n) {
        this.setKeyUsage(n, true);
    }

    public void setSubjectKeyIdentifier(byte[] byArray) {
        this.setSubjectKeyIdentifier(byArray, false);
    }

    public boolean isAuthorityKeyIdentifierIdDefined() {
        return this.A;
    }

    public Vector getCertificatePolicies() {
        this.a(this.C);
        return this.k;
    }

    public boolean isCertificatePoliciesCritical() {
        this.a(this.C);
        return this.b;
    }

    public boolean isCRLNumberCritical() {
        this.a(this.z);
        return this.m;
    }

    public static X509ExtensionSet toExtensionSet(X509Attributes x509Attributes) {
        Object object;
        X509ExtensionSet x509ExtensionSet = new X509ExtensionSet();
        if (x509Attributes.x) {
            x509ExtensionSet.addExtension(new BasicConstraintsExtension(x509Attributes.u, x509Attributes.h));
        }
        if (x509Attributes.t) {
            object = new KeyUsageExtension(x509Attributes.r);
            if ((x509Attributes.f & 1) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(0);
            }
            if ((x509Attributes.f & 2) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(1);
            }
            if ((x509Attributes.f & 4) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(2);
            }
            if ((x509Attributes.f & 8) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(3);
            }
            if ((x509Attributes.f & 0x10) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(4);
            }
            if ((x509Attributes.f & 0x20) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(5);
            }
            if ((x509Attributes.f & 0x40) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(6);
            }
            if ((x509Attributes.f & 0x80) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(7);
            }
            if ((x509Attributes.f & 0x100) != 0) {
                ((KeyUsageExtension)object).setUsageFlag(8);
            }
            x509ExtensionSet.addExtension((X509Extension)object);
        }
        if (x509Attributes.C) {
            x509ExtensionSet.addExtension(new CertificatePoliciesExtension(x509Attributes.k, x509Attributes.b));
        }
        if (x509Attributes.A) {
            x509ExtensionSet.addExtension(new AuthorityKeyIDExtension(x509Attributes.e, x509Attributes.w));
        } else if (x509Attributes.y) {
            x509ExtensionSet.addExtension(new AuthorityKeyIDExtension(new GeneralName(x509Attributes.d), x509Attributes.p, x509Attributes.w));
        }
        if (x509Attributes.c) {
            x509ExtensionSet.addExtension(new SubjectKeyIDExtension(x509Attributes.i, x509Attributes.o));
        }
        if (x509Attributes.g) {
            object = new NetscapeCertTypeExtension(x509Attributes.l);
            if ((x509Attributes.s & 1) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(0);
            }
            if ((x509Attributes.s & 2) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(1);
            }
            if ((x509Attributes.s & 4) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(2);
            }
            if ((x509Attributes.s & 8) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(3);
            }
            if ((x509Attributes.s & 0x20) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(5);
            }
            if ((x509Attributes.s & 0x40) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(6);
            }
            if ((x509Attributes.s & 0x80) != 0) {
                ((NetscapeCertTypeExtension)object).setUsageFlag(7);
            }
            x509ExtensionSet.addExtension((X509Extension)object);
        }
        if (x509Attributes.q) {
            x509ExtensionSet.addExtension(new X509Extension(X509Extension.id_set_ce_type, x509Attributes.B, new ASN1BitString(BigInteger.valueOf(x509Attributes.v))));
        }
        if (x509Attributes.z) {
            x509ExtensionSet.addExtension(new CRLNumberExtension(x509Attributes.n, x509Attributes.m));
        }
        if (x509Attributes.j != null) {
            object = x509Attributes.j.elements();
            while (object.hasMoreElements()) {
                x509ExtensionSet.addExtension((X509Extension)object.nextElement());
            }
        }
        return x509ExtensionSet;
    }

    public Vector getGenericExts() {
        return this.j;
    }

    public boolean isCRLNumberDefined() {
        return this.z;
    }

    public void setCA(boolean bl, boolean bl2) {
        this.u = bl;
        this.h = bl2;
        this.x = true;
    }

    public int getKeyUsage() {
        this.a(this.t);
        return this.f;
    }

    public void setCertificatePolicies(Vector vector, boolean bl) {
        this.k = vector;
        this.b = bl;
        this.C = true;
    }

    public int getNetscapeCertType() {
        this.a(this.g);
        return this.s;
    }

    public boolean isSETCertTypeDefined() {
        return this.q;
    }

    public int getSETCertType() {
        this.a(this.q);
        return this.v;
    }
}

