/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1String;
import com.phaos.cert.PKIX;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class X509PolicyInformation
implements ASN1Object {
    private ASN1Sequence c;
    private ASN1ObjectID d;
    private Vector e;

    private void a() {
        this.c = null;
    }

    public Vector getPolicyQualifiers() {
        return this.e;
    }

    public X509PolicyInformation(ASN1ObjectID aSN1ObjectID) {
        this.d = aSN1ObjectID;
    }

    public X509PolicyInformation() {
    }

    public X509PolicyInformation(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public int length() {
        return this.b().length();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("id = " + this.d);
        if (this.e != null) {
            stringBuffer.append(", policyQualifiers = " + Utils.toHexString(Utils.toBytes(new ASN1Sequence(this.e))));
        }
        return stringBuffer.toString();
    }

    public void addCPSPointer(String string) {
        this.addPolicyQualifier(PKIX.id_qt_cps, new ASN1String(string, 22));
    }

    public X509PolicyInformation(ASN1ObjectID aSN1ObjectID, Vector vector) {
        this.d = aSN1ObjectID;
        this.e = vector;
    }

    public void addUserNotice(String string, int[] nArray, String string2) {
        if (string == null ^ nArray == null) {
            throw new IllegalArgumentException("Both or neither of organization and noticeNumbers must be present");
        }
        if (string == null && string2 == null) {
            throw new IllegalArgumentException("No user notice content given");
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (string != null) {
            ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
            aSN1Sequence2.addElement(new ASN1String(string));
            ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                aSN1Sequence3.addElement(new ASN1Integer(nArray[n]));
                ++n;
            }
            aSN1Sequence2.addElement(aSN1Sequence3);
            aSN1Sequence.addElement(aSN1Sequence2);
        }
        if (string2 != null) {
            aSN1Sequence.addElement(new ASN1String(string2));
        }
        this.addPolicyQualifier(PKIX.id_qt_unotice, aSN1Sequence);
    }

    public void addPolicyQualifier(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        if (this.d.equals(PKIX.anyPolicy) && !aSN1ObjectID.equals(PKIX.id_qt_cps) && !aSN1ObjectID.equals(PKIX.id_qt_unotice)) {
            throw new IllegalArgumentException("Illegal qualifier type for anyPolicy policy");
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(aSN1ObjectID);
        aSN1Sequence.addElement(aSN1Object);
        if (this.e == null) {
            this.e = new Vector();
        }
        this.e.addElement(aSN1Sequence);
        this.a();
    }

    public ASN1ObjectID getID() {
        return this.d;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.b().output(outputStream);
    }

    private ASN1Sequence b() {
        if (this.c == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.d);
            if (this.e != null) {
                aSN1Sequence.addElement(new ASN1Sequence(this.e));
            }
            this.c = aSN1Sequence;
        }
        return this.c;
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.d = new ASN1ObjectID(aSN1SequenceInputStream);
        this.e = aSN1SequenceInputStream.hasMoreData() ? new ASN1Sequence(aSN1SequenceInputStream).elements() : null;
        aSN1SequenceInputStream.terminate();
        this.a();
    }
}

