/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1Boolean;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class BasicConstraintsExtension
extends X509Extension {
    private boolean c = false;
    private BigInteger d = null;
    private static final ASN1ObjectID e = PKIX.id_ce_basicConstraints;

    public BasicConstraintsExtension(BigInteger bigInteger) {
        this(bigInteger, true);
    }

    public BasicConstraintsExtension() {
        super(e);
    }

    public BasicConstraintsExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    private byte[] a() {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.c) {
            aSN1Sequence.addElement(new ASN1Boolean(true));
        }
        if (this.d != null) {
            aSN1Sequence.addElement(new ASN1Integer(this.d));
        }
        byte[] byArray = Utils.toBytes(aSN1Sequence);
        this.isDecoded = true;
        return byArray;
    }

    public boolean getCA() {
        if (!this.isDecoded) {
            this.b();
        }
        return this.c;
    }

    private void b() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 1) {
                this.c = ASN1Boolean.inputValue(aSN1SequenceInputStream);
            }
            if (aSN1SequenceInputStream.hasMoreData()) {
                if (this.c) {
                    this.d = ASN1Integer.inputValue(aSN1SequenceInputStream);
                } else {
                    throw new ASN1FormatException("Malformed extension contents");
                }
            }
            aSN1SequenceInputStream.terminate();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    public BasicConstraintsExtension(boolean bl, boolean bl2) {
        super(e, bl2);
        this.c = bl;
        this.setValue(this.a());
    }

    public BasicConstraintsExtension(boolean bl) {
        this(bl, true);
    }

    public String toString() {
        if (!this.isDecoded) {
            this.b();
        }
        return "basicConstraintsExtension {oid = " + e.toStringCompact() + ", critical = " + this.getCritical() + ", value = [ CA = " + this.getCA() + (this.getPathLen() != null ? ", pathLen = " + this.getPathLen() : "") + "]}";
    }

    public BigInteger getPathLen() {
        if (!this.isDecoded) {
            this.b();
        }
        return this.d;
    }

    public BasicConstraintsExtension(BigInteger bigInteger, boolean bl) {
        super(e, bl);
        this.c = true;
        this.d = bigInteger;
        this.setValue(this.a());
    }
}

