/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.Coder;
import com.phaos.crypto.CoderException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CoderOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int mode = 1;
    public static final int DECODE_MODE = 0;
    public static final int ENCODE_MODE = 1;
    protected Coder coder;
    protected int count;

    public void setMode(int n) {
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public synchronized void write(int n) throws IOException {
        this.buf[this.count++] = (byte)n;
        try {
            if (this.count == this.coder.blockSize()) {
                this.count = 0;
                if (this.mode == 1) {
                    this.out.write(this.coder.encodeOp(this.buf));
                } else {
                    this.out.write(this.coder.decodeOp(this.buf));
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (CoderException coderException) {
            throw new IOException(coderException.toString());
        }
    }

    public synchronized void flush() throws IOException {
        if (this.count != 0) {
            throw new IOException("Data length not multiple of block size");
        }
        this.out.flush();
    }

    public Coder getCoder() {
        return this.coder;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            this.write(byArray[n3]);
            ++n3;
        }
    }

    public CoderOutputStream(OutputStream outputStream, Coder coder) {
        super(outputStream);
        this.coder = coder;
        this.buf = new byte[this.coder.blockSize()];
        this.count = 0;
    }
}

