/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.BlockCipher;
import com.phaos.crypto.CBCAlgorithmIdentifier;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.DES;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.Padding;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.Utils;

public final class DES_EDE
extends BlockCipher {
    private int[] e;
    private static final int f = 8;
    private int[] g;
    private int[] h;
    private int[] i;
    private int[] j;
    private int[] k;
    private int[] l;
    private byte[] m;
    private byte[] n;

    private void a(byte[] byArray) {
        byte[] byArray2 = this.getIV();
        String string = "couldn't reset cipher IV";
        if (byArray != null) {
            string = "couldn't set IV provided with algID";
        } else if (byArray2 != null) {
            byArray = byArray2;
            string = "couldn't reset cipher IV";
        } else if (byArray2 == null) {
            byArray = this.b().randomBytes(new byte[this.blockSize]);
            string = "couldn't randomize cipher IV";
        }
        try {
            this.setIV(byArray);
        }
        catch (CipherException cipherException) {
            throw new IllegalStateException(string + ":  " + cipherException.toString());
        }
        this.paddingID = Padding.PKCS5;
    }

    private void b(int n) {
        if (n == 0) {
            this.mode = n;
        } else if (n == 1) {
            this.mode = n;
            this.a(null);
        } else {
            throw new IllegalArgumentException("invalid cipher mode " + n);
        }
    }

    public void setEncryptionKey(Key key) throws InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("Key must be an instance of a SymmetricKey to be used with the DES_EDE cipher");
        }
        super.setEncryptionKey(key);
        this.d((SymmetricKey)this.key);
        this.releaseOp();
        this.a();
    }

    public String algName() {
        return "DES-EDE";
    }

    public void encryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertEncryption();
        DES.d(byArray, n, this.n, 0, this.k, this.e);
        DES.d(this.n, 0, this.m, 0, this.h, this.e);
        DES.d(this.m, 0, byArray2, n2, this.g, this.e);
    }

    private void c(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.DES_EDE3_ECB.getOID())) {
            this.b(0);
        } else if (algorithmIdentifier.getOID().equals(AlgID.DES_EDE3_CBC.getOID())) {
            this.b(1);
            this.a(CryptoUtils.getIV(algorithmIdentifier));
        } else {
            throw new AlgorithmIdentifierException("Unknown AlgorithmIdentifier " + algorithmIdentifier + " for DES_EDE");
        }
    }

    public String toString() {
        return "DES-EDE" + (this.mode == 1 ? "-CBC" : "") + (this.getKey() != null ? "; key = " + Utils.toHexString(this.getKey().getBytes()) : "") + "; iv = " + Utils.toHexString(this.getIV());
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.c(algorithmIdentifier);
        this.releaseOp();
    }

    public void decryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertDecryption();
        DES.d(byArray, n, this.n, 0, this.i, this.e);
        DES.d(this.n, 0, this.m, 0, this.j, this.e);
        DES.d(this.m, 0, byArray2, n2, this.l, this.e);
    }

    public DES_EDE() {
        this(0);
    }

    public void setKey(SymmetricKey symmetricKey) throws InvalidKeyException {
        if (!(symmetricKey instanceof SymmetricKey)) {
            throw new InvalidKeyException("Key must be an instance of a SymmetricKey to be used with the DES_EDE cipher");
        }
        super.setKey(symmetricKey);
        this.d((SymmetricKey)this.key);
        this.releaseOp();
        this.a();
    }

    private void d(SymmetricKey symmetricKey) throws InvalidKeyException {
        if (symmetricKey.getBytes().length != 24 && symmetricKey.getBytes().length != 16 && symmetricKey.getBytes().length != 8) {
            throw new IllegalArgumentException("DES-EDE key must be 8, 16 or 24 bytes long.");
        }
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        System.arraycopy(symmetricKey.getBytes(), 0, byArray, 0, 8);
        if (symmetricKey.getBytes().length > 8) {
            System.arraycopy(symmetricKey.getBytes(), 8, byArray2, 0, 8);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, 8);
        }
        if (symmetricKey.getBytes().length > 16) {
            System.arraycopy(symmetricKey.getBytes(), 16, byArray3, 0, 8);
        } else {
            System.arraycopy(byArray, 0, byArray3, 0, 8);
        }
        this.k = new int[32];
        this.l = new int[32];
        this.j = new int[32];
        this.h = new int[32];
        this.g = new int[32];
        this.i = new int[32];
        DES.l(byArray, this.k, true);
        DES.l(byArray, this.l, false);
        DES.l(byArray2, this.j, true);
        DES.l(byArray2, this.h, false);
        DES.l(byArray3, this.g, true);
        DES.l(byArray3, this.i, false);
        if (this.n == null) {
            this.n = new byte[8];
            this.m = new byte[8];
        }
        Utils.setArray(byArray, (byte)0);
        Utils.setArray(byArray2, (byte)0);
        Utils.setArray(byArray3, (byte)0);
    }

    public void setMode(int n) {
        if (n == 0) {
            this.b(n);
        } else if (n == 1) {
            this.b(n);
        } else {
            throw new IllegalArgumentException("The value, " + n + ", is not recognized " + "as a valid block mode");
        }
        this.releaseOp();
        this.a();
    }

    public void erase() {
        super.erase();
        Utils.setArray(this.k, 0);
        Utils.setArray(this.j, 0);
        Utils.setArray(this.g, 0);
        Utils.setArray(this.l, 0);
        Utils.setArray(this.h, 0);
        Utils.setArray(this.i, 0);
        Utils.setArray(this.n, (byte)0);
        Utils.setArray(this.m, (byte)0);
    }

    public AlgorithmIdentifier getAlgID() {
        if (this.mode == 0) {
            return new AlgorithmIdentifier(AlgID.DES_EDE3_ECB.getOID());
        }
        if (this.mode == 1) {
            return new CBCAlgorithmIdentifier(AlgID.DES_EDE3_CBC.getOID(), this.getIV());
        }
        throw new IllegalStateException("unknown mode " + this.mode);
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("The key is not an instance of SymmetricKey");
        }
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        super.setKey((SymmetricKey)key);
        this.d((SymmetricKey)this.key);
        this.releaseOp();
        this.rbs = null;
        try {
            this.setIV(null);
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.getMessage());
        }
        this.c(algorithmIdentifier);
        this.paddingID = Padding.NONE;
    }

    protected void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        DES.d(byArray, n, this.n, 0, this.i, this.e);
        DES.d(this.n, 0, this.m, 0, this.j, this.e);
        DES.d(this.m, 0, byArray2, n2, this.l, this.e);
    }

    public DES_EDE(int n) {
        super(8);
        this.b(n);
        this.e = new int[2];
    }

    public void setDecryptionKey(Key key) throws InvalidKeyException {
        super.setDecryptionKey(key);
        this.d((SymmetricKey)this.key);
        this.releaseOp();
        this.a();
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (iD == null) {
            throw new CipherException("The paddingID parameter cannot be null");
        }
        super.setKey(symmetricKey);
        this.d((SymmetricKey)this.key);
        this.releaseOp();
        this.rbs = null;
        this.setIV(null);
        this.c(algorithmIdentifier);
        this.paddingID = iD;
    }

    protected void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        DES.d(byArray, n, this.n, 0, this.k, this.e);
        DES.d(this.n, 0, this.m, 0, this.h, this.e);
        DES.d(this.m, 0, byArray2, n2, this.g, this.e);
    }
}

