/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.Key;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public abstract class DHKey
implements Key,
ASN1Object,
Externalizable {
    protected DHParams params;

    public abstract void output(OutputStream var1) throws IOException;

    public abstract int length();

    public abstract void erase();

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public abstract String getFormat();

    public abstract void setParams(DHParams var1);

    public byte[] getEncoded() {
        return Utils.toBytes(this);
    }

    protected DHKey() {
    }

    public String getAlgorithm() {
        return "Diffie-Hellman";
    }

    public int getBitLength() {
        if (this.params == null || this.params.getP() == null) {
            return 0;
        }
        return this.params.getP().bitLength();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }

    protected DHKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    protected DHKey(DHParams dHParams) {
        this.params = dHParams;
    }

    public abstract void input(InputStream var1) throws IOException;

    public abstract Object clone();

    public DHParams getParams() {
        return this.params;
    }
}

