/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHParameterGenerator;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.DHPrivateKey;
import com.phaos.crypto.DHPublicKey;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.KeyPairGenerator;
import com.phaos.crypto.RandomBitsSource;
import java.math.BigInteger;

public class DHKeyPairGenerator
extends KeyPairGenerator {
    private DHParams a;
    private static final ASN1ObjectID b = AlgID.dh.getOID();
    static /* synthetic */ Class c;
    private boolean d = false;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public KeyPair generateKeyPair() {
        if (!this.d) {
            throw new IllegalStateException("The generator is not initialized.");
        }
        BigInteger bigInteger = this.a.getP();
        BigInteger bigInteger2 = this.a.getQ();
        BigInteger bigInteger3 = this.a.getG();
        BigInteger bigInteger4 = BigInteger.valueOf(1L);
        BigInteger bigInteger5 = null;
        while ((bigInteger5 = this.rbs.randomBigInteger(bigInteger2.bitLength())).compareTo(bigInteger4) <= 0 || bigInteger5.compareTo(bigInteger2) >= 0) {
        }
        BigInteger bigInteger6 = bigInteger3.modPow(bigInteger5, bigInteger);
        return new KeyPair(new DHPublicKey(bigInteger6, this.a), new DHPrivateKey(bigInteger5, this.a));
    }

    public void initialize(DHParams dHParams, RandomBitsSource randomBitsSource) {
        this.a = dHParams;
        this.setRandomBitsSource(randomBitsSource);
        this.d = true;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (!algorithmIdentifier.getOID().equals(b)) {
            throw new AlgorithmIdentifierException("Unknown DH key algorithm identifier");
        }
        ASN1Object aSN1Object = algorithmIdentifier.getParameters();
        if (aSN1Object != null && aSN1Object.getClass() != (c == null ? (c = DHKeyPairGenerator.class$("com.phaos.ASN1.ASN1Null")) : c)) {
            this.a = (DHParams)aSN1Object;
        }
    }

    public String getAlgorithm() {
        return "Diffie-Hellman";
    }

    public void initialize(int n, RandomBitsSource randomBitsSource) {
        this.initialize(n, 160, randomBitsSource);
    }

    public void initialize(int n, int n2, RandomBitsSource randomBitsSource) {
        DHParameterGenerator dHParameterGenerator = new DHParameterGenerator();
        dHParameterGenerator.initialize(n, n2, randomBitsSource);
        this.initialize(dHParameterGenerator.generateParameters(), randomBitsSource);
    }
}

