/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.Utils;
import java.math.BigInteger;

public class DHParameterGenerator {
    private RandomBitsSource c;
    private int d;
    private int e;
    boolean f = false;
    private static final BigInteger g;
    private static final BigInteger h;

    public void initialize(int n, int n2) {
        this.initialize(n, n2, RandomBitsSource.getDefault());
    }

    static BigInteger a(BigInteger bigInteger, byte[] byArray, int n, int n2, int n3, MessageDigest messageDigest) {
        int n4 = n3 / 160;
        int n5 = n2 / 160;
        if (n4 * 160 < n3) {
            ++n4;
        }
        if (n5 * 160 < n2) {
            ++n5;
        }
        BigInteger bigInteger2 = new BigInteger(byArray).add(BigInteger.valueOf(2 * n4)).add(BigInteger.valueOf(n5 * n));
        BigInteger bigInteger3 = h;
        int n6 = 0;
        while (n6 < n5) {
            messageDigest.init();
            messageDigest.update(bigInteger2.add(BigInteger.valueOf(n6)).toByteArray());
            messageDigest.computeCurrent();
            bigInteger3 = bigInteger3.add(new BigInteger(1, messageDigest.getDigestBits()).shiftLeft(160 * n6));
            ++n6;
        }
        if (!(bigInteger3 = bigInteger3.mod(g.shiftLeft(n2))).testBit(n2 - 1)) {
            bigInteger3 = bigInteger3.flipBit(n2 - 1);
        }
        bigInteger3 = bigInteger3.subtract(bigInteger3.mod(bigInteger.shiftLeft(1))).add(g);
        return bigInteger3;
    }

    public DHParams generateParameters() {
        BigInteger bigInteger;
        if (!this.f) {
            throw new IllegalStateException("The generator is not initialized.");
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
        }
        BigInteger bigInteger2 = null;
        byte[] byArray = new byte[this.e / 8 + 1];
        while (!(bigInteger2 = DHParameterGenerator.b(byArray = this.c.randomBytes(byArray), this.e, messageDigest)).isProbablePrime(100)) {
        }
        BigInteger bigInteger3 = null;
        int n = 0;
        int n2 = this.d / 1024;
        if (n2 * 1024 < this.d) {
            ++n2;
        }
        while (!((bigInteger3 = DHParameterGenerator.a(bigInteger2, byArray, n, this.d, this.e, messageDigest)).compareTo(g.shiftLeft(this.d - 1)) > 0 && bigInteger3.isProbablePrime(100) || ++n >= 4096 * n2)) {
        }
        if (n >= 4096 * n2) {
            throw new RuntimeException("Failed in generating primes");
        }
        BigInteger bigInteger4 = bigInteger3.subtract(g).divide(bigInteger2);
        BigInteger bigInteger5 = BigInteger.valueOf(2L);
        while (true) {
            if ((bigInteger = bigInteger5.modPow(bigInteger4, bigInteger3)).compareTo(g) > 0) break;
            bigInteger5 = bigInteger5.add(g);
        }
        bigInteger5 = bigInteger;
        return new DHParams(bigInteger3, bigInteger5, bigInteger2, bigInteger4, byArray, n);
    }

    static {
        h = BigInteger.valueOf(0L);
        g = BigInteger.valueOf(1L);
    }

    static BigInteger b(byte[] byArray, int n, MessageDigest messageDigest) {
        int n2 = n / 160;
        if (n2 * 160 < n) {
            ++n2;
        }
        BigInteger bigInteger = new BigInteger(byArray);
        BigInteger bigInteger2 = h;
        int n3 = 0;
        while (n3 < n2) {
            messageDigest.init();
            messageDigest.update(bigInteger.add(BigInteger.valueOf(n3)).toByteArray());
            messageDigest.computeCurrent();
            byte[] byArray2 = messageDigest.getDigestBits();
            messageDigest.init();
            messageDigest.update(bigInteger.add(BigInteger.valueOf(n3 + n2)).toByteArray());
            messageDigest.computeCurrent();
            byArray2 = Utils.xor(byArray2, messageDigest.getDigestBits());
            bigInteger2 = bigInteger2.add(new BigInteger(1, byArray2).shiftLeft(160 * n3));
            ++n3;
        }
        if (!(bigInteger2 = bigInteger2.mod(g.shiftLeft(n))).testBit(0)) {
            bigInteger2 = bigInteger2.flipBit(0);
        }
        if (!bigInteger2.testBit(n - 1)) {
            bigInteger2 = bigInteger2.flipBit(n - 1);
        }
        return bigInteger2;
    }

    public String getAlgorithm() {
        return "Diffie-Hellman";
    }

    public void initialize(int n, int n2, RandomBitsSource randomBitsSource) {
        if (n % 256 != 0 || n < 1024) {
            throw new IllegalArgumentException("L=" + n + " is not a mutiple of 256 of a factor not less than 4");
        }
        this.d = n;
        if (n2 < 160) {
            throw new IllegalArgumentException("m=" + n2 + " is smaller than 160");
        }
        this.e = n2;
        this.c = randomBitsSource;
        this.f = true;
    }
}

