/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.EntropySource;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RandomBitsSource;

public abstract class DigestRandomBitsSource
extends RandomBitsSource {
    private boolean a = false;
    private int b;
    private static final int c = 20;
    private long d;
    private byte[] e = new byte[0];
    private byte[] f;
    private MessageDigest g;

    public synchronized void seed(EntropySource entropySource) {
        byte[] byArray = new byte[20];
        entropySource.generateBytes(byArray);
        this.seed(byArray);
    }

    public synchronized void seed() {
        this.seed(EntropySource.getDefault());
    }

    protected DigestRandomBitsSource() {
    }

    public synchronized void clear() {
        if (this.f != null) {
            int n = 0;
            while (n < this.f.length) {
                this.f[n] = 0;
                ++n;
            }
        }
        if (this.g != null) {
            this.g.init();
        }
        this.e = null;
        this.b = 0;
        this.d = 0;
        this.a = false;
    }

    public synchronized byte[] randomBytes(byte[] byArray) {
        if (!this.a) {
            throw new IllegalStateException("PRNG has not been seeded");
        }
        int n = Math.min(this.e.length - this.b, byArray.length);
        System.arraycopy(this.e, this.b, byArray, 0, n);
        this.b += n;
        int n2 = byArray.length;
        while (n < n2) {
            this.g.init();
            this.g.update(this.f);
            this.g.update(this.d++);
            this.g.computeCurrent();
            this.e = this.g.digestBits;
            this.b = Math.min(this.e.length, byArray.length - n);
            System.arraycopy(this.g.digestBits, 0, byArray, n, this.b);
            n += this.e.length;
        }
        return byArray;
    }

    public synchronized byte randomByte() {
        if (!this.a) {
            throw new IllegalStateException("PRNG has not been seeded");
        }
        if (this.b == this.e.length) {
            this.g.init();
            this.g.update(this.f);
            this.g.update(this.d++);
            this.g.computeCurrent();
            this.e = this.g.digestBits;
            this.b = 0;
        }
        return this.e[this.b++];
    }

    public synchronized void seed(Object object) {
        this.g.init();
        this.g.update(this.f);
        this.g.update(object.hashCode());
        this.g.update(object.toString());
        this.g.computeCurrent();
        this.f = this.g.digestBits;
        this.b = 0;
        this.e = new byte[0];
        this.a = true;
    }

    protected synchronized void initialize(AlgorithmIdentifier algorithmIdentifier) {
        try {
            this.g = MessageDigest.getInstance(algorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException(algorithmIdentifierException.toString());
        }
        this.f = new byte[this.g.blockSize()];
        this.a = false;
    }

    public synchronized void seed(byte[] byArray) {
        this.g.init();
        this.g.update(this.f);
        this.g.update(byArray);
        this.g.computeCurrent();
        this.f = this.g.digestBits;
        this.b = 0;
        this.e = new byte[0];
        this.a = true;
    }
}

