/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.MessageDigest;
import com.phaos.utils.Utils;

public final class MD4
extends MessageDigest {
    private MD4State j = new MD4State();
    private MD4State k = new MD4State();

    public static void main(String[] stringArray) {
        try {
            System.out.println("MD4 Test Suite");
            MD4 mD4 = new MD4();
            System.out.println("MD4[] = 31d6cfe0d16ae931b73c59d7e0c089c0");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest(new byte[0])));
            System.out.println("MD4[a] = bde52cb31de33e46245e05fbdbd6fb24");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest("a".getBytes())));
            System.out.println("MD4[abc] = a448017aaf21d8525fc10ae87aa6729d");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest("abc".getBytes())));
            System.out.println("MD4[message digest] = d9130a8164549fe818874806e1c7014b");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest("message digest".getBytes())));
            System.out.println("MD4[abcdefghijklmnopqrstuvwxyz] = d79e1c308aa5bbcdeea8ed63df412da9");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest("abcdefghijklmnopqrstuvwxyz".getBytes())));
            System.out.println("MD4[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789] = 043f8582f241db351ce627e153e7f0e4");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".getBytes())));
            System.out.println("MD4[12345678901234567890123456789012345678901234567890123456789012345678901234567890] = e33b4ddc9c38f2199c3e7b164fcc0536");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest("12345678901234567890123456789012345678901234567890123456789012345678901234567890".getBytes())));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void a() {
        int n = this.j.d[0];
        int n2 = this.j.d[1];
        int n3 = this.j.d[2];
        int n4 = this.j.d[3];
        int[] nArray = this.j.b;
        n = MD4.b(n, n2, n3, n4, nArray, 0, 3);
        n4 = MD4.b(n4, n, n2, n3, nArray, 1, 7);
        n3 = MD4.b(n3, n4, n, n2, nArray, 2, 11);
        n2 = MD4.b(n2, n3, n4, n, nArray, 3, 19);
        n = MD4.b(n, n2, n3, n4, nArray, 4, 3);
        n4 = MD4.b(n4, n, n2, n3, nArray, 5, 7);
        n3 = MD4.b(n3, n4, n, n2, nArray, 6, 11);
        n2 = MD4.b(n2, n3, n4, n, nArray, 7, 19);
        n = MD4.b(n, n2, n3, n4, nArray, 8, 3);
        n4 = MD4.b(n4, n, n2, n3, nArray, 9, 7);
        n3 = MD4.b(n3, n4, n, n2, nArray, 10, 11);
        n2 = MD4.b(n2, n3, n4, n, nArray, 11, 19);
        n = MD4.b(n, n2, n3, n4, nArray, 12, 3);
        n4 = MD4.b(n4, n, n2, n3, nArray, 13, 7);
        n3 = MD4.b(n3, n4, n, n2, nArray, 14, 11);
        n2 = MD4.b(n2, n3, n4, n, nArray, 15, 19);
        n = MD4.h(n, n2, n3, n4, nArray, 0, 3);
        n4 = MD4.h(n4, n, n2, n3, nArray, 4, 5);
        n3 = MD4.h(n3, n4, n, n2, nArray, 8, 9);
        n2 = MD4.h(n2, n3, n4, n, nArray, 12, 13);
        n = MD4.h(n, n2, n3, n4, nArray, 1, 3);
        n4 = MD4.h(n4, n, n2, n3, nArray, 5, 5);
        n3 = MD4.h(n3, n4, n, n2, nArray, 9, 9);
        n2 = MD4.h(n2, n3, n4, n, nArray, 13, 13);
        n = MD4.h(n, n2, n3, n4, nArray, 2, 3);
        n4 = MD4.h(n4, n, n2, n3, nArray, 6, 5);
        n3 = MD4.h(n3, n4, n, n2, nArray, 10, 9);
        n2 = MD4.h(n2, n3, n4, n, nArray, 14, 13);
        n = MD4.h(n, n2, n3, n4, nArray, 3, 3);
        n4 = MD4.h(n4, n, n2, n3, nArray, 7, 5);
        n3 = MD4.h(n3, n4, n, n2, nArray, 11, 9);
        n2 = MD4.h(n2, n3, n4, n, nArray, 15, 13);
        n = MD4.d(n, n2, n3, n4, nArray, 0, 3);
        n4 = MD4.d(n4, n, n2, n3, nArray, 8, 9);
        n3 = MD4.d(n3, n4, n, n2, nArray, 4, 11);
        n2 = MD4.d(n2, n3, n4, n, nArray, 12, 15);
        n = MD4.d(n, n2, n3, n4, nArray, 2, 3);
        n4 = MD4.d(n4, n, n2, n3, nArray, 10, 9);
        n3 = MD4.d(n3, n4, n, n2, nArray, 6, 11);
        n2 = MD4.d(n2, n3, n4, n, nArray, 14, 15);
        n = MD4.d(n, n2, n3, n4, nArray, 1, 3);
        n4 = MD4.d(n4, n, n2, n3, nArray, 9, 9);
        n3 = MD4.d(n3, n4, n, n2, nArray, 5, 11);
        n2 = MD4.d(n2, n3, n4, n, nArray, 13, 15);
        n = MD4.d(n, n2, n3, n4, nArray, 3, 3);
        n4 = MD4.d(n4, n, n2, n3, nArray, 11, 9);
        n3 = MD4.d(n3, n4, n, n2, nArray, 7, 11);
        n2 = MD4.d(n2, n3, n4, n, nArray, 15, 15);
        this.j.d[0] = this.j.d[0] + n;
        this.j.d[1] = this.j.d[1] + n2;
        this.j.d[2] = this.j.d[2] + n3;
        this.j.d[3] = this.j.d[3] + n4;
    }

    public String algName() {
        return "MD4";
    }

    private static int b(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        return MD4.i(n + (n2 & n3 | ~n2 & n4) + nArray[n5], n6);
    }

    public MD4() {
        this.digestBits = new byte[16];
        this.digestValid = false;
    }

    private void c(int[] nArray, byte[] byArray) {
        int n = nArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3++] = (byte)nArray[n2];
            byArray[n3++] = (byte)(nArray[n2] >> 8);
            byArray[n3++] = (byte)(nArray[n2] >> 16);
            byArray[n3++] = (byte)(nArray[n2] >> 24);
            ++n2;
        }
    }

    protected void setState(MessageDigest.MDState mDState) {
        mDState.copyTo(this.j);
        this.digestValid = false;
    }

    public int getDigestLength() {
        return 16;
    }

    public void update(byte by) {
        byte[] byArray = this.j.a;
        int[] nArray = this.j.b;
        if (this.j.f == 64) {
            this.g(byArray, nArray);
            this.a();
            this.j.f = 0;
        }
        byArray[this.j.f++] = by;
        this.j.c += 8L;
        this.digestValid = false;
    }

    private static int d(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        return MD4.i(n + (n2 ^ n3 ^ n4) + nArray[n5] + 1859775393, n6);
    }

    public void computeCurrent() {
        this.j.copyTo(this.k);
        byte[] byArray = this.j.a;
        int[] nArray = this.j.b;
        this.e();
        this.update((byte)this.k.c);
        this.update((byte)(this.k.c >> 8));
        this.update((byte)(this.k.c >> 16));
        this.update((byte)(this.k.c >> 24));
        this.update((byte)(this.k.c >> 32));
        this.update((byte)(this.k.c >> 40));
        this.update((byte)(this.k.c >> 48));
        this.update((byte)(this.k.c >> 56));
        this.g(byArray, nArray);
        this.a();
        this.c(this.j.d, this.digestBits);
        this.digestValid = true;
        MD4State mD4State = this.j;
        this.j = this.k;
        this.k = mD4State;
    }

    protected MessageDigest.MDState getState() {
        return this.j;
    }

    private void e() {
        this.update((byte)-128);
        if (this.j.f > 56) {
            this.update(new byte[64 - this.j.f + 56]);
        } else if (this.j.f < 56) {
            this.update(new byte[56 - this.j.f]);
        }
    }

    private int f(byte by, byte by2, byte by3, byte by4) {
        return by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 24;
    }

    private void g(byte[] byArray, int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            nArray[n2] = byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 24;
            ++n2;
        }
    }

    public AlgorithmIdentifier getAlgID() {
        return new AlgorithmIdentifier(new ASN1ObjectID(new int[]{1, 2, 840, 113549, 2, 4}));
    }

    private static int h(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        return MD4.i(n + (n2 & n3 | n2 & n4 | n3 & n4) + nArray[n5] + 1518500249, n6);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digestValid = false;
        byte[] byArray2 = this.j.a;
        int[] nArray = this.j.b;
        this.j.c += (long)(n2 << 3);
        while (n2 > 0) {
            int n3 = 64 - this.j.f;
            if (n2 < n3) {
                System.arraycopy(byArray, n, byArray2, this.j.f, n2);
                this.j.f += n2;
                n2 = 0;
                continue;
            }
            System.arraycopy(byArray, n, byArray2, this.j.f, n3);
            n2 -= n3;
            n += n3;
            this.g(byArray2, nArray);
            this.a();
            this.j.f = 0;
        }
    }

    public int blockSize() {
        return 64;
    }

    private static int i(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    public Object clone() {
        MD4 mD4 = new MD4();
        this.j.copyTo(mD4.j);
        System.arraycopy(this.digestBits, 0, mD4.digestBits, 0, this.digestBits.length);
        mD4.digestValid = this.digestValid;
        return mD4;
    }

    public void init() {
        if (this.j != null) {
            this.j.init();
        }
        this.digestValid = false;
    }

    final class MD4State
    extends MessageDigest.MDState {
        byte[] a = new byte[64];
        int[] b = new int[16];
        long c;
        int[] d = new int[4];
        int f;

        public void copyTo(MessageDigest.MDState mDState) {
            if (this.getClass() != mDState.getClass()) {
                throw new IllegalArgumentException("MD4State required");
            }
            MD4State mD4State = (MD4State)mDState;
            mD4State.c = this.c;
            mD4State.f = this.f;
            System.arraycopy(this.a, 0, mD4State.a, 0, 64);
            System.arraycopy(this.d, 0, mD4State.d, 0, 4);
        }

        public void init() {
            this.d[0] = 1732584193;
            this.d[1] = -271733879;
            this.d[2] = -1732584194;
            this.d[3] = 271733878;
            this.f = 0;
            this.c = 0;
        }

        MD4State() {
            this.init();
        }

        public Object clone() {
            MD4State mD4State = new MD4State();
            this.copyTo(mD4State);
            return mD4State;
        }
    }
}

