/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.PKCS5;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.OIDManager;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class PrivateKeyPKCS8
implements ASN1Object,
PrivateKey,
Externalizable {
    private PrivateKey c;
    private PKCS5 d;
    private ASN1Sequence e;
    private RandomBitsSource f;
    private byte[] g;

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public void setKey(PrivateKey privateKey) {
        this.c = privateKey;
        this.g = null;
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.d.inputAlgID(aSN1SequenceInputStream);
        this.g = ASN1OctetString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        this.c = null;
        this.e = null;
        if (this.d.getPassword() != null) {
            try {
                this.getKey();
            }
            catch (IllegalStateException illegalStateException) {
                throw new InvalidInputException(illegalStateException.toString());
            }
        }
    }

    public String toString() {
        return "pkcs5 = {" + this.d + "}, key = {" + this.c + "}";
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, RandomBitsSource randomBitsSource) {
        this(privateKey, 3, randomBitsSource);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    public byte[] getEncoded() {
        return Utils.toBytes(this.a());
    }

    public String getAlgorithm() {
        try {
            return this.getKey().getAlgorithm();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string, int n, RandomBitsSource randomBitsSource) {
        this(privateKey, n, randomBitsSource);
        this.setPassword(string);
    }

    public PrivateKeyPKCS8(String string, PrivateKey privateKey, RandomBitsSource randomBitsSource) {
        this(privateKey, string, 3, randomBitsSource);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey) {
        this(privateKey, RandomBitsSource.getDefault());
    }

    public PrivateKeyPKCS8(String string, File file) throws IOException, FileNotFoundException {
        this(string, new FileInputStream(file));
    }

    private ASN1Sequence a() throws StreamableOutputException {
        if (this.e == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.d.outputAlgIDASN1());
            try {
                aSN1Sequence.addElement(new ASN1OctetString(this.b()));
            }
            catch (CipherException cipherException) {
                throw new StreamableOutputException(cipherException.toString());
            }
            this.e = aSN1Sequence;
        }
        return this.e;
    }

    public PrivateKeyPKCS8(String string, InputStream inputStream) throws IOException {
        this.d = new PKCS5();
        this.d.setPassword(string);
        this.input(inputStream);
    }

    public PrivateKeyPKCS8(int n, RandomBitsSource randomBitsSource) {
        this.d = new PKCS5(n, randomBitsSource);
        this.f = randomBitsSource;
    }

    public PrivateKeyPKCS8(ASN1Sequence aSN1Sequence) throws IOException {
        this(Utils.toStream(aSN1Sequence));
    }

    public void erase() {
        if (this.c != null) {
            this.c.erase();
            this.c = null;
        }
        this.d = null;
        this.g = null;
        this.e = null;
        this.f = null;
    }

    public String getFormat() {
        try {
            return this.getKey().getFormat();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public int length() {
        return this.a().length();
    }

    public AlgorithmIdentifier getAlgID() {
        try {
            return this.getKey().getAlgID();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        try {
            this.a().output(outputStream);
        }
        catch (StreamableOutputException streamableOutputException) {
            throw new IOException(streamableOutputException.toString());
        }
    }

    public int getMode() {
        return this.d.getMode();
    }

    public void setMode(int n) {
        this.d.setMode(n);
        if (this.c != null) {
            this.g = null;
        }
        this.e = null;
    }

    public void setPassword(String string) {
        this.d.setPassword(string);
        if (this.c != null) {
            this.g = null;
        }
        this.e = null;
    }

    public PrivateKeyPKCS8(int n) {
        this(n, RandomBitsSource.getDefault());
    }

    public PrivateKeyPKCS8(String string, PrivateKey privateKey) {
        this(string, privateKey, RandomBitsSource.getDefault());
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string, int n) {
        this(privateKey, string, n, RandomBitsSource.getDefault());
    }

    public int getBitLength() {
        try {
            return this.getKey().getBitLength();
        }
        catch (RuntimeException runtimeException) {
            return 0;
        }
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public void setCount(int n) {
        this.d.setCount(n);
        if (this.c != null) {
            this.g = null;
        }
        this.e = null;
    }

    public PrivateKey getKey() {
        if (this.c == null) {
            PrivateKeyPKCS8 privateKeyPKCS8 = this;
            synchronized (privateKeyPKCS8) {
                if (this.c == null) {
                    try {
                        if (this.g == null) {
                            throw new IllegalStateException("Encrypted private key not found");
                        }
                        byte[] byArray = this.d.decrypt(this.g);
                        this.c = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray));
                    }
                    catch (CipherException cipherException) {
                        throw new IllegalStateException(cipherException.toString());
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException(iOException.toString());
                    }
                }
            }
        }
        return this.c;
    }

    public PrivateKeyPKCS8(String string, ASN1Sequence aSN1Sequence) throws IOException {
        this(string, Utils.toStream(aSN1Sequence));
    }

    private byte[] b() throws CipherException {
        if (this.g == null) {
            PrivateKeyPKCS8 privateKeyPKCS8 = this;
            synchronized (privateKeyPKCS8) {
                if (this.g == null) {
                    if (this.c == null) {
                        throw new IllegalStateException("Private key not found for encryption");
                    }
                    this.g = this.d.encrypt(Utils.toBytes(CryptoUtils.privateKeyInfo(this.c)));
                }
            }
        }
        return this.g;
    }

    public ASN1Object getContents() {
        return this.a();
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, int n, RandomBitsSource randomBitsSource) {
        this(n, randomBitsSource);
        this.c = privateKey;
    }

    public PrivateKeyPKCS8() {
        this.d = new PKCS5();
    }

    public Object clone() {
        PrivateKeyPKCS8 privateKeyPKCS8 = new PrivateKeyPKCS8();
        if (this.c != null) {
            privateKeyPKCS8.c = (PrivateKey)this.c.clone();
        }
        if (this.g != null) {
            privateKeyPKCS8.g = (byte[])this.g.clone();
        }
        if (this.d != null) {
            privateKeyPKCS8.d = new PKCS5(this.d.getMode(), this.f);
            privateKeyPKCS8.d.setCount(this.d.getCount());
            if (this.d.getSalt() != null) {
                privateKeyPKCS8.d.setSalt((byte[])this.d.getSalt().clone());
            }
            privateKeyPKCS8.d.setPassword(this.d.getPassword());
        } else {
            privateKeyPKCS8.d = null;
        }
        privateKeyPKCS8.f = this.f;
        return privateKeyPKCS8;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws InvalidInputException, AlgorithmIdentifierException {
        if (this.c == null) {
            OIDManager oIDManager = OIDManager.getOIDManager();
            Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "privateKey");
            if (clazz == null) {
                throw new AlgorithmIdentifierException("Unrecognized algorithm OID " + algorithmIdentifier.getOID());
            }
            try {
                PrivateKey privateKey = (PrivateKey)clazz.newInstance();
                privateKey.initialize(algorithmIdentifier, aSN1Object);
                this.c = privateKey;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ": " + illegalAccessException.toString());
            }
            catch (InstantiationException instantiationException) {
                throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ": " + instantiationException.toString());
            }
            catch (ClassCastException classCastException) {
                throw new AlgorithmIdentifierException("Class does not implement PrivateKey.");
            }
        } else {
            this.c.initialize(algorithmIdentifier, aSN1Object);
        }
        this.g = null;
        this.e = null;
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, int n) {
        this(privateKey, n, RandomBitsSource.getDefault());
    }

    public void setSalt(byte[] byArray) {
        this.d.setSalt(byArray);
        if (this.c != null) {
            this.g = null;
        }
        this.e = null;
    }

    public PrivateKeyPKCS8(InputStream inputStream) throws IOException {
        this.d = new PKCS5();
        this.input(inputStream);
    }
}

