/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.Key;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public abstract class RSAKey
implements Key,
ASN1Object {
    BigInteger a;
    BigInteger b;

    public abstract void output(OutputStream var1) throws IOException;

    protected RSAKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.setModulusExponent(bigInteger, bigInteger2);
    }

    public abstract int length();

    public int getBitLength() {
        if (this.b == null) {
            return 0;
        }
        return this.b.bitLength();
    }

    public abstract String getFormat();

    public abstract Object clone();

    public void erase() {
        this.a = null;
        this.b = null;
    }

    public BigInteger getModulus() {
        return this.b;
    }

    public byte[] getEncoded() {
        return Utils.toBytes(this);
    }

    public void setModulusExponent(BigInteger bigInteger, BigInteger bigInteger2) {
        this.b = bigInteger;
        this.a = bigInteger2;
    }

    public int modulusLength() {
        return Utils.length(this.b);
    }

    protected RSAKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    protected RSAKey() {
    }

    public BigInteger getExponent() {
        return this.a;
    }

    public abstract void input(InputStream var1) throws IOException;

    public abstract boolean isPublic();

    public void setBytes(byte[] byArray) throws IOException {
        if (byArray.length != 0) {
            this.input(new UnsyncByteArrayInputStream(byArray));
        }
    }

    protected RSAKey(ASN1Sequence aSN1Sequence) throws IOException {
        this(Utils.toBytes(aSN1Sequence));
    }

    public String getAlgorithm() {
        return "RSA";
    }

    protected RSAKey(byte[] byArray) throws IOException {
        this.setBytes(byArray);
    }
}

