/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.DigestInfo;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;

public final class RSAMDSignature
extends Signature {
    public static final ASN1ObjectID rsaKeyOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 1);
    public static final ASN1ObjectID rsaMD5SigOID;
    private RSAPrivateKey a;
    public static final ASN1ObjectID rsaSHASigOldOID;
    public static final ASN1ObjectID rsaMD2SigOID;
    private AlgorithmIdentifier b;
    private static AlgorithmIdentifier c;
    public static final ASN1ObjectID rsaSHASigOID;
    private byte[] d = null;
    private RandomBitsSource e;
    private RSAPublicKey f;

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.equals(AlgID.md2WithRSAEncryption)) {
            this.b = AlgID.md2;
        } else if (algorithmIdentifier.equals(AlgID.md5WithRSAEncryption)) {
            this.b = AlgID.md5;
        } else if (algorithmIdentifier.equals(AlgID.sha_1WithRSAEncryption)) {
            this.b = AlgID.sha_1;
        } else {
            throw new AlgorithmIdentifierException("Invalid AlgorithmIdentifier for RSAMDSignature");
        }
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey, byte[] byArray) throws SignatureException {
        this(rSAPrivateKey, c, byArray);
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, ASN1ObjectID aSN1ObjectID) {
        this(rSAPublicKey, new AlgorithmIdentifier(aSN1ObjectID));
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.a = rSAPrivateKey;
        this.setMessageDigestAlgID(algorithmIdentifier);
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, AlgorithmIdentifier algorithmIdentifier) {
        this.f = rSAPublicKey;
        this.setMessageDigestAlgID(algorithmIdentifier);
    }

    public AlgorithmIdentifier getDigestEncryptionAlgID() {
        return AlgID.rsaEncryption;
    }

    public boolean verify() throws AuthenticationException {
        try {
            Object object;
            Object object2;
            Cipher cipher = Cipher.getInstance(AlgID.rsaEncryption, this.f);
            byte[] byArray = null;
            byte[] byArray2 = null;
            if (this.d != null) {
                byArray = this.d;
                byArray2 = cipher.decrypt(this.getSigBytes());
            } else {
                MessageDigest messageDigest = MessageDigest.getInstance(this.b);
                messageDigest.update(this.getDocument());
                messageDigest.computeCurrent();
                byArray = messageDigest.digestBits;
                object2 = cipher.decrypt(this.getSigBytes());
                object = new UnsyncByteArrayInputStream((byte[])object2);
                DigestInfo digestInfo = new DigestInfo((InputStream)object);
                if (!digestInfo.getDigestAlgID().equals(this.b)) {
                    throw new AuthenticationException("Signature has unexpected MD type");
                }
                byArray2 = digestInfo.getDigest();
            }
            cipher.erase();
            boolean bl = Utils.areEqual(byArray, byArray2);
            if (bl || this.d == null) {
                return bl;
            }
            try {
                object2 = new DigestInfo(new UnsyncByteArrayInputStream(this.d));
                object = new DigestInfo(new UnsyncByteArrayInputStream(byArray2));
                if (!((DigestInfo)object2).getDigestAlgID().equals(((DigestInfo)object).getDigestAlgID())) {
                    return false;
                }
                return Utils.areEqual(((DigestInfo)object2).getDigest(), ((DigestInfo)object).getDigest());
            }
            catch (IOException iOException) {
                return false;
            }
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new AuthenticationException(algorithmIdentifierException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AuthenticationException(classCastException.toString());
        }
        catch (CipherException cipherException) {
            throw new AuthenticationException(cipherException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
        catch (IOException iOException) {
            throw new AuthenticationException(iOException.toString());
        }
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey) {
        this(rSAPublicKey, c);
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws SignatureException {
        this(rSAPrivateKey, algorithmIdentifier);
        this.setDocument(byArray);
        this.sign();
    }

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        this.e = randomBitsSource;
    }

    public void setPrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.a = (RSAPrivateKey)privateKey;
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, RSAPrivateKey rSAPrivateKey) {
        this.f = rSAPublicKey;
        this.a = rSAPrivateKey;
        this.setMessageDigestAlgID(c);
    }

    public void setHash(byte[] byArray) {
        this.d = byArray;
        this.document = null;
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.f = (RSAPublicKey)publicKey;
    }

    public AlgorithmIdentifier getAlgID() {
        if (this.b.equals(AlgID.md2)) {
            return AlgID.md2WithRSAEncryption;
        }
        if (this.b.equals(AlgID.md5)) {
            return AlgID.md5WithRSAEncryption;
        }
        if (this.b.equals(AlgID.sha_1)) {
            return AlgID.sha_1WithRSAEncryption;
        }
        throw new IllegalStateException("No appropriate algorithm identifier.");
    }

    public String algName() {
        if (this.b.equals(AlgID.md2)) {
            return "RSA/MD2";
        }
        if (this.b.equals(AlgID.md5)) {
            return "RSA/MD5";
        }
        if (this.b.equals(AlgID.sha_1)) {
            return "RSA/SHA";
        }
        throw new IllegalStateException("No appropriate algorithm identifier.");
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, byte[] byArray, byte[] byArray2) {
        this(rSAPublicKey);
        this.setSigBytes(byArray);
        this.setDocument(byArray2);
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey) {
        this(rSAPrivateKey, c);
    }

    static {
        rsaMD2SigOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 2);
        rsaMD5SigOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 4);
        rsaSHASigOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 5);
        rsaSHASigOldOID = new ASN1ObjectID(ASN1Utils.oiwAlgID, 29);
        c = AlgID.md5;
    }

    public void setMessageDigestAlgID(AlgorithmIdentifier algorithmIdentifier) {
        this.b = algorithmIdentifier;
    }

    public RSAMDSignature() {
        this.b = c;
    }

    public byte[] sign() throws SignatureException {
        try {
            Object object;
            byte[] byArray = null;
            if (this.d != null) {
                byArray = this.d;
            } else {
                object = MessageDigest.getInstance(this.b);
                ((MessageDigest)object).computeDigest(this.getDocument());
                byArray = Utils.toBytes(new DigestInfo(((MessageDigest)object).getAlgID(), ((MessageDigest)object).digestBits));
            }
            object = Cipher.getInstance(AlgID.rsaEncryption, this.a);
            ((Cipher)object).setRandomBitsSource(this.e);
            this.setSigBytes(((Cipher)object).encrypt(byArray));
            ((Cipher)object).erase();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new SignatureException(algorithmIdentifierException.toString());
        }
        catch (CipherException cipherException) {
            throw new SignatureException(cipherException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.toString());
        }
        return this.getSigBytes();
    }

    public AlgorithmIdentifier getMessageDigestAlgID() {
        return this.b;
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, RSAPrivateKey rSAPrivateKey, byte[] byArray) throws SignatureException {
        this.f = rSAPublicKey;
        this.a = rSAPrivateKey;
        this.setMessageDigestAlgID(c);
        this.setDocument(byArray);
        this.sign();
    }

    public ASN1ObjectID algorithmOID() {
        return this.getAlgID().getOID();
    }
}

