/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RSAKey;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;

public class RSAPublicKey
extends RSAKey
implements PublicKey,
Externalizable {
    private ASN1Sequence keyContents = null;
    private ASN1Sequence spki = null;
    private AlgorithmIdentifier algID = null;

    public boolean isPublic() {
        return true;
    }

    public String toString() {
        return "{ modulus = " + this.b + ", exponent = " + this.a + " }";
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.spki == null) {
            this.spki = CryptoUtils.subjectPublicKeyInfo(this);
        }
        return this.spki;
    }

    public RSAPublicKey() {
    }

    private void initialize(ASN1Object aSN1Object) throws InvalidInputException {
        ASN1Sequence aSN1Sequence;
        try {
            aSN1Sequence = (ASN1Sequence)aSN1Object;
            this.b = ((ASN1Integer)aSN1Sequence.elementAt(0)).getValue();
            this.a = ((ASN1Integer)aSN1Sequence.elementAt(1)).getValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidInputException(arrayIndexOutOfBoundsException.toString());
        }
        this.keyContents = aSN1Sequence;
        this.algID = null;
        this.clearOutputCache();
    }

    public String getFormat() {
        return "X.509";
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public RSAPublicKey(byte[] byArray) throws IOException {
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public void erase() {
        super.erase();
        this.keyContents = null;
    }

    public RSAPublicKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    public AlgorithmIdentifier getAlgID() {
        if (this.algID == null) {
            this.algID = AlgID.rsaEncryption;
        }
        return this.algID;
    }

    public void finalize() {
        this.erase();
    }

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger, bigInteger2);
    }

    private void clearOutputCache() {
        this.spki = null;
    }

    public Object clone() {
        RSAPublicKey rSAPublicKey = new RSAPublicKey();
        try {
            if (this.algID != null) {
                rSAPublicKey.algID = new AlgorithmIdentifier(Utils.toStream(this.algID));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        try {
            if (this.keyContents != null) {
                rSAPublicKey.keyContents = new ASN1Sequence(Utils.toStream(this.keyContents));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key contents to stream");
        }
        try {
            if (this.spki != null) {
                rSAPublicKey.spki = new ASN1Sequence(Utils.toStream(this.spki));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing SPKI to stream");
        }
        if (this.b != null) {
            rSAPublicKey.b = new BigInteger(this.b.toByteArray());
        }
        if (this.a != null) {
            rSAPublicKey.a = new BigInteger(this.a.toByteArray());
        }
        return rSAPublicKey;
    }

    public ASN1Object getContents() {
        if (this.keyContents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(this.b));
            aSN1Sequence.addElement(new ASN1Integer(this.a));
            this.keyContents = aSN1Sequence;
        }
        return this.keyContents;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
        if (aSN1Object2 != null && !(aSN1Object2 instanceof ASN1Null)) {
            throw new AlgorithmIdentifierException();
        }
        this.initialize(aSN1Object);
        this.algID = algorithmIdentifier;
    }

    public void input(InputStream inputStream) throws IOException {
        try {
            ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
            if (aSN1Sequence.size() != 2) {
                throw new ASN1FormatException("Sequence has wrong number of components.");
            }
            if (aSN1Sequence.elementAt(0) instanceof ASN1Integer) {
                this.initialize(aSN1Sequence);
            } else {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(0));
                ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1BitString)aSN1Sequence.elementAt(1)).getValue());
                this.initialize(algorithmIdentifier, aSN1Object);
            }
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidInputException(algorithmIdentifierException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
    }

    public int length() {
        return this.toASN1Sequence().length();
    }
}

