/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.C0;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.MaskException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.OAEPAlgorithmIdentifier;
import com.phaos.crypto.RSA;
import com.phaos.crypto.RSAKey;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Utils;
import java.math.BigInteger;

public final class RSApkcs1
extends Cipher {
    private MessageDigest f;
    private byte[] g;
    private static final int h = 0;
    private static final int i = 1;
    private int j;
    private C0 k;

    public AlgorithmIdentifier getAlgID() {
        AlgorithmIdentifier algorithmIdentifier = null;
        algorithmIdentifier = this.j == 0 ? new OAEPAlgorithmIdentifier(this.f.getAlgID(), this.k.d(), new AlgorithmIdentifier(OAEPAlgorithmIdentifier.h, new ASN1OctetString(this.g))) : AlgID.rsaEncryption;
        return algorithmIdentifier;
    }

    public int getBlockSize() {
        return 0;
    }

    private byte[] a(byte[] byArray, int n) throws CipherException {
        if (this.f == null) {
            throw new CipherException("The OAEP encoding method requires a MessageDigest instance. The MessageDigest of this instance has not been configured");
        }
        if (this.k == null) {
            throw new CipherException("The OAEP encoding method requires a MaskGenerator instance. The MaskGenerator of this instance has not been configured");
        }
        int n2 = byArray.length;
        int n3 = this.f.getDigestLength();
        if (n2 > n - 2 * n3 - 1) {
            throw new CipherException("Message too long");
        }
        this.f.init();
        if (this.g != null) {
            this.f.update(this.g);
        }
        this.f.computeCurrent();
        byte[] byArray2 = new byte[n - n3];
        System.arraycopy(this.f.getDigestBits(), 0, byArray2, 0, n3);
        byArray2[byArray2.length - n2 - 1] = 1;
        System.arraycopy(byArray, 0, byArray2, byArray2.length - n2, n2);
        byte[] byArray3 = new byte[n3];
        this.b().randomBytes(byArray3);
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        try {
            byArray4 = Utils.xor(byArray2, this.k.e(byArray3, byArray2.length));
            byArray5 = Utils.xor(byArray3, this.k.e(byArray4, n3));
        }
        catch (MaskException maskException) {
            throw new CipherException(maskException.getMessage());
        }
        byte[] byArray6 = new byte[n];
        System.arraycopy(byArray5, 0, byArray6, 0, n3);
        System.arraycopy(byArray4, 0, byArray6, n3, byArray4.length);
        return byArray6;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (!(key instanceof RSAPublicKey) && !(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Key must be an instance of RSAPublicKey or RSAPrivateKey");
        }
        this.d(algorithmIdentifier);
        super.erase();
        this.decryptionKey = this.key = (Key)key.clone();
        this.encryptionKey = this.key;
        this.releaseOp();
        this.rbs = randomBitsSource;
    }

    public byte[] decrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        this.assertDecryption();
        RSAKey rSAKey = (RSAKey)this.getDecryptionKey();
        BigInteger bigInteger = rSAKey.getModulus();
        int n3 = Utils.length(bigInteger);
        byte[] byArray2 = null;
        if (n == 0 && n2 == byArray.length) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        if (byArray2.length != n3) {
            throw new CipherException("Decryption error");
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        if (bigInteger2.compareTo(bigInteger) >= 0) {
            throw new CipherException("Decryption error");
        }
        RSA rSA = new RSA();
        rSA.setKey(rSAKey);
        BigInteger bigInteger3 = rSA.performOp(bigInteger2);
        if (bigInteger3.compareTo(BigInteger.valueOf(256L).pow(n3 - 1)) >= 0) {
            throw new CipherException("Decryption error");
        }
        byte[] byArray3 = Utils.toByteArray(bigInteger3);
        byte[] byArray4 = new byte[n3 - 1];
        System.arraycopy(byArray3, 0, byArray4, byArray4.length - byArray3.length, byArray3.length);
        try {
            switch (this.j) {
                case 0: {
                    return this.c(byArray4);
                }
                case 1: {
                    return this.e(byArray4);
                }
            }
            throw new CipherException("Unknown encoding method");
        }
        catch (CipherException cipherException) {
            throw new CipherException("Decryption error");
        }
    }

    public void setKey(SymmetricKey symmetricKey) throws InvalidKeyException {
        throw new InvalidKeyException("Key must be an instance of an RSAKey to beused with the RSApkcs1 Cipher");
    }

    public void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        this.assertDecryption();
        byte[] byArray3 = this.decrypt(byArray, n, n2);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
    }

    public void erase() {
        super.erase();
        this.j = 1;
        if (this.g != null) {
            Utils.setArray(this.g, (byte)0);
        }
        if (this.f != null) {
            this.f.init();
            this.f = null;
        }
        if (this.k != null) {
            this.k.a();
            this.k = null;
        }
    }

    public void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        this.assertEncryption();
        byte[] byArray3 = this.encrypt(byArray, n, n2);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
    }

    public RSApkcs1(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.d(algorithmIdentifier);
    }

    private byte[] b(byte[] byArray, int n) throws CipherException {
        int n2 = byArray.length;
        int n3 = n - n2;
        if (n3 < 10) {
            throw new CipherException("Message too long");
        }
        byte[] byArray2 = new byte[n];
        if (((RSAKey)this.getEncryptionKey()).isPublic()) {
            RandomBitsSource randomBitsSource = this.b();
            byArray2[0] = 2;
            int n4 = 1;
            while (n4 < n3 - 1) {
                byte by = randomBitsSource.randomByte();
                while (by == 0) {
                    by = randomBitsSource.randomByte();
                }
                byArray2[n4] = by;
                ++n4;
            }
        } else {
            byArray2[0] = 1;
            int n5 = 1;
            while (n5 < n3 - 1) {
                byArray2[n5] = -1;
                ++n5;
            }
        }
        byArray2[n3 - 1] = 0;
        System.arraycopy(byArray, 0, byArray2, n3, n2);
        return byArray2;
    }

    public String algName() {
        switch (this.j) {
            case 0: {
                return "RSAES-OAEP";
            }
            case 1: {
                return "RSAES-PKCS1-v1_5";
            }
        }
        return "Unknown encoding method: " + this.j;
    }

    public void decryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        throw new CipherException("decryptOp illegally used with PKCS1");
    }

    public RSApkcs1() {
        this.j = 1;
    }

    private byte[] c(byte[] byArray) throws CipherException {
        int n = byArray.length;
        if (this.f == null) {
            throw new CipherException("The OAEP encoding method requires a MessageDigest instance. The MessageDigest of this instance has been explicitly set to null");
        }
        if (this.k == null) {
            throw new CipherException("The OAEP encoding method requires a MaskGenerator instance. The MaskGenerator of this instance has been explicitly set to null");
        }
        int n2 = this.f.getDigestLength();
        if (n < 2 * n2 + 1) {
            throw new CipherException("Decoding error");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        int n3 = n - n2;
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n2, byArray3, 0, n3);
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        try {
            byArray4 = Utils.xor(byArray2, this.k.e(byArray3, n2));
            byArray5 = Utils.xor(byArray3, this.k.e(byArray4, n3));
        }
        catch (MaskException maskException) {
            maskException.printStackTrace();
            throw new CipherException(maskException.getMessage());
        }
        byte[] byArray6 = new byte[n2];
        System.arraycopy(byArray5, 0, byArray6, 0, n2);
        this.f.init();
        if (this.g != null) {
            this.f.update(this.g);
        }
        this.f.computeCurrent();
        if (!Utils.areEqual(byArray6, this.f.getDigestBits())) {
            throw new CipherException("Decoding error");
        }
        int n4 = n2;
        while (n4 < n3 && byArray5[n4] == 0) {
            ++n4;
        }
        if (n4 == n3 || byArray5[n4] != 1) {
            throw new CipherException("Decoding error");
        }
        byte[] byArray7 = new byte[n3 - n4 - 1];
        System.arraycopy(byArray5, n4 + 1, byArray7, 0, byArray7.length);
        return byArray7;
    }

    public void setDecryptionKey(Key key) throws InvalidKeyException {
        if (!(key instanceof RSAPublicKey) && !(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Key must be an instance of RSAPublicKey or RSAPrivateKey");
        }
        super.setDecryptionKey(key);
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.d(algorithmIdentifier);
        this.releaseOp();
    }

    private void d(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.rsaEncryption.getOID())) {
            if (algorithmIdentifier.getParameters() != null && !(algorithmIdentifier.getParameters() instanceof ASN1Null)) {
                throw new AlgorithmIdentifierException("The rsaEncryption OID must be accompanied by NULL parameters");
            }
            this.j = 1;
            return;
        }
        if (algorithmIdentifier.getOID().equals(OAEPAlgorithmIdentifier.g)) {
            OAEPAlgorithmIdentifier oAEPAlgorithmIdentifier = algorithmIdentifier instanceof OAEPAlgorithmIdentifier ? (OAEPAlgorithmIdentifier)algorithmIdentifier : new OAEPAlgorithmIdentifier(algorithmIdentifier.getParameters());
            AlgorithmIdentifier algorithmIdentifier2 = oAEPAlgorithmIdentifier.getPSourceFunc();
            if (!algorithmIdentifier2.getOID().equals(OAEPAlgorithmIdentifier.h)) {
                throw new AlgorithmIdentifierException("Only pSpecified AlgIDs are supported for OAEP encoding");
            }
            ASN1Object aSN1Object = algorithmIdentifier2.getParameters();
            if (!(aSN1Object instanceof ASN1OctetString)) {
                throw new AlgorithmIdentifierException("pSourceFunc parameters must be an instance of ASN1OctetString");
            }
            this.g = ((ASN1OctetString)aSN1Object).getValue();
            this.f = MessageDigest.getInstance(oAEPAlgorithmIdentifier.getHashFunc());
            this.k = C0.b(oAEPAlgorithmIdentifier.getMaskGenFunc());
            this.j = 0;
            return;
        }
        throw new AlgorithmIdentifierException("Unsupported AlgorithmIdentifier: " + algorithmIdentifier);
    }

    public void setEncryptionKey(Key key) throws InvalidKeyException {
        if (!(key instanceof RSAPublicKey) && !(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Key must be an instance of RSAPublicKey or RSAPrivateKey");
        }
        super.setEncryptionKey(key);
    }

    public byte[] encrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        this.assertEncryption();
        RSAKey rSAKey = (RSAKey)this.getEncryptionKey();
        int n3 = Utils.length(rSAKey.getModulus());
        byte[] byArray2 = new byte[n3 - 1];
        byte[] byArray3 = null;
        if (n == 0 && n2 == byArray.length) {
            byArray3 = byArray;
        } else {
            byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
        }
        try {
            switch (this.j) {
                case 0: {
                    byArray2 = this.a(byArray3, n3 - 1);
                    break;
                }
                case 1: {
                    byArray2 = this.b(byArray3, n3 - 1);
                    break;
                }
                default: {
                    throw new CipherException("Unknown encoding method: " + this.j);
                }
            }
        }
        catch (CipherException cipherException) {
            throw new CipherException("Message too long");
        }
        RSA rSA = new RSA();
        rSA.setKey(rSAKey);
        byte[] byArray4 = Utils.toByteArray(rSA.performOp(new BigInteger(1, byArray2)));
        byte[] byArray5 = new byte[n3];
        System.arraycopy(byArray4, 0, byArray5, n3 - byArray4.length, byArray4.length);
        return byArray5;
    }

    public void encryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        throw new CipherException("encryptOp illegally used with PKCS1");
    }

    private byte[] e(byte[] byArray) throws CipherException {
        int n;
        int n2 = byArray.length;
        if (n2 < 10 || byArray[0] != 2 && byArray[0] != 1) {
            throw new CipherException("Decoding error");
        }
        if (byArray[0] == 1 && !((RSAKey)this.getDecryptionKey()).isPublic()) {
            throw new CipherException("Decoding error");
        }
        if (byArray[0] == 2 && ((RSAKey)this.getDecryptionKey()).isPublic()) {
            throw new CipherException("Decoding error");
        }
        if (byArray[0] == 1) {
            n = 1;
            while (n < n2 && byArray[n] != 0) {
                if ((byArray[n] & 0xFF) != 255) {
                    throw new CipherException("Decoding error");
                }
                ++n;
            }
        } else {
            n = 1;
            while (n < n2 && byArray[n] != 0) {
                ++n;
            }
        }
        if (n == n2 || n < 9) {
            throw new CipherException("Decoding error");
        }
        byte[] byArray2 = new byte[n2 - n - 1];
        System.arraycopy(byArray, n + 1, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public int blockSize() {
        return 0;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (!(key instanceof RSAPublicKey) && !(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Key must be an instance of RSAPublicKey or RSAPrivateKey");
        }
        this.d(algorithmIdentifier);
        super.erase();
        this.decryptionKey = this.key = (Key)key.clone();
        this.encryptionKey = this.key;
        this.releaseOp();
        this.rbs = null;
    }
}

