/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.EntropySource;
import com.phaos.crypto.MD5RandomBitsSource;
import java.math.BigInteger;

public abstract class RandomBitsSource {
    private static final Object a;
    private static RandomBitsSource b;

    public void seed() {
        this.seed(EntropySource.getDefault());
    }

    static {
        b = null;
        a = new Object();
    }

    public static RandomBitsSource getDefault() {
        Object object = a;
        synchronized (object) {
            if (b == null) {
                b = new MD5RandomBitsSource(true);
            }
        }
        return b;
    }

    public abstract void seed(byte[] var1);

    protected RandomBitsSource() {
    }

    public abstract byte randomByte();

    public byte[] randomBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = this.randomByte();
            ++n;
        }
        return byArray;
    }

    public BigInteger randomBigInteger(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid length " + n);
        }
        byte[] byArray = new byte[n % 8 == 0 ? n / 8 : n / 8 + 1];
        this.randomBytes(byArray);
        if (n % 8 != 0) {
            byArray[0] = (byte)(byArray[0] & (1 << n % 8) - 1);
        }
        return new BigInteger(1, byArray);
    }

    public abstract void seed(EntropySource var1);

    public static void setDefault(RandomBitsSource randomBitsSource) {
        Object object = a;
        synchronized (object) {
            b = randomBitsSource;
        }
    }

    public abstract void clear();
}

