/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.Key;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.Utils;
import java.io.IOException;

public class SymmetricKey
implements Key {
    byte[] a;
    private String b;
    private AlgorithmIdentifier c;

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) {
        this.c = algorithmIdentifier;
    }

    public void finalize() {
        this.erase();
    }

    public int keySize() {
        return this.a.length;
    }

    public SymmetricKey(byte[] byArray, String string) {
        this.setBytes(byArray);
        this.b = string;
    }

    public Object clone() {
        SymmetricKey symmetricKey = new SymmetricKey();
        try {
            if (this.c != null) {
                symmetricKey.c = new AlgorithmIdentifier(Utils.toStream(this.c));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        if (this.a != null) {
            symmetricKey.a = (byte[])this.a.clone();
        }
        if (this.b != null) {
            symmetricKey.b = new String(this.b);
        }
        return symmetricKey;
    }

    public String toString() {
        return Utils.toHexString(this.getBytes());
    }

    public void setBytes(byte[] byArray) {
        this.a = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.a, 0, byArray.length);
    }

    public SymmetricKey() {
        this(new byte[0]);
    }

    public byte[] getBytes() {
        return this.a;
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        return this.getBytes();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SymmetricKey)) {
            return false;
        }
        return Utils.areEqual(((SymmetricKey)object).getBytes(), this.getBytes());
    }

    public void erase() {
        Utils.setArray(this.a, (byte)0);
    }

    public int getBitLength() {
        if (this.a == null) {
            return 0;
        }
        return 8 * this.a.length;
    }

    public AlgorithmIdentifier getAlgID() {
        return this.c;
    }

    public String getAlgorithm() {
        return this.b;
    }

    public SymmetricKey(byte[] byArray) {
        this(byArray, (AlgorithmIdentifier)null);
    }

    public SymmetricKey(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) {
        this.setBytes(byArray);
        this.c = algorithmIdentifier;
    }
}

