/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import com.phaos.utils.UnsyncHashtable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class HttpUtils {
    private static UnsyncHashtable a = new UnsyncHashtable();

    static {
        a.put("Accept", Boolean.FALSE);
        a.put("Accept-Charset", Boolean.FALSE);
        a.put("Accept-Encoding", Boolean.FALSE);
        a.put("Accept-Language", Boolean.FALSE);
        a.put("Accept-Ranges", Boolean.FALSE);
        a.put("Age", Boolean.TRUE);
        a.put("Allow", Boolean.FALSE);
        a.put("Authorization", Boolean.TRUE);
        a.put("Cache-Control", Boolean.FALSE);
        a.put("Connection", Boolean.FALSE);
        a.put("Content-Encoding", Boolean.FALSE);
        a.put("Content-Language", Boolean.FALSE);
        a.put("Content-Length", Boolean.TRUE);
        a.put("Content-Location", Boolean.TRUE);
        a.put("Content-Md5", Boolean.TRUE);
        a.put("Content-Range", Boolean.TRUE);
        a.put("Content-Type", Boolean.TRUE);
        a.put("Date", Boolean.TRUE);
        a.put("Etag", Boolean.TRUE);
        a.put("Expect", Boolean.FALSE);
        a.put("Expires", Boolean.TRUE);
        a.put("From", Boolean.TRUE);
        a.put("Host", Boolean.TRUE);
        a.put("If-Match", Boolean.FALSE);
        a.put("If-Modified-Since", Boolean.TRUE);
        a.put("If-None-Match", Boolean.FALSE);
        a.put("If-Range", Boolean.TRUE);
        a.put("If-Unmodified-Since", Boolean.TRUE);
        a.put("Last-Modified", Boolean.TRUE);
        a.put("Location", Boolean.TRUE);
        a.put("Max-Forwards", Boolean.TRUE);
        a.put("Pragma", Boolean.FALSE);
        a.put("Proxy-Authenticate", Boolean.FALSE);
        a.put("Proxy-Authorization", Boolean.TRUE);
        a.put("Range", Boolean.TRUE);
        a.put("Referer", Boolean.TRUE);
        a.put("Retry-After", Boolean.TRUE);
        a.put("Server", Boolean.FALSE);
        a.put("Te", Boolean.FALSE);
        a.put("Trailer", Boolean.FALSE);
        a.put("Transfer-Encoding", Boolean.FALSE);
        a.put("Upgrade", Boolean.FALSE);
        a.put("User-Agent", Boolean.FALSE);
        a.put("Vary", Boolean.FALSE);
        a.put("Via", Boolean.FALSE);
        a.put("Warning", Boolean.FALSE);
        a.put("WWW-Authenticate", Boolean.FALSE);
    }

    public static boolean requiresSingleValue(String string) {
        Boolean bl = (Boolean)a.get(string);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static String toTitleCase(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.toLowerCase());
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        int n = 1;
        int n2 = string.length();
        while (n < n2) {
            if (stringBuffer.charAt(n - 1) == '-') {
                stringBuffer.setCharAt(n, Character.toUpperCase(stringBuffer.charAt(n)));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String readCanonicalLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(128);
        boolean bl = true;
        do {
            n = inputStream.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = false;
                    break;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        } while (bl);
        int n2 = stringBuffer.length();
        if (n == -1 && n2 == 0) {
            return null;
        }
        if (n2 > 0 && stringBuffer.charAt(n2 - 1) == '\r') {
            stringBuffer.setLength(n2 - 1);
        }
        return stringBuffer.toString();
    }

    public static void parseHeaderStream(InputStream inputStream, Hashtable hashtable, Vector vector) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        while ((string = HttpUtils.readCanonicalLine(inputStream)) != null) {
            int n = -1;
            if (string.length() == 0) {
                if (string2 == null || string3 == null) break;
                string4 = (String)hashtable.get(string2);
                if (string4 != null && !HttpUtils.requiresSingleValue(string2)) {
                    string3 = string4 + ", " + string3;
                } else if (vector != null) {
                    if (string4 != null) {
                        vector.removeElement(string2);
                    }
                    vector.addElement(string2);
                }
                hashtable.put(string2, string3);
                break;
            }
            if (string.charAt(0) == ' ' || string.charAt(0) == '\t') {
                string3 = string3 + "\r\n " + string.trim();
                continue;
            }
            n = string.indexOf(":");
            if (n == -1) continue;
            if (string2 != null && string3 != null) {
                string4 = (String)hashtable.get(string2);
                if (string4 != null && !HttpUtils.requiresSingleValue(string2)) {
                    string3 = string4 + ", " + string3;
                } else if (vector != null) {
                    if (string4 != null) {
                        vector.removeElement(string2);
                    }
                    vector.addElement(string2);
                }
                hashtable.put(string2, string3);
            }
            string2 = HttpUtils.toTitleCase(string.substring(0, n++));
            string3 = string.substring(n).trim();
        }
    }
}

