/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class UnsyncHashtable
extends Dictionary
implements Cloneable,
Serializable {
    private transient int a;
    private int threshold;
    private transient UnsyncHashtableEntry[] b;
    private float loadFactor;
    private static final long serialVersionUID = -5938212379144331159L;

    public Enumeration elements() {
        return new UnsyncHashtableEnumerator(this.b, false);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.b;
        int n = unsyncHashtableEntryArray.length;
        while (n-- > 0) {
            UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtableEntryArray[n];
            while (unsyncHashtableEntry != null) {
                if (unsyncHashtableEntry.e.equals(object)) {
                    return true;
                }
                unsyncHashtableEntry = unsyncHashtableEntry.d;
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.b = new UnsyncHashtableEntry[n3];
        this.a = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }

    public Object clone() {
        try {
            UnsyncHashtable unsyncHashtable = (UnsyncHashtable)super.clone();
            unsyncHashtable.b = new UnsyncHashtableEntry[this.b.length];
            int n = this.b.length;
            while (n-- > 0) {
                UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtable.b[n] = this.b[n] != null ? (UnsyncHashtableEntry)this.b[n].clone() : null;
            }
            return unsyncHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object remove(Object object) {
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.b;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % unsyncHashtableEntryArray.length;
        UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtableEntryArray[n2];
        UnsyncHashtableEntry unsyncHashtableEntry2 = null;
        while (unsyncHashtableEntry != null) {
            if (unsyncHashtableEntry.c == n && unsyncHashtableEntry.a.equals(object)) {
                if (unsyncHashtableEntry2 != null) {
                    unsyncHashtableEntry2.d = unsyncHashtableEntry.d;
                } else {
                    unsyncHashtableEntryArray[n2] = unsyncHashtableEntry.d;
                }
                --this.a;
                return unsyncHashtableEntry.e;
            }
            unsyncHashtableEntry2 = unsyncHashtableEntry;
            unsyncHashtableEntry = unsyncHashtableEntry.d;
        }
        return null;
    }

    public UnsyncHashtable(int n) {
        this(n, 0.75f);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.b.length);
        objectOutputStream.writeInt(this.a);
        int n = this.b.length - 1;
        while (n >= 0) {
            UnsyncHashtableEntry unsyncHashtableEntry = this.b[n];
            while (unsyncHashtableEntry != null) {
                objectOutputStream.writeObject(unsyncHashtableEntry.a);
                objectOutputStream.writeObject(unsyncHashtableEntry.e);
                unsyncHashtableEntry = unsyncHashtableEntry.d;
            }
            --n;
        }
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 <= n) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public UnsyncHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.a;
    }

    public Enumeration keys() {
        return new UnsyncHashtableEnumerator(this.b, true);
    }

    public Object get(Object object) {
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.b;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % unsyncHashtableEntryArray.length;
        UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtableEntryArray[n2];
        while (unsyncHashtableEntry != null) {
            if (unsyncHashtableEntry.c == n && unsyncHashtableEntry.a.equals(object)) {
                return unsyncHashtableEntry.e;
            }
            unsyncHashtableEntry = unsyncHashtableEntry.d;
        }
        return null;
    }

    public UnsyncHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.b = new UnsyncHashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.b;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % unsyncHashtableEntryArray.length;
        UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtableEntryArray[n2];
        while (unsyncHashtableEntry != null) {
            if (unsyncHashtableEntry.c == n && unsyncHashtableEntry.a.equals(object)) {
                Object object3 = unsyncHashtableEntry.e;
                unsyncHashtableEntry.e = object2;
                return object3;
            }
            unsyncHashtableEntry = unsyncHashtableEntry.d;
        }
        if (this.a >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        UnsyncHashtableEntry unsyncHashtableEntry2 = new UnsyncHashtableEntry();
        unsyncHashtableEntry2.c = n;
        unsyncHashtableEntry2.a = object;
        unsyncHashtableEntry2.e = object2;
        unsyncHashtableEntry2.d = unsyncHashtableEntryArray[n2];
        unsyncHashtableEntryArray[n2] = unsyncHashtableEntry2;
        ++this.a;
        return null;
    }

    public void clear() {
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.b;
        int n = unsyncHashtableEntryArray.length;
        while (--n >= 0) {
            unsyncHashtableEntryArray[n] = null;
        }
        this.a = 0;
    }

    protected void rehash() {
        int n = this.b.length;
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.b;
        int n2 = n * 2 + 1;
        UnsyncHashtableEntry[] unsyncHashtableEntryArray2 = new UnsyncHashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.b = unsyncHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtableEntryArray[n3];
            while (unsyncHashtableEntry != null) {
                UnsyncHashtableEntry unsyncHashtableEntry2 = unsyncHashtableEntry;
                unsyncHashtableEntry = unsyncHashtableEntry.d;
                int n4 = (unsyncHashtableEntry2.c & Integer.MAX_VALUE) % n2;
                unsyncHashtableEntry2.d = unsyncHashtableEntryArray2[n4];
                unsyncHashtableEntryArray2[n4] = unsyncHashtableEntry2;
            }
        }
    }

    public boolean containsKey(Object object) {
        UnsyncHashtableEntry[] unsyncHashtableEntryArray = this.b;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % unsyncHashtableEntryArray.length;
        UnsyncHashtableEntry unsyncHashtableEntry = unsyncHashtableEntryArray[n2];
        while (unsyncHashtableEntry != null) {
            if (unsyncHashtableEntry.c == n && unsyncHashtableEntry.a.equals(object)) {
                return true;
            }
            unsyncHashtableEntry = unsyncHashtableEntry.d;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.a == 0;
    }

    private class UnsyncHashtableEnumerator
    implements Enumeration {
        UnsyncHashtableEntry a;
        int b;
        boolean c;
        UnsyncHashtableEntry[] e;

        public Object nextElement() {
            if (this.a == null) {
                while (this.b-- > 0 && (this.a = this.e[this.b]) == null) {
                }
            }
            if (this.a != null) {
                UnsyncHashtableEntry unsyncHashtableEntry = this.a;
                this.a = unsyncHashtableEntry.d;
                return this.c ? unsyncHashtableEntry.a : unsyncHashtableEntry.e;
            }
            throw new NoSuchElementException("UnsyncHashtableEnumerator");
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasMoreElements() {
            if (this.a == null) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                this.a = this.e[this.b];
                if (this.a == null) continue;
                return true;
lbl6:
                // 2 sources

                ** while (this.b-- > 0)
            }
lbl7:
            // 1 sources

            return false;
        }

        UnsyncHashtableEnumerator(UnsyncHashtableEntry[] unsyncHashtableEntryArray, boolean bl) {
            this.e = unsyncHashtableEntryArray;
            this.c = bl;
            this.b = unsyncHashtableEntryArray.length;
        }
    }

    private class UnsyncHashtableEntry {
        Object a;
        int c;
        UnsyncHashtableEntry d;
        Object e;

        private UnsyncHashtableEntry() {
        }

        protected Object clone() {
            UnsyncHashtableEntry unsyncHashtableEntry = new UnsyncHashtableEntry();
            unsyncHashtableEntry.c = this.c;
            unsyncHashtableEntry.a = this.a;
            unsyncHashtableEntry.e = this.e;
            unsyncHashtableEntry.d = this.d != null ? (UnsyncHashtableEntry)this.d.clone() : null;
            return unsyncHashtableEntry;
        }
    }
}

