/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import com.phaos.utils.FixedByteArrayOutputStream;
import com.phaos.utils.InvalidFormatException;
import com.phaos.utils.Streamable;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.Vector;

public class Utils {
    public static byte[] wordToBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    public static void bytesToWords(byte[] byArray, int[] nArray) {
        Utils.bytesToWords(byArray, 0, nArray, 0, nArray.length);
    }

    public static void bytesToShorts(byte[] byArray, short[] sArray) {
        int n = 0;
        int n2 = 0;
        int n3 = sArray.length;
        while (n < n3) {
            sArray[n] = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
            ++n;
        }
    }

    public static void bytesToWords(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        while (n4 < n2 + n3) {
            nArray[n4] = (byArray[n5++] & 0xFF) << 24 | (byArray[n5++] & 0xFF) << 16 | (byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF;
            ++n4;
        }
    }

    public static String stripEOL(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c != '\r' && c != '\n') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void inputByteArray(byte[] byArray, int n, int n2, InputStream inputStream) throws IOException {
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            int n5 = inputStream.read(byArray, n3, n4 - n3);
            if (n5 == -1) {
                throw new IOException("End of stream reached before all " + n2 + " expected bytes could be read. Only received " + (n3 - n) + " bytes before the end of the stream was reached");
            }
            n3 += n5;
        }
    }

    public static void dumpHex(PrintStream printStream, byte[] byArray) {
        String string = "";
        String string2 = "";
        byte[] byArray2 = new byte[]{0};
        int n = byArray.length + (byArray.length % 16 == 0 ? 0 : 16 - byArray.length % 16);
        int n2 = 0;
        while (n2 < n) {
            if (n2 < byArray.length) {
                byArray2[0] = byArray[n2];
                string = string + Utils.toHexString(byArray2);
                string2 = byArray[n2] >= 32 && byArray[n2] <= 125 ? string2 + (char)(byArray[n2] & 0xFF) : string2 + ".";
            } else {
                string = string + "  ";
            }
            if (++n2 % 16 == 0) {
                printStream.println(string + "\t" + string2);
                string2 = "";
                string = "";
                continue;
            }
            string = string + " ";
        }
    }

    public static Date parseDate(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = -2;
        int n2 = 0;
        if (bl || string.indexOf(90) == 14 || string.indexOf(43) == 14 || string.indexOf(45) == 14) {
            n2 = 100 * Utils.a(string, n += 2);
            n2 += Utils.a(string, n += 2);
        } else {
            n2 = 1900 + Utils.a(string, n += 2);
            if (n2 < 1950) {
                n2 += 100;
            }
        }
        int n3 = Utils.a(string, n += 2);
        int n4 = Utils.a(string, n += 2);
        int n5 = Utils.a(string, n += 2);
        int n6 = Utils.a(string, n += 2);
        int n7 = 0;
        if (string.charAt(n + 2) >= '0' && string.charAt(n + 2) <= '9') {
            n7 = Utils.a(string, n += 2);
        }
        int n8 = 0;
        if (string.charAt(n += 2) != 'Z') {
            int n9 = Utils.a(string, n + 1);
            int n10 = Utils.a(string, n + 3);
            n8 = (n9 * 60 + n10) * 60 * 1000;
            if (string.charAt(n) == '-') {
                n8 = -n8;
            }
        }
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n8, "");
        Calendar calendar = Calendar.getInstance(simpleTimeZone);
        calendar.set(n2, n3 - 1, n4, n5, n6, n7);
        return calendar.getTime();
    }

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return Utils.toHexString(byArray, 0, byArray.length);
    }

    public static int hashBytes(Streamable streamable) {
        return new String(Utils.toBytes(streamable)).hashCode();
    }

    public static int inputWord(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (n == -1 || n2 == -1 || n3 == -1 || n4 == -1) {
            throw new EOFException();
        }
        return Utils.bytesToWord(n, n2, n3, n4);
    }

    static int a(String string, int n) {
        return 10 * (string.charAt(n) - 48) + (string.charAt(n + 1) - 48);
    }

    public static void wordsToBytes(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        while (n4 < n + n3) {
            byArray[n5++] = (byte)(nArray[n4] >> 24);
            byArray[n5++] = (byte)(nArray[n4] >> 16);
            byArray[n5++] = (byte)(nArray[n4] >> 8);
            byArray[n5++] = (byte)nArray[n4];
            ++n4;
        }
    }

    public static void outputBignum(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        outputStream.write(Utils.toByteArray(bigInteger));
    }

    public static void toByteArray(BigInteger bigInteger, byte[] byArray, int n, int n2) throws ArithmeticException {
        byte[] byArray2 = Utils.toByteArray(bigInteger);
        if (byArray2.length > n2) {
            throw new ArithmeticException("The argument is too big to fit in the destination buffer");
        }
        Utils.setArray(byArray, n, n2, (byte)0);
        System.arraycopy(byArray2, 0, byArray, n + (n2 - byArray2.length), byArray2.length);
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        String string = "0123456789abcdef";
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n + n2) {
            stringBuffer.append(string.charAt((byArray[n3] & 0xFF) >> 4));
            stringBuffer.append(string.charAt(byArray[n3] & 0xF));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static void longsToBytes(long[] lArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        while (n4 < n + n3) {
            byArray[n5++] = (byte)(lArray[n4] >> 56);
            byArray[n5++] = (byte)(lArray[n4] >> 48);
            byArray[n5++] = (byte)(lArray[n4] >> 40);
            byArray[n5++] = (byte)(lArray[n4] >> 32);
            byArray[n5++] = (byte)(lArray[n4] >> 24);
            byArray[n5++] = (byte)(lArray[n4] >> 16);
            byArray[n5++] = (byte)(lArray[n4] >> 8);
            byArray[n5++] = (byte)lArray[n4];
            ++n4;
        }
    }

    public static void wordsToBytes(int[] nArray, byte[] byArray) {
        Utils.wordsToBytes(nArray, 0, byArray, 0, nArray.length);
    }

    public static String toURLEncoded(String string) {
        return URLEncoder.encode(string);
    }

    public static short bytesToShort(int n, int n2) {
        return (short)(n2 & 0xFF | (n & 0xFF) << 8);
    }

    public static void output(short s, OutputStream outputStream) throws IOException {
        Utils.outputShort(s, outputStream);
    }

    public static String toBase64(byte[] byArray, String string) {
        int n = (byArray.length + 2) / 3 * 4 + (byArray.length / 48 + 1) * string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        int n3 = byArray.length;
        while (n2 < n3) {
            int n4 = Math.min(byArray.length - n2, 3);
            stringBuffer.append(Utils.d((byArray[n2] & 0xFC) >> 2));
            switch (n4) {
                case 2: 
                case 3: {
                    stringBuffer.append(Utils.d(((byArray[n2] & 3) << 4) + ((byArray[n2 + 1] & 0xF0) >> 4)));
                    break;
                }
                case 1: {
                    stringBuffer.append(Utils.d((byArray[n2] & 3) << 4));
                }
            }
            switch (n4) {
                case 3: {
                    stringBuffer.append(Utils.d(((byArray[n2 + 1] & 0xF) << 2) + ((byArray[n2 + 2] & 0xC0) >> 6)));
                    break;
                }
                case 2: {
                    stringBuffer.append(Utils.d((byArray[n2 + 1] & 0xF) << 2));
                    break;
                }
                case 1: {
                    stringBuffer.append('=');
                }
            }
            switch (n4) {
                case 3: {
                    stringBuffer.append(Utils.d(byArray[n2 + 2] & 0x3F));
                    break;
                }
                case 1: 
                case 2: {
                    stringBuffer.append('=');
                }
            }
            if (n2 % 48 == 45) {
                stringBuffer.append(string);
            }
            n2 += 3;
        }
        if (byArray.length % 48 <= 45) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void setArray(byte[] byArray, int n, int n2, byte by) {
        if (byArray == null) {
            return;
        }
        int n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = by;
            ++n3;
        }
    }

    public static void output(long l, OutputStream outputStream) throws IOException {
        Utils.outputLong(l, outputStream);
    }

    public static void output(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        Utils.outputBignum(bigInteger, outputStream);
    }

    public static String toBase64(byte[] byArray) {
        return Utils.toBase64(byArray, true);
    }

    public static String toString(Vector vector) {
        if (vector == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            stringBuffer.append(vector.elementAt(n).toString());
            if (n != n2 - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public static void bytesToChars(byte[] byArray, char[] cArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length / 2;
        while (n < n3) {
            cArray[n] = (char)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
            ++n;
        }
        if (byArray.length % 2 == 1) {
            cArray[byArray.length / 2] = (char)(byArray[byArray.length - 1] & 0xFF);
        }
    }

    private static int b(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        throw new IllegalArgumentException();
    }

    public static byte[] fromBase64(String string) {
        int n = string.length() / 4 * 3;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(n);
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n3 < string.length() && (string.charAt(n3) == '\r' || string.charAt(n3) == '\n')) {
                ++n3;
                continue;
            }
            if (n3 + 4 > string.length()) break;
            int n4 = string.charAt(n3 + 2) == '=' ? 1 : (string.charAt(n3 + 3) == '=' ? 2 : 3);
            int n5 = Utils.b(string.charAt(n3));
            int n6 = Utils.b(string.charAt(n3 + 1));
            int n7 = 0;
            int n8 = 0;
            switch (n4) {
                case 3: {
                    n8 = Utils.b(string.charAt(n3 + 3));
                }
                case 2: {
                    n7 = Utils.b(string.charAt(n3 + 2));
                }
            }
            try {
                unsyncByteArrayOutputStream.write((n5 << 2) + ((n6 & 0x30) >> 4));
                if (n4 != 1) {
                    unsyncByteArrayOutputStream.write(((n6 & 0xF) << 4) + ((n7 & 0x3C) >> 2));
                }
                if (n4 == 3) {
                    unsyncByteArrayOutputStream.write(((n7 & 3) << 6) + n8);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
            n2 += 3;
            n3 += 4;
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public static void shortsToBytes(short[] sArray, byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = sArray.length;
        while (n < n3) {
            byArray[n2++] = (byte)(sArray[n] >> 8);
            byArray[n2++] = (byte)sArray[n];
            ++n;
        }
    }

    public static Date daysFrom(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        return calendar.getTime();
    }

    public static void outputString(String string, OutputStream outputStream) throws IOException {
        outputStream.write(string.getBytes());
    }

    public static void outputWord(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >> 24));
        outputStream.write((byte)(n >> 16));
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)n);
    }

    public static InputStream toStream(Streamable streamable) {
        return new UnsyncByteArrayInputStream(Utils.toBytes(streamable));
    }

    static String c(int n) {
        String string = Integer.toString(n);
        if (string.length() == 2) {
            return string;
        }
        return "0" + string;
    }

    public static byte[] toBytes(InputStream inputStream) throws IOException {
        int n;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            unsyncByteArrayOutputStream.write(byArray, 0, n);
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public static byte[] longToBytes(long l) {
        byte[] byArray = new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
        return byArray;
    }

    public static byte[] toByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public static String fromURLEncoded(String string) {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(string.length());
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n);
            if (n2 == 43) {
                n2 = 32;
            } else if (n2 == 37) {
                n2 = string.charAt(++n);
                int n3 = Character.digit((char)n2, 16);
                n2 = string.charAt(++n);
                int n4 = Character.digit((char)n2, 16);
                n2 = (n3 & 0xF) << 4 | n4 & 0xF;
            }
            try {
                unsyncByteArrayOutputStream.write(n2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
            ++n;
        }
        return unsyncByteArrayOutputStream.toString();
    }

    public static void setArray(byte[] byArray, byte by) {
        if (byArray == null) {
            return;
        }
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            byArray[n] = by;
            ++n;
        }
    }

    public static void bytesToLongs(byte[] byArray, int n, long[] lArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        while (n4 < n2 + n3) {
            lArray[n4] = ((long)byArray[n5++] & 0xFFL) << 56 | ((long)byArray[n5++] & 0xFFL) << 48 | ((long)byArray[n5++] & 0xFFL) << 40 | ((long)byArray[n5++] & 0xFFL) << 32 | ((long)byArray[n5++] & 0xFFL) << 24 | ((long)byArray[n5++] & 0xFFL) << 16 | ((long)byArray[n5++] & 0xFFL) << 8 | (long)byArray[n5++] & 0xFFL;
            ++n4;
        }
    }

    public static void outputLong(long l, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(l >> 56));
        outputStream.write((byte)(l >> 48));
        outputStream.write((byte)(l >> 40));
        outputStream.write((byte)(l >> 32));
        outputStream.write((byte)(l >> 24));
        outputStream.write((byte)(l >> 16));
        outputStream.write((byte)(l >> 8));
        outputStream.write((byte)l);
    }

    public static byte inputByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public static void output(int n, OutputStream outputStream) throws IOException {
        Utils.outputWord(n, outputStream);
    }

    public static String formatDate(Date date) {
        return Utils.formatDate(date, false);
    }

    public static short rotrShort(int n, int n2) {
        int n3 = n & 0xFFFF;
        return (short)(n3 >> n2 | n3 << 16 - n2);
    }

    public static byte[] toBytesUnsafe(Streamable streamable) throws IOException {
        FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(streamable.length());
        streamable.output(fixedByteArrayOutputStream);
        return fixedByteArrayOutputStream.getBytes();
    }

    public static BigInteger inputBignum(int n, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[n];
        Utils.inputByteArray(byArray, inputStream);
        BigInteger bigInteger = BigInteger.valueOf(0L);
        try {
            bigInteger = new BigInteger(1, byArray);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.toString());
        }
        return bigInteger;
    }

    public static boolean areEqual(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n4 = n + n3;
        while (n < n3) {
            if (byArray[n] != byArray2[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public static String toBase64(byte[] byArray, boolean bl) {
        String string = bl ? System.getProperty("line.separator") : "";
        return Utils.toBase64(byArray, string);
    }

    public static byte[] toBytes(Streamable streamable) {
        try {
            FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(streamable.length());
            streamable.output(fixedByteArrayOutputStream);
            return fixedByteArrayOutputStream.getBytes();
        }
        catch (IOException iOException) {
            throw new StreamableOutputException(iOException);
        }
    }

    public static String formatDate(Date date, boolean bl) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(0, ""));
        gregorianCalendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(Utils.c(gregorianCalendar.get(1) / 100));
        }
        stringBuffer.append(Utils.c(gregorianCalendar.get(1) % 100));
        stringBuffer.append(Utils.c(gregorianCalendar.get(2) + 1));
        stringBuffer.append(Utils.c(gregorianCalendar.get(5)));
        int n = gregorianCalendar.get(10);
        if (gregorianCalendar.get(9) == 1) {
            n += 12;
        }
        stringBuffer.append(Utils.c(n));
        stringBuffer.append(Utils.c(gregorianCalendar.get(12)));
        stringBuffer.append(Utils.c(gregorianCalendar.get(13)));
        return stringBuffer.append("Z").toString();
    }

    public static void outputShort(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)n);
    }

    public static void longsToBytes(long[] lArray, byte[] byArray) {
        Utils.longsToBytes(lArray, 0, byArray, 0, lArray.length);
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = byArray2.length;
        if (n >= n2) {
            byte[] byArray3 = new byte[n];
            int n3 = 0;
            while (n3 < n) {
                byArray3[n3] = n3 < n2 ? (byte)(byArray[n3] ^ byArray2[n3]) : byArray[n3];
                ++n3;
            }
            return byArray3;
        }
        return Utils.xor(byArray2, byArray);
    }

    public static byte[] shortToBytes(short s) {
        byte[] byArray = new byte[]{(byte)(s >> 8), (byte)s};
        return byArray;
    }

    public static int length(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        if (n == 0) {
            return 1;
        }
        return (n - 1) / 8 + 1;
    }

    public static void setArray(short[] sArray, short s) {
        if (sArray == null) {
            return;
        }
        int n = 0;
        int n2 = sArray.length;
        while (n < n2) {
            sArray[n] = s;
            ++n;
        }
    }

    public static Date parseDate(String string) {
        return Utils.parseDate(string, false);
    }

    public static byte[] fromHexString(String string) {
        if (string.length() % 2 != 0) {
            throw new NumberFormatException("malformed hex string (non-even length)");
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        int n2 = string.length() / 2;
        while (n < n2) {
            byArray[n] = (byte)Integer.parseInt(string.substring(2 * n, 2 * n + 2), 16);
            ++n;
        }
        return byArray;
    }

    public static String bytesToUnicode(byte[] byArray) {
        char[] cArray = new char[(byArray.length - 1) / 2 + 1];
        Utils.bytesToChars(byArray, cArray);
        return new String(cArray);
    }

    public static byte[] unicodeToBytes(String string) {
        char[] cArray = new char[string.length()];
        byte[] byArray = new byte[cArray.length << 1];
        string.getChars(0, cArray.length, cArray, 0);
        Utils.charsToBytes(cArray, byArray);
        return byArray;
    }

    public static String fromUTF8(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            int n3;
            int n4;
            int n5 = byArray[n] & 0xFF;
            if (n5 < 128) {
                stringBuffer.append((char)n5);
            } else if ((n5 & 0xE0) == 192) {
                if (n == byArray.length - 1) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                if (((n4 = byArray[++n] & 0xFF) & 0xC0) != 128) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                stringBuffer.append((char)((n5 & 0x1F) << 6 | n4 & 0x3F));
            } else if ((n5 & 0xF0) == 224) {
                if (n >= byArray.length - 2) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                n4 = byArray[++n] & 0xFF;
                n3 = byArray[++n] & 0xFF;
                if ((n4 & 0xC0) != 128 || (n3 & 0xC0) != 128) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                stringBuffer.append((char)((n5 & 0xF) << 12 | (n4 & 0x3F) << 6 | n3 & 0x3F));
            } else if ((n5 & 0xF8) == 240) {
                if (n >= byArray.length - 3) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                n4 = byArray[++n] & 0xFF;
                n3 = byArray[++n] & 0xFF;
                int n6 = byArray[++n] & 0xFF;
                if ((n4 & 0xC0) != 128 || (n3 & 0xC0) != 128 || (n6 & 0xC0) != 128) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                int n7 = ((n5 & 1) << 20 | (n4 & 0x3F) << 12 | (n3 & 0x3F) << 6 | n6 & 0x3F) - 65536;
                stringBuffer.append((char)(55296 + (n7 >> 10)));
                stringBuffer.append((char)(56320 + (n7 & 0x3FF)));
            } else {
                throw new InvalidFormatException("Illegal UTF encoding");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static byte[] toUTF8(String string) {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(string.length() * 2);
        try {
            int n = 0;
            int n2 = string.length();
            while (n < n2) {
                char c = string.charAt(n);
                if (c < '\u0080') {
                    unsyncByteArrayOutputStream.write((byte)c);
                } else if (c < '\u0800') {
                    unsyncByteArrayOutputStream.write(0xC0 | c >> 6);
                    unsyncByteArrayOutputStream.write(0x80 | c & 0x3F);
                } else if (c >= '\ud800' && c < '\udc00' && n != string.length() - 1 && string.charAt(n + 1) >= '\udc00' && string.charAt(n + 1) < '\ue000') {
                    int n3 = c - 55296 << 10 + (string.charAt(n + 1) - 56320) + 65536;
                    unsyncByteArrayOutputStream.write(0xF0 | n3 >> 18);
                    unsyncByteArrayOutputStream.write(0x80 | n3 >> 12 & 0x3F);
                    unsyncByteArrayOutputStream.write(0x80 | n3 >> 6 & 0x3F);
                    unsyncByteArrayOutputStream.write(0x80 | n3 & 0x3F);
                } else {
                    unsyncByteArrayOutputStream.write(0xE0 | c >> 12);
                    unsyncByteArrayOutputStream.write(0x80 | c >> 6 & 0x3F);
                    unsyncByteArrayOutputStream.write(0x80 | c & 0x3F);
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public static void charsToBytes(char[] cArray, byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = cArray.length;
        while (n < n3) {
            byArray[n2++] = (byte)(cArray[n] >> 8);
            byArray[n2++] = (byte)cArray[n];
            ++n;
        }
    }

    public static short rotlShort(int n, int n2) {
        int n3 = n & 0xFFFF;
        return (short)(n3 << n2 | n3 >> 16 - n2);
    }

    public static int rotr(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    public static Date daysFromNow(int n) {
        return Utils.daysFrom(new Date(), n);
    }

    public static byte[] inputByteArray(byte[] byArray, InputStream inputStream) throws IOException {
        Utils.inputByteArray(byArray, 0, byArray.length, inputStream);
        return byArray;
    }

    public static int bytesToWord(int n, int n2, int n3, int n4) {
        return n4 & 0xFF | (n3 & 0xFF) << 8 | (n2 & 0xFF) << 16 | (n & 0xFF) << 24;
    }

    public static int input24bit(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        if (n == -1 || n2 == -1 || n3 == -1) {
            throw new EOFException();
        }
        return Utils.bytesToWord(0, n, n2, n3);
    }

    public static short inputShort(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n == -1 || n2 == -1) {
            throw new EOFException();
        }
        return Utils.bytesToShort(n, n2);
    }

    public static Date minutesFrom(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, n);
        return calendar.getTime();
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static byte[] inputBytes(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        return Utils.inputByteArray(byArray, inputStream);
    }

    public static void output24bit(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >> 16));
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)n);
    }

    public static void setArray(int[] nArray, int n) {
        if (nArray == null) {
            return;
        }
        int n2 = 0;
        int n3 = nArray.length;
        while (n2 < n3) {
            nArray[n2] = n;
            ++n2;
        }
    }

    private static char d(int n) {
        if (n < 26) {
            return (char)(65 + n);
        }
        if (n < 52) {
            return (char)(97 + n - 26);
        }
        if (n < 62) {
            return (char)(48 + n - 52);
        }
        if (n == 62) {
            return '+';
        }
        if (n == 63) {
            return '/';
        }
        throw new IllegalArgumentException();
    }

    public static String plural(int n, String string) {
        return n + " " + string + (n == 1 ? "" : "s");
    }

    public static int rotl(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }
}

