/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard;

import com.sun.cns.basicreg.common.Profile;
import com.sun.cns.basicreg.wizard.util.Country;
import com.sun.cns.basicreg.wizard.util.I18N;
import com.sun.cns.basicreg.wizard.util.Language;
import com.sun.cns.basicreg.wizard.util.Message;
import com.sun.cns.basicreg.wizard.util.State;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Collector {
    private static final Logger LOG = Logger.getLogger(Collector.class.getName());
    private static final String[] SECURITY_QUESTIONS = new String[]{I18N.SECURITY_QUESTION_DEFAULT, I18N.SECURITY_QUESTION_ONE, I18N.SECURITY_QUESTION_TWO, I18N.SECURITY_QUESTION_THREE};
    private static final String[] JOB_ROLES = new String[]{I18N.JOB_DEFAULT, I18N.JOB_01, I18N.JOB_02, I18N.JOB_03, I18N.JOB_SEPARATOR_ONE, I18N.JOB_04, I18N.JOB_05, I18N.JOB_06, I18N.JOB_07, I18N.JOB_08, I18N.JOB_09, I18N.JOB_10, I18N.JOB_SEPARATOR_TWO, I18N.JOB_11, I18N.JOB_12, I18N.JOB_13, I18N.JOB_14, I18N.JOB_15, I18N.JOB_16, I18N.JOB_17};
    private static final String INVALID_DEFAULT_CODE = "-1";
    private static Collector instance = null;
    ArrayList countries = new ArrayList();
    ArrayList states = new ArrayList();
    ArrayList languages = new ArrayList();
    ArrayList messages = new ArrayList();
    private String identifier;
    private String languageOrder = null;
    private String countryOrder = null;

    public static Collector getInstance() {
        if (instance == null) {
            instance = new Collector();
        }
        return instance;
    }

    public Collector() {
    }

    public Collector(String identifier) {
        this.identifier = identifier;
    }

    public List getProtocols() {
        ArrayList<String> protocolsAL = new ArrayList<String>();
        for (int i = 0; i < Profile.PROXY_PROTOCOLS.length; ++i) {
            protocolsAL.add(Profile.PROXY_PROTOCOLS[i]);
        }
        return protocolsAL;
    }

    public List getSecurityQuestions() {
        ArrayList<String> securityQuestionsAL = new ArrayList<String>();
        for (int i = 0; i < SECURITY_QUESTIONS.length; ++i) {
            securityQuestionsAL.add(SECURITY_QUESTIONS[i]);
        }
        return securityQuestionsAL;
    }

    public List getJobRoles() {
        ArrayList<String> jobRolesAL = new ArrayList<String>();
        for (int i = 0; i < JOB_ROLES.length; ++i) {
            jobRolesAL.add(JOB_ROLES[i]);
        }
        return jobRolesAL;
    }

    public List getCountries() {
        this.identifier = "wizards/country.xml";
        this.countryOrder = I18N.getCountryValueString("_i18n.country.order", null);
        this.countries.clear();
        this.countries.add(new Country(I18N.COUNTRY_DEFAULT_NAME, INVALID_DEFAULT_CODE));
        return this.getElements(this.identifier, "country");
    }

    public static String findCountryCodeEntry(String countryStr) {
        ArrayList countries = (ArrayList)Collector.getInstance().getCountries();
        Country country2 = null;
        String code = " ";
        for (Country country2 : countries) {
            if (!country2.getName().equals(countryStr)) continue;
            LOG.info("country code for " + countryStr + " is " + country2.getCode());
            code = country2.getCode();
        }
        return code;
    }

    public List getStates() {
        this.identifier = "wizards/state.xml";
        this.states.clear();
        return this.getElements(this.identifier, "state");
    }

    public List getLanguages() {
        this.identifier = "wizards/language.xml";
        this.languageOrder = I18N.getLanguageValueString("_i18n.language.order", null);
        this.languages.clear();
        this.languages.add(new Language(I18N.LANGUAGE_DEFAULT_NAME, INVALID_DEFAULT_CODE));
        return this.getElements(this.identifier, "language");
    }

    public static String findLanguageCodeEntry(String languageStr) {
        ArrayList languages = (ArrayList)Collector.getInstance().getLanguages();
        Language language2 = null;
        String code = " ";
        for (Language language2 : languages) {
            if (!language2.getLanguage().equals(languageStr)) continue;
            LOG.info("language code for " + languageStr + " is " + language2.getCode());
            code = language2.getCode();
        }
        return code;
    }

    public List getMessages() {
        this.identifier = "wizards/message.xml";
        return this.getElements(this.identifier, "message");
    }

    private List getElements(String identifier, String type) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(identifier);
        SAXBuilder builder = new SAXBuilder();
        Document document = null;
        try {
            document = builder.build(inputStream);
        }
        catch (JDOMException e) {
            LOG.severe(e.getMessage());
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
        }
        if (document != null) {
            Element rootElm = document.getRootElement();
            List elms = rootElm.getChildren(type);
            Iterator i = elms.iterator();
            while (i.hasNext()) {
                if (type.equalsIgnoreCase("message")) {
                    this.messages.add(this.createMessage((Element)i.next()));
                    continue;
                }
                if (type.equalsIgnoreCase("state")) {
                    this.states.add(this.createState((Element)i.next()));
                    continue;
                }
                if (type.equalsIgnoreCase("country")) {
                    this.countries.add(this.createCountry((Element)i.next()));
                    continue;
                }
                if (!type.equalsIgnoreCase("language")) continue;
                this.languages.add(this.createLanguage((Element)i.next()));
            }
        }
        if (type.equalsIgnoreCase("message")) {
            return this.messages;
        }
        if (type.equalsIgnoreCase("state")) {
            return this.states;
        }
        if (type.equalsIgnoreCase("country")) {
            if (this.countries != null && this.countryOrder != null) {
                Country[] countryArray = this.countries.toArray(new Country[0]);
                Arrays.sort(countryArray, new CountryComparator());
                return new ArrayList<Country>(Arrays.asList(countryArray));
            }
            return this.countries;
        }
        if (type.equalsIgnoreCase("language")) {
            if (this.languages != null && this.languageOrder != null) {
                Language[] languageArray = this.languages.toArray(new Language[0]);
                Arrays.sort(languageArray, new LanguageComparator());
                return new ArrayList<Language>(Arrays.asList(languageArray));
            }
            return this.languages;
        }
        return null;
    }

    public List getStates(String country) {
        Iterator i = this.countries.iterator();
        while (i.hasNext()) {
            if (!((Country)i.next()).getName().equalsIgnoreCase(country)) continue;
            return ((Country)i.next()).getStates();
        }
        return null;
    }

    private Country createCountry(Element element) {
        Country result = new Country(I18N.getCountryValueString(element.getAttributeValue("name").replaceAll(" ", "."), element.getAttributeValue("name")), element.getAttributeValue("code"));
        List stateElms = element.getChildren("state");
        Iterator i = stateElms.iterator();
        while (i.hasNext()) {
            result.addState(this.createState((Element)i.next()));
        }
        return result;
    }

    private State createState(Element element) {
        State result = new State(element.getText(), element.getAttributeValue("code"));
        return result;
    }

    private Language createLanguage(Element element) {
        Language result = new Language(I18N.getLanguageValueString(element.getText().replaceAll(" ", "."), element.getText()), element.getAttributeValue("code"));
        return result;
    }

    private Message createMessage(Element element) {
        Message result = new Message(element.getText(), element.getAttributeValue("code"));
        return result;
    }

    class CountryComparator
    implements Comparator {
        CountryComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (Collector.this.countryOrder == null || obj1 == null || obj2 == null) {
                return 0;
            }
            String lowerCountryOrder = Collector.this.countryOrder.toLowerCase();
            String lowerCountryCode1 = ((Country)obj1).getCode().toLowerCase();
            String lowerCountryCode2 = ((Country)obj2).getCode().toLowerCase();
            int countryCode1Index = lowerCountryOrder.indexOf(lowerCountryCode1);
            int countryCode2Index = lowerCountryOrder.indexOf(lowerCountryCode2);
            return countryCode1Index - countryCode2Index;
        }
    }

    class LanguageComparator
    implements Comparator {
        LanguageComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (Collector.this.languageOrder == null || obj1 == null || obj2 == null) {
                return 0;
            }
            String lowerLanguageOrder = Collector.this.languageOrder.toLowerCase();
            String lowerLangCode1 = ((Language)obj1).getCode().toLowerCase();
            String lowerLangCode2 = ((Language)obj2).getCode().toLowerCase();
            int langCode1Index = lowerLanguageOrder.indexOf(lowerLangCode1);
            int langCode2Index = lowerLanguageOrder.indexOf(lowerLangCode2);
            return langCode1Index - langCode2Index;
        }
    }
}

