/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.cli;

import com.sun.cns.basicreg.cacao.CacaoAdapterException;
import com.sun.cns.basicreg.cacao.ClientLoginCacaoAdapter;
import com.sun.cns.basicreg.cacao.NetworkProxyCacaoAdapter;
import com.sun.cns.basicreg.cacao.OfferingCacaoAdapter;
import com.sun.cns.basicreg.cacao.PROMCacaoAdapter;
import com.sun.cns.basicreg.cacao.SWUPOMCacaoAdapter;
import com.sun.cns.basicreg.common.Base64;
import com.sun.cns.basicreg.common.CmdLineGlobalObject;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.common.ProxyManager;
import com.sun.cns.basicreg.common.XOR;
import com.sun.cns.basicreg.wizard.util.Response;
import com.sun.cns.basicreg.wizard.util.ResponseError;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class AutoReg {
    private String identifier = null;
    private CmdLineGlobalObject globalObject = CmdLineGlobalObject.getInstance();
    private Document document = null;
    private String token = null;
    private String offeringType = null;
    private String portalEnabled = null;
    private String lps = null;
    private String proxyAuth = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String subscriptionKey = null;
    private static final Logger LOG = Logger.getLogger(AutoReg.class.getName());

    public AutoReg(String identifier) {
        this.identifier = identifier;
    }

    public void run() {
        this.printRegistrationProfile();
        boolean r = this.autoregConsumer();
        if (r) {
            System.out.println("auto-registration succeed");
        } else {
            System.out.println("auto-registration failed");
        }
    }

    public void initialize() {
        if (CmdLineGlobalObject.registrationProfile != null) {
            this.identifier = CmdLineGlobalObject.registrationProfile;
        }
        EntityResolver resolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream("dtd/registrationprofile.dtd");
                return new InputSource(inputStream);
            }
        };
        SAXBuilder builder = new SAXBuilder(true);
        builder.setEntityResolver(resolver);
        try {
            this.document = builder.build((InputStream)new FileInputStream(this.identifier));
        }
        catch (JDOMException e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
        if (this.document != null) {
            this.token = this.findEntry("token", null);
            this.offeringType = this.findEntry("offering", "type");
            this.portalEnabled = this.findEntry("portalenabled", null);
            this.lps = this.findEntry("lps", null);
            this.proxyAuth = this.findEntry("proxy", "auth");
            this.proxyHost = this.findEntry("hostname", null);
            this.proxyPort = this.findEntry("port", null);
            this.proxyUsername = this.findEntry("username", null);
            this.proxyPassword = this.findEntry("password", null);
            this.subscriptionKey = this.findEntry("subscriptionkey", null);
            if (this.proxyPassword != null && this.token != null) {
                byte[] proxyPasswordByteArray = Base64.base64ToByteArray((String)this.proxyPassword, (boolean)false);
                String proxyPasswordTemp = new String(proxyPasswordByteArray);
                XOR xor = new XOR(this.token.getBytes(), proxyPasswordByteArray, this.token.length(), proxyPasswordTemp.length());
                this.proxyPassword = new String(xor.encrypt());
            }
            if (CmdLineGlobalObject.companyToken == null) {
                CmdLineGlobalObject.companyToken = this.token;
            }
            if (CmdLineGlobalObject.offeringType == null) {
                CmdLineGlobalObject.offeringType = this.offeringType;
            }
            if (CmdLineGlobalObject.portalEnabled == null) {
                CmdLineGlobalObject.portalEnabled = this.portalEnabled;
            }
            if (CmdLineGlobalObject.lps == null) {
                CmdLineGlobalObject.lps = this.lps;
            }
            if (CmdLineGlobalObject.proxyAuth == null) {
                CmdLineGlobalObject.proxyAuth = this.proxyAuth;
            }
            if (CmdLineGlobalObject.proxyHost == null) {
                CmdLineGlobalObject.proxyHost = this.proxyHost;
            }
            if (CmdLineGlobalObject.proxyPort == null) {
                CmdLineGlobalObject.proxyPort = this.proxyPort;
            }
            if (CmdLineGlobalObject.proxyUsername == null) {
                CmdLineGlobalObject.proxyUsername = this.proxyUsername;
            }
            if (CmdLineGlobalObject.proxyPassword == null) {
                CmdLineGlobalObject.proxyPassword = this.proxyPassword;
            }
            if (CmdLineGlobalObject.subscriptionKey == null) {
                CmdLineGlobalObject.subscriptionKey = this.subscriptionKey;
            }
            this.setProxy();
        }
    }

    private void setProxy() {
        Properties proxyProperties = new Properties();
        if (CmdLineGlobalObject.proxyHost != null) {
            if (CmdLineGlobalObject.proxyHost.trim().length() > 1) {
                proxyProperties.setProperty("http.proxySet", "true");
                proxyProperties.setProperty("http.proxyHost", CmdLineGlobalObject.proxyHost);
                proxyProperties.setProperty("http.proxyPort", CmdLineGlobalObject.proxyPort);
                if (CmdLineGlobalObject.proxyUsername != null) {
                    proxyProperties.setProperty("http.proxyUser", CmdLineGlobalObject.proxyUsername);
                    proxyProperties.setProperty("https.proxyUser", CmdLineGlobalObject.proxyUsername);
                }
                if (CmdLineGlobalObject.proxyPassword != null) {
                    proxyProperties.setProperty("http.proxyPassword", CmdLineGlobalObject.proxyPassword);
                    proxyProperties.setProperty("https.proxyPassword", CmdLineGlobalObject.proxyPassword);
                }
                proxyProperties.setProperty("https.proxySet", "true");
                proxyProperties.setProperty("https.proxyHost", CmdLineGlobalObject.proxyHost);
                proxyProperties.setProperty("https.proxyPort", CmdLineGlobalObject.proxyPort);
                ProxyManager proxyManager = ProxyManager.getInstance();
                proxyManager.loadProxyProperties(proxyProperties);
            }
        }
    }

    private String findEntry(String tag, String id) {
        String result = null;
        ElementFilter filter = new ElementFilter(tag);
        Iterator theIter = this.document.getDescendants((Filter)filter);
        while (theIter.hasNext()) {
            try {
                Element element = (Element)theIter.next();
                if (id != null) {
                    result = element.getAttributeValue(id);
                    break;
                }
                result = element.getText();
                break;
            }
            catch (NullPointerException npe) {
                LOG.severe(npe.toString());
                LOG.severe(CommonUtil.getStackTrace((Throwable)npe));
            }
        }
        return result;
    }

    boolean autoregConsumer() {
        if (CmdLineGlobalObject.proxyAuth != null) {
            if (CmdLineGlobalObject.proxyAuth.equals("no")) {
                try {
                    NetworkProxyCacaoAdapter.setProxy((boolean)true, (String)CmdLineGlobalObject.proxyHost, (String)CmdLineGlobalObject.proxyPort, (boolean)true, (String)CmdLineGlobalObject.proxyUsername, (String)CmdLineGlobalObject.proxyPassword);
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error obtaining Cacao network proxy information");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return false;
                }
            }
        }
        String offeringName = "";
        if (CmdLineGlobalObject.offeringType.equals("solaris")) {
            offeringName = "Register the Solaris software without choosing an update option";
        } else if (CmdLineGlobalObject.offeringType.equals("swup")) {
            offeringName = "Use Sun Update Manager and Sun Update Connection to manage updates";
        }
        try {
            OfferingCacaoAdapter.activate((String)offeringName, null);
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("Error in SCN/Cacao offering activation");
            LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
            return false;
        }
        if (CmdLineGlobalObject.companyToken == null) {
            LOG.severe("Error no registration token in response, cannot autoreg");
            return false;
        }
        try {
            String t = CmdLineGlobalObject.companyToken;
            LOG.info("ClientLoginCacaoAdapter.setRegistrationToken= " + t);
            ClientLoginCacaoAdapter.setRegistrationToken((String)t);
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("set registration token failed, cannot autoreg");
            return false;
        }
        if (CmdLineGlobalObject.offeringType.equals("swup")) {
            if (CmdLineGlobalObject.portalEnabled.equals("true")) {
                try {
                    SWUPOMCacaoAdapter.setSWUPPortalEnabled((boolean)true);
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in SWOM/Cacao SetSWUPportalEnable to true");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return false;
                }
                try {
                    OfferingCacaoAdapter.activate((String)"Register the Solaris software without choosing an update option", null);
                    String hostname = PROMCacaoAdapter.getHostName();
                    OfferingCacaoAdapter.activate((String)"Use Sun Update Manager and Sun Update Connection to manage updates", null);
                    SWUPOMCacaoAdapter.setSystemDisplayName((String)hostname);
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in SWOM/Cacao setSystemDisplayName");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return false;
                }
                try {
                    SWUPOMCacaoAdapter.setSubscriptionKey((String)CmdLineGlobalObject.subscriptionKey);
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in SWOM/Cacao SetSubsriptionKey");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return false;
                }
            }
            try {
                SWUPOMCacaoAdapter.setSWUPPortalEnabled((boolean)false);
            }
            catch (CacaoAdapterException caEx) {
                LOG.severe("Error in SWOM/Cacao SetSWUPportalEnable to false");
                LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                return false;
            }
            try {
                SWUPOMCacaoAdapter.setSystemDisplayName((String)"");
            }
            catch (CacaoAdapterException caEx) {
                LOG.severe("Error in SWOM/Cacao setSystemDisplayName to null");
                LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                return false;
            }
            try {
                SWUPOMCacaoAdapter.setSubscriptionKey((String)CmdLineGlobalObject.subscriptionKey);
            }
            catch (CacaoAdapterException caEx) {
                LOG.severe("Error in SWOM/Cacao SetSubsriptionKey to null");
                LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                return false;
            }
            if (CmdLineGlobalObject.lps.length() > 0) {
                try {
                    SWUPOMCacaoAdapter.setLPSURL((String)CmdLineGlobalObject.lps);
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in SWOM/Cacao SetSubsriptionKey to null");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return false;
                }
            }
            int swupomregisterSystemResult = 0;
            try {
                LOG.info("invoke SWUPOMCacaoAdapter.registerSystem()");
                swupomregisterSystemResult = SWUPOMCacaoAdapter.registerSystem();
            }
            catch (CacaoAdapterException caEx) {
                LOG.severe("Error in SWUPOM/Cacao register system");
                LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                return false;
            }
            if (swupomregisterSystemResult != 0) {
                LOG.info("failed registerSystem()");
                return false;
            }
        } else if (CmdLineGlobalObject.offeringType.equals("solaris")) {
            int promregisterSystemResult = 0;
            try {
                LOG.info("invoke PROMCacaoAdapter.registerSystem()");
                promregisterSystemResult = PROMCacaoAdapter.registerSystem();
            }
            catch (CacaoAdapterException caEx) {
                LOG.severe("Error in PROM/Cacao register system");
                LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                return false;
            }
            if (promregisterSystemResult != 0) {
                LOG.info("failed registerSystem()");
                return false;
            }
        }
        return true;
    }

    private Document registerAsset(String token, String offeringType) {
        Document result = null;
        try {
            Class<?> c = Class.forName("com.sun.cns.basicreg.adapter.AssetAdapter");
            Object[] initArgs = new Object[]{null};
            Constructor<?> cons = c.getConstructor(Document.class);
            Object obj = cons.newInstance(initArgs);
            initArgs = new Object[]{token, offeringType};
            Method registerAsset = c.getMethod("autoRegisterXMLAsset", String.class, String.class);
            result = (Document)registerAsset.invoke(obj, initArgs);
        }
        catch (Exception e) {
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
        return result;
    }

    private void printRegistrationProfile() {
        if (CmdLineGlobalObject.companyToken != null) {
            LOG.info("token = " + CmdLineGlobalObject.companyToken);
        }
        if (CmdLineGlobalObject.offeringType != null) {
            LOG.info("offeringType =" + CmdLineGlobalObject.offeringType);
        }
        if (CmdLineGlobalObject.portalEnabled != null) {
            LOG.info("portalEnabled =" + CmdLineGlobalObject.portalEnabled);
        }
        if (CmdLineGlobalObject.lps != null) {
            LOG.info("lps =" + CmdLineGlobalObject.lps);
        }
        if (CmdLineGlobalObject.proxyAuth != null) {
            LOG.info("proxyAuth = " + CmdLineGlobalObject.proxyAuth);
        }
        if (CmdLineGlobalObject.proxyHost != null) {
            LOG.info("proxyHost = " + CmdLineGlobalObject.proxyHost);
        }
        if (CmdLineGlobalObject.proxyPort != null) {
            LOG.info("proxyPort = " + CmdLineGlobalObject.proxyPort);
        }
        if (CmdLineGlobalObject.proxyUsername != null) {
            LOG.info("proxyUsername = " + CmdLineGlobalObject.proxyUsername);
        }
        if (CmdLineGlobalObject.proxyPassword != null) {
            LOG.info("proxyPassword = **** ");
        }
        if (CmdLineGlobalObject.subscriptionKey != null) {
            if (CmdLineGlobalObject.outputFile != null) {
                LOG.info("outputfile = " + CmdLineGlobalObject.outputFile);
            }
        }
    }

    private Response constructResponse(Document theDocument) {
        Response response = null;
        ArrayList<ResponseError> errorList = new ArrayList<ResponseError>();
        String result = "";
        ElementFilter filter = new ElementFilter("Response");
        Iterator theIter = theDocument.getDescendants((Filter)filter);
        while (theIter.hasNext()) {
            try {
                Element element = (Element)theIter.next();
                String type = element.getAttributeValue("type");
                String text = element.getText();
                response = new Response(text, type);
                ElementFilter errorFilter = new ElementFilter("Error");
                Iterator theErrorIter = theDocument.getDescendants((Filter)errorFilter);
                while (theErrorIter.hasNext()) {
                    try {
                        Element elementError = (Element)theErrorIter.next();
                        ResponseError responseError = new ResponseError(elementError.getText(), elementError.getAttributeValue("type"), elementError.getAttributeValue("code"), elementError.getAttributeValue("severity"));
                        errorList.add(responseError);
                    }
                    catch (NullPointerException npe) {
                        LOG.severe(CommonUtil.getStackTrace((Throwable)npe));
                    }
                }
                response.setErrorList(errorList);
            }
            catch (NullPointerException npe) {
                LOG.severe(CommonUtil.getStackTrace((Throwable)npe));
            }
        }
        return response;
    }

    public static String findEntry(Document theDocument, String inString) {
        String result = "";
        String WIDGET = "widget";
        String ID = "id";
        String RESPONSE = "response";
        ElementFilter filter = new ElementFilter(WIDGET);
        Iterator theIter = theDocument.getDescendants((Filter)filter);
        while (theIter.hasNext()) {
            try {
                String test;
                Element element = (Element)theIter.next();
                String str = element.getAttributeValue(ID);
                if (!str.equals(inString)) continue;
                result = test = element.getChildText(RESPONSE);
                break;
            }
            catch (NullPointerException npe) {
            }
        }
        return result;
    }
}

