/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.cli;

import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.JumpWidget;
import com.sun.cns.basicreg.wizard.LinkWidget;
import com.sun.cns.basicreg.wizard.ReflectionWidget;
import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.WidgetType;
import com.sun.cns.basicreg.wizard.Wizard;
import com.sun.cns.basicreg.wizard.cli.CmdLineHiddenWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineJumpWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineLinkWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineMessageWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineReflectionWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineTextIconLabelWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineWizard;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class CmdLineForm
implements Form {
    private Wizard wizard;
    private List widgets = new ArrayList();
    private String title;
    private boolean reLoad = false;
    private boolean popup = false;
    private boolean modal = false;
    private boolean start = false;
    private boolean finish = false;
    private boolean confirm = false;
    private boolean navigator = true;
    private String formIdentifier;
    private String backIdentifier;
    private String nextIdentifier;
    private String initialFocusWidgetIdentifier;
    private String outForms;
    private String outCall;
    private String setVarList = null;
    private boolean isLayoutDynamic = false;
    private boolean isProcessed = false;
    private static final Logger LOG = Logger.getLogger(CmdLineForm.class.getName());

    public CmdLineForm(Wizard wizard, String title, String reLoad, String popup, String modal, String formIdentifier, String start, String finish, String confirm, String navigator, String backIdentifier, String nextIdentifier, String initialFocusWidgetIdentifier, String outCall, String outForms, String setVarList, String reLayout) {
        this.wizard = wizard;
        this.title = title;
        this.reLoad = reLoad != null && reLoad.equalsIgnoreCase("yes");
        this.popup = popup != null && popup.equalsIgnoreCase("yes");
        this.modal = modal != null && modal.equalsIgnoreCase("yes");
        this.start = start != null && start.equalsIgnoreCase("yes");
        this.finish = finish != null && finish.equalsIgnoreCase("yes");
        this.confirm = confirm != null && confirm.equalsIgnoreCase("yes");
        this.navigator = navigator == null || navigator.equalsIgnoreCase("yes");
        this.formIdentifier = formIdentifier;
        this.backIdentifier = backIdentifier;
        this.nextIdentifier = nextIdentifier;
        this.initialFocusWidgetIdentifier = initialFocusWidgetIdentifier;
        this.outCall = outCall;
        this.outForms = outForms;
        this.setVarList = setVarList;
        this.isLayoutDynamic = reLayout != null && reLayout.equalsIgnoreCase("yes");
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public boolean isReLoad() {
        return this.reLoad;
    }

    public void setReLoad(boolean reLoad) {
        this.reLoad = reLoad;
    }

    public boolean getIsLayoutDynamic() {
        return this.isLayoutDynamic;
    }

    public boolean isProcessed() {
        return this.isProcessed;
    }

    public void setProcessed(boolean value) {
        this.isProcessed = value;
    }

    public boolean isPopup() {
        return this.popup;
    }

    public boolean isModal() {
        return this.modal;
    }

    public boolean isStart() {
        return this.start;
    }

    public boolean isFinish() {
        return this.finish;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public boolean isNavigator() {
        return this.navigator;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public List getWidgets() {
        return this.widgets;
    }

    public void addWidget(Widget widget) {
        if (widget != null) {
            WidgetType type = widget.getType();
            String text = widget.getText();
            boolean exists = false;
            for (Widget existingWidget : this.widgets) {
                if (widget.getType() == WidgetType.REFLECTION || !widget.equals(existingWidget)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.widgets.add(widget);
            }
        }
    }

    public Widget getWidgetById(String widgetId) {
        if (widgetId == null) {
            return null;
        }
        for (Widget aWidget : this.widgets) {
            String aWidgetId;
            if (aWidget instanceof ReflectionWidget || (aWidgetId = aWidget.getId()) == null || !aWidgetId.equals(widgetId)) continue;
            return aWidget;
        }
        return null;
    }

    public String getJumpToFormIdentifier(int widgetIndex) {
        int index = 1;
        for (Widget widget : this.widgets) {
            if (widget instanceof CmdLineJumpWidget && index == widgetIndex) {
                String formId = ((JumpWidget)((Object)widget)).getJumpToFormIdentifier();
                return formId;
            }
            if (widget instanceof CmdLineMessageWidget || widget instanceof CmdLineHiddenWidget || widget instanceof CmdLineReflectionWidget || widget instanceof CmdLineTextIconLabelWidget) continue;
            ++index;
        }
        return null;
    }

    public String getURL(int widgetIndex) {
        int index = 1;
        for (Widget widget : this.widgets) {
            if (widget instanceof CmdLineLinkWidget && index == widgetIndex) {
                String url = ((LinkWidget)((Object)widget)).getURL();
                return url;
            }
            if (widget instanceof CmdLineMessageWidget || widget instanceof CmdLineHiddenWidget || widget instanceof CmdLineReflectionWidget || widget instanceof CmdLineTextIconLabelWidget) continue;
            ++index;
        }
        return null;
    }

    public boolean getEndsWizard(int widgetIndex) {
        int index = 1;
        for (Widget widget : this.widgets) {
            if (widget instanceof CmdLineLinkWidget && index == widgetIndex) {
                return ((LinkWidget)((Object)widget)).getEndsWizard();
            }
            if (widget instanceof CmdLineMessageWidget || widget instanceof CmdLineHiddenWidget || widget instanceof CmdLineReflectionWidget || widget instanceof CmdLineTextIconLabelWidget) continue;
            ++index;
        }
        return false;
    }

    public void setFormIdentifier(String value) {
        this.formIdentifier = value;
    }

    public String getFormIdentifier() {
        return this.formIdentifier;
    }

    public String getBackIdentifier() {
        return this.backIdentifier;
    }

    public void setBackIdentifier(String backIdentifier) {
        this.backIdentifier = backIdentifier;
    }

    public String getNextIdentifier() {
        return this.nextIdentifier;
    }

    public void setNextIdentifier(String nextIdentifier) {
        this.nextIdentifier = nextIdentifier;
    }

    public String getInitialFocusWidgetIdentifier() {
        return this.initialFocusWidgetIdentifier;
    }

    public String getOutForms() {
        return this.outForms;
    }

    public ArrayList getActualOutForms() {
        String outFormsData = this.getOutForms();
        LOG.info("Literal outForms: " + outFormsData);
        ArrayList outForms = CmdLineWizard.getListOfActualValues(outFormsData);
        LOG.info("Actual outForms: ");
        for (int i = 0; i < outForms.size(); ++i) {
            LOG.info((String)outForms.get(i) + (i < outForms.size() - 1 ? "," : "\n"));
        }
        return outForms;
    }

    public String getOutCall() {
        return this.outCall;
    }

    public ArrayList getActualOutCalls() {
        String outCallsData = this.getOutCall();
        LOG.info("Literal outCalls: " + outCallsData);
        ArrayList outCalls = CmdLineWizard.getListOfActualValues(outCallsData);
        LOG.info("Actual outCalls: ");
        for (int i = 0; i < outCalls.size(); ++i) {
            LOG.info((String)outCalls.get(i) + (i < outCalls.size() - 1 ? "," : "\n"));
        }
        return outCalls;
    }

    public String getSetVarList() {
        return this.setVarList;
    }
}

