/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.cli;

import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.SelectWidget;
import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.WidgetType;
import com.sun.cns.basicreg.wizard.cli.CmdLineWidget;
import java.util.logging.Logger;

public class CmdLineSelectWidget
extends CmdLineWidget
implements Widget,
SelectWidget {
    private static final Logger LOG = Logger.getLogger(CmdLineSelectWidget.class.getName());
    protected boolean selected;
    private String selectType;
    private String groupId;
    private static final int numberOfTimes = 4;
    private boolean onClickNext;
    private String slaveId;
    private String slaveValue;
    private String setVarListIfSelected = null;
    private String setVarListIfDeselected = null;
    private boolean continueCheck = false;

    public CmdLineSelectWidget() {
        this.text = "";
        this.selected = false;
        this.onClickNext = false;
    }

    public CmdLineSelectWidget(String text) {
        this.text = text;
        this.selected = false;
        this.onClickNext = false;
    }

    public CmdLineSelectWidget(Form form, String text, String reload, String id, String required, String editable, String validPattern, String patternError, String validMatch, String matchError, String note, String fontSize, String fontStyle, String newRow, String leftAt, String rightTo, String fontColor, String slaveId, String slaveValue, String continueCheck, String selectType, String groupId, String selected, String setVarListIfSelected, String setVarListIfDeselected, String toolTip, String s508Name, String s508Desc, String mnemonic, String isDisplayed) {
        this.form = form;
        this.text = text;
        this.setReload(reload);
        this.setRequired(required);
        this.setEditable(editable);
        this.validPattern = validPattern;
        this.patternError = patternError;
        this.validMatch = validMatch;
        this.matchError = matchError;
        this.note = note;
        this.setFontSize(fontSize);
        this.fontStyle = fontStyle;
        this.fontColor = fontColor;
        this.id = id;
        this.setNewRow(newRow);
        this.setLeftAt(leftAt);
        this.setRightTo(rightTo);
        this.toolTip = toolTip;
        this.s508Name = s508Name;
        this.s508Desc = s508Desc;
        this.mnemonic = mnemonic;
        this.isDisplayed = isDisplayed;
        this.slaveId = slaveId;
        this.slaveValue = slaveValue;
        boolean bl = this.continueCheck = continueCheck != null && continueCheck.equalsIgnoreCase("yes");
        this.selectType = selectType != null ? (selectType.equalsIgnoreCase("radio") ? "radio" : "check") : "check";
        this.groupId = groupId;
        this.selected = selected != null && selected.equalsIgnoreCase("yes");
        this.setVarListIfSelected = setVarListIfSelected;
        this.setVarListIfDeselected = setVarListIfDeselected;
    }

    public WidgetType getType() {
        return WidgetType.SELECT;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getSelectType() {
        return this.selectType;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getSlaveId() {
        return this.slaveId;
    }

    public String getSlaveValue() {
        if (this.slaveValue == null) {
            return null;
        }
        int widFlagIndex = this.slaveValue.indexOf("$WID:");
        if (widFlagIndex == -1) {
            return this.slaveValue;
        }
        if (widFlagIndex + "$WID:".length() >= this.slaveValue.length()) {
            return null;
        }
        String widgetId = this.slaveValue.substring(widFlagIndex + "$WID:".length());
        Widget widget = this.form.getWidgetById(widgetId);
        return widget.getText();
    }

    public String getSetVarListIfSelected() {
        return this.setVarListIfSelected;
    }

    public String getSetVarListIfDeselected() {
        return this.setVarListIfDeselected;
    }

    public boolean isContinueCheck() {
        return this.continueCheck;
    }

    public void draw() {
        this.draw(4);
    }

    public void draw(int times) {
        StringBuffer output = new StringBuffer();
        output = this.repeat(output, times);
        if (this.required) {
            output.append("*");
        }
        output.append("[");
        if (this.isSelected()) {
            output.append("x");
        } else {
            output.append(" ");
        }
        output.append("]");
        output.append(" ");
        output.append(this.getText());
        output.append("\n");
        System.out.print(output.toString());
    }

    private StringBuffer repeat(StringBuffer output, int times) {
        for (int i = 0; i < times; ++i) {
            output.append(" ");
        }
        return output;
    }

    public String getResponse() {
        return this.isSelected() ? "true" : "false";
    }

    public void setResponse(String response) {
        this.setSelected(response.equalsIgnoreCase("true"));
    }
}

