/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.cli;

import com.sun.cns.basicreg.cacao.CacaoAdapterException;
import com.sun.cns.basicreg.cacao.ClientLoginCacaoAdapter;
import com.sun.cns.basicreg.cacao.NetworkProxyCacaoAdapter;
import com.sun.cns.basicreg.cacao.OfferingCacaoAdapter;
import com.sun.cns.basicreg.cacao.PROMCacaoAdapter;
import com.sun.cns.basicreg.cacao.SWUPOMCacaoAdapter;
import com.sun.cns.basicreg.common.Base64;
import com.sun.cns.basicreg.common.CmdLineGlobalObject;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.common.XOR;
import com.sun.cns.basicreg.wizard.Collector;
import com.sun.cns.basicreg.wizard.ComboBoxWidget;
import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.HTMLWidget;
import com.sun.cns.basicreg.wizard.RadioBoxWidget;
import com.sun.cns.basicreg.wizard.ReflectionWidget;
import com.sun.cns.basicreg.wizard.ResponseWidget;
import com.sun.cns.basicreg.wizard.SelectWidget;
import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.WidgetType;
import com.sun.cns.basicreg.wizard.Wizard;
import com.sun.cns.basicreg.wizard.cli.AutoReg;
import com.sun.cns.basicreg.wizard.cli.CmdLineComboBoxWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineController;
import com.sun.cns.basicreg.wizard.cli.CmdLineFieldWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineForm;
import com.sun.cns.basicreg.wizard.cli.CmdLineHTMLWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineHiddenWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineInformationWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineJumpWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineLinkWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineMessageWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLinePasswordWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineRadioBoxWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineReflectionWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineSelectWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineTextIconLabelWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineUnknownWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineWidget;
import com.sun.cns.basicreg.wizard.util.DocOutputter;
import com.sun.cns.basicreg.wizard.util.I18N;
import com.sun.cns.basicreg.wizard.util.MessageTable;
import com.sun.cns.basicreg.wizard.util.Response;
import com.sun.cns.basicreg.wizard.util.ResponseError;
import com.sun.cns.basicreg.wizard.util.VariableMap;
import com.sun.cns.basicreg.wizard.util.XMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.transform.XSLTransformer;

public class CmdLineWizard
implements Wizard {
    private String identifier;
    private String outputFile;
    private ArrayList forms;
    private int index = -1;
    private String cmdLineArgument;
    private String title;
    private ArrayList outForms;
    private ArrayList outCalls;
    private boolean outAsset = false;
    private String assetId;
    private boolean requiredToWait = false;
    private boolean waitForOtherJobCompleted = false;
    private CmdLineGlobalObject globalObject = null;
    private boolean formReload = false;
    private static final Logger LOG = Logger.getLogger(CmdLineWizard.class.getName());
    String location = null;
    boolean dateTimeStampBoolean = false;
    String fileNamePrefix = null;
    String fileNameSuffix = null;
    String filePattern = null;
    String dateTimeStamp = null;
    boolean forceToReload = false;
    private boolean AssetRegistrationFailed = false;

    public CmdLineWizard(String identifier) {
        this.identifier = identifier;
        this.cmdLineArgument = "profile";
        this.initialize();
    }

    public CmdLineWizard(String identifier, String cmdLineArgument) {
        this.identifier = identifier;
        this.cmdLineArgument = cmdLineArgument;
        this.initialize();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean reloadFormIfNeeded(int indexForm) {
        LOG.info("RELOAD FORM " + indexForm + " ?");
        LOG.info("FORM SIZE = " + this.forms.size());
        Form form = null;
        if (!this.forms.isEmpty() && indexForm >= 0 && indexForm <= this.forms.size() - 1 && (form = (Form)this.forms.get(indexForm)).isReLoad()) {
            LOG.info("YES - RELOAD FORM  " + indexForm);
            this.fillInRequestedForm(form);
            CmdLineGlobalObject.forms.put(this.getFormIdentifier(indexForm), new Boolean(false));
            form.setReLoad(false);
            return true;
        }
        LOG.info("NO - RELOAD FORM " + indexForm);
        return false;
    }

    public boolean isFirstForm() {
        boolean result = false;
        if (!this.forms.isEmpty() && this.index == 0) {
            result = true;
        }
        return result;
    }

    public boolean isLastForm() {
        boolean result = false;
        if (!this.forms.isEmpty() && this.index == this.forms.size() - 1) {
            result = true;
        }
        return result;
    }

    public boolean isLastForm(Form form) {
        Form lastForm;
        boolean result = false;
        if (!this.forms.isEmpty() && (lastForm = (Form)this.forms.get(this.forms.size() - 1)).getFormIdentifier().equals(form.getFormIdentifier())) {
            result = true;
        }
        return result;
    }

    public Form getFirstForm() {
        Form firstForm = null;
        if (!this.forms.isEmpty()) {
            firstForm = (Form)this.forms.get(0);
            this.index = 0;
            this.processReflectionWidgets(firstForm, this.index);
            firstForm.setProcessed(true);
        }
        return firstForm;
    }

    public Form getLastForm() {
        Form lastForm = null;
        int lastIndex = this.forms.size() - 1;
        if (!this.forms.isEmpty()) {
            lastForm = (Form)this.forms.get(lastIndex);
            this.index = lastIndex;
            this.processReflectionWidgets(lastForm, this.index);
            lastForm.setProcessed(true);
        }
        return lastForm;
    }

    public Form getPreviousForm() {
        Form previousForm = null;
        int previousFormIndex = this.index - 1;
        if (!this.forms.isEmpty()) {
            if (previousFormIndex > -1) {
                previousForm = (Form)this.forms.get(previousFormIndex);
                this.index = previousFormIndex;
            } else {
                previousForm = (Form)this.forms.get(this.index);
            }
            this.processReflectionWidgets(previousForm, this.index);
            previousForm.setProcessed(true);
        }
        return previousForm;
    }

    public Form getCurrentForm() {
        Form currentForm = null;
        if (!this.forms.isEmpty()) {
            currentForm = (Form)this.forms.get(this.index);
            this.processReflectionWidgets(currentForm, this.index);
            currentForm.setProcessed(true);
        }
        return currentForm;
    }

    public Form getNextForm() {
        Form nextForm = null;
        int nextFormIndex = this.index + 1;
        if (!this.forms.isEmpty()) {
            if (nextFormIndex < this.forms.size()) {
                nextForm = (Form)this.forms.get(nextFormIndex);
                this.index = nextFormIndex;
                LOG.info("index = " + this.index);
                this.processReflectionWidgets(nextForm, this.index);
                nextForm.setProcessed(true);
            } else {
                nextForm = (Form)this.forms.get(this.index);
            }
        }
        if (this.forceToReload) {
            this.forceToReload = false;
            Form form = (Form)this.forms.get(0);
            this.fillInRequestedForm(form);
            CmdLineGlobalObject.forms.put(this.getFormIdentifier(0), new Boolean(false));
            form.setReLoad(false);
        }
        return nextForm;
    }

    public Form getNextFormForCLI() {
        Form nextForm = null;
        int nextFormIndex = this.index + 1;
        if (!this.forms.isEmpty()) {
            if (nextFormIndex < this.forms.size()) {
                nextForm = (Form)this.forms.get(nextFormIndex);
                this.index = nextFormIndex;
                this.processReflectionWidgets(nextForm, this.index);
                nextForm.setProcessed(true);
                if (nextForm.isReLoad() && nextForm.isProcessed()) {
                    this.reloadFormIfNeeded(this.index);
                }
            } else {
                nextForm = (Form)this.forms.get(this.index);
            }
        }
        return nextForm;
    }

    public Form getForm(String formIdentifier) {
        Form nextForm2 = null;
        int nextFormIndex = 0;
        for (Form nextForm2 : this.forms) {
            String formId = nextForm2.getFormIdentifier();
            if (formId != null && formId.equalsIgnoreCase(formIdentifier)) {
                this.index = nextFormIndex;
                this.processReflectionWidgets(nextForm2, this.index);
                if (nextForm2.isReLoad() && nextForm2.isProcessed()) {
                    this.reloadFormIfNeeded(this.index);
                }
                nextForm2.setProcessed(true);
                return nextForm2;
            }
            ++nextFormIndex;
        }
        return null;
    }

    public Form getFormById(String formId) {
        if (formId == null) {
            return null;
        }
        for (Form aForm : this.forms) {
            String aFormId = aForm.getFormIdentifier();
            if (aFormId == null || !aFormId.equals(formId)) continue;
            return aForm;
        }
        return null;
    }

    public String getFormIdentifier(int formIndex) {
        int nextFormIndex = 0;
        for (Form aForm : this.forms) {
            String aFormId = aForm.getFormIdentifier();
            if (aFormId != null && nextFormIndex == formIndex) {
                return aFormId;
            }
            ++nextFormIndex;
        }
        return null;
    }

    public void setFormIndex(int index) {
        this.index = index;
    }

    public int getFormIndex(String formIdentifier) {
        Form nextForm2 = null;
        int nextFormIndex = 0;
        for (Form nextForm2 : this.forms) {
            String formId = nextForm2.getFormIdentifier();
            if (formId != null && formId.equalsIgnoreCase(formIdentifier)) {
                return nextFormIndex;
            }
            ++nextFormIndex;
        }
        LOG.severe("ERROR:  unknown form identifier: " + formIdentifier);
        return -1;
    }

    private void fillInForm(Form form) {
        this.fillInRequestedForm(form);
    }

    private void fillInRequestedForm(Form form) {
        LOG.info("fillInRequestedForm: " + form.getFormIdentifier());
        List widgets = form.getWidgets();
        for (Widget widget : widgets) {
            if (!(widget instanceof ReflectionWidget) || !widget.isReload()) continue;
            Object result = null;
            ReflectionWidget reflectWidget = (ReflectionWidget)((Object)widget);
            try {
                Class<?> clazz = Class.forName(reflectWidget.getClassName());
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                Object object = constructor.newInstance(new Object[0]);
                Method method = clazz.getMethod(reflectWidget.getMethodName(), new Class[0]);
                result = method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                LOG.severe(e.getMessage());
            }
            String content = null;
            if (result == null) continue;
            if (result instanceof List) {
                List results = (List)result;
                Iterator j = results.iterator();
                while (j.hasNext()) {
                    StringReader stringReader;
                    content = j.next().toString();
                    LOG.finest("content = " + content);
                    this.reLoadWidget(form, this.createWidget(reflectWidget.getTargetType(), content, widget.getId(), widget.getParentId(), widget.isAsset(), widget.isReload(), widget.getHTMLFormId(), widget.getLimitedHTMLFormId(), widget.getSolarisHTMLFormId()));
                    if (widget.getHTMLFormId() != null) {
                        stringReader = new StringReader(content);
                        this.convertXML2HTML(stringReader, widget.getHTMLFormId(), "F");
                    }
                    if (widget.getLimitedHTMLFormId() != null) {
                        stringReader = new StringReader(content);
                        this.convertXML2HTML(stringReader, widget.getLimitedHTMLFormId(), "P");
                    }
                    if (widget.getSolarisHTMLFormId() == null) continue;
                    stringReader = new StringReader(content);
                    this.convertXML2HTML(stringReader, widget.getSolarisHTMLFormId(), "S");
                }
                continue;
            }
            if (!(result instanceof Object)) continue;
            content = result.toString();
            LOG.finest("jaxta content = " + result.toString());
            this.reLoadWidget(form, this.createWidget(reflectWidget.getTargetType(), content, widget.getId(), widget.getParentId(), widget.isAsset(), widget.isReload(), widget.getHTMLFormId(), widget.getLimitedHTMLFormId(), widget.getSolarisHTMLFormId()));
        }
    }

    private void reLoadWidget(Form form, Widget newWidget) {
        LOG.finest("==== inside reloadwidget =====");
        LOG.finest("==== new widget id =====" + newWidget.getId());
        LOG.finest("==== new widget text =====" + newWidget.getText());
        List widgets = form.getWidgets();
        for (Widget widget : widgets) {
            LOG.finest("==== widget id =====" + widget.getId());
            if (!widget.isReload() || widget.getId() == null || !widget.getId().equals(newWidget.getId())) continue;
            widget.setText(newWidget.getText());
            LOG.finest("replacing widget with = " + newWidget.getText());
        }
    }

    private void fillInLastForm() {
        StringBuffer information = new StringBuffer();
        for (int index = 0; index < this.forms.size(); ++index) {
            if (index >= this.forms.size() - 1) continue;
            this.printForm((Form)this.forms.get(index), information);
        }
        this.printLastForm(information.toString());
    }

    private void printForm(Form form, StringBuffer textBuffer) {
        this.repeat("-", 80, textBuffer);
        textBuffer.append(form.getTitle() + "\n");
        textBuffer.append("\n");
        textBuffer.append("\n");
        List widgets = form.getWidgets();
        String widgetText = "";
        int index = 1;
        int printIndex = 1;
        for (Widget widget : widgets) {
            if (widget instanceof ResponseWidget) {
                textBuffer.append(printIndex++ + ". " + widget.getText() + ": " + ((ResponseWidget)((Object)widget)).getResponse() + "\n");
                ++index;
                continue;
            }
            if (widget instanceof SelectWidget) {
                if (((SelectWidget)widget).isSelected()) {
                    textBuffer.append(printIndex++ + ". " + ((CmdLineSelectWidget)widget).getText() + "\n");
                }
                ++index;
                continue;
            }
            if (widget instanceof HTMLWidget) {
                ++index;
                continue;
            }
            if (widget instanceof RadioBoxWidget || widget instanceof ComboBoxWidget) {
                List widgetsBox = null;
                if (widget instanceof RadioBoxWidget) {
                    textBuffer.append(printIndex++ + ". " + ((CmdLineRadioBoxWidget)widget).getTitle());
                    widgetsBox = ((CmdLineRadioBoxWidget)widget).getWidgets();
                } else if (widget instanceof ComboBoxWidget) {
                    textBuffer.append(printIndex++ + ". " + ((CmdLineComboBoxWidget)widget).getTitle());
                    widgetsBox = ((CmdLineComboBoxWidget)widget).getWidgets();
                }
                textBuffer.append("\n");
                boolean indexBox = true;
                for (Widget widgetInBox : widgetsBox) {
                    if (!((SelectWidget)widgetInBox).isSelected()) continue;
                    widgetText = widgetInBox.getText() + " ";
                    textBuffer.append(widgetText + "\n");
                }
                widgetText = "";
                ++index;
                continue;
            }
            ++index;
        }
        textBuffer.append("\n");
        textBuffer.append("\n");
    }

    private void printLastForm(String text) {
        List widgets = this.getLastForm().getWidgets();
        for (Widget widget : widgets) {
            if (!(widget instanceof CmdLineInformationWidget)) continue;
            ((CmdLineInformationWidget)widget).setText(text);
        }
    }

    private void repeat(String text, int times, StringBuffer textBuffer) {
        for (int i = 0; i < times; ++i) {
            textBuffer.append(text);
        }
        textBuffer.append("\n");
    }

    public Document run() {
        CmdLineController controller = new CmdLineController(this);
        return controller.run();
    }

    public ResponseError output(Form form) {
        this.outForms = form.getActualOutForms();
        this.outCalls = form.getActualOutCalls();
        if (this.outForms != null && this.outForms.size() > 0 && this.outCalls != null && this.outCalls.size() > 0) {
            Document wizardDocument = this.output();
            for (int index = 0; index < this.outCalls.size(); ++index) {
                Document theDocument;
                Response response;
                ArrayList errorList;
                Form localForm;
                String outCall = (String)this.outCalls.get(index);
                LOG.info("\nPerform outCall: " + outCall);
                ResponseError responseError = this.outCall(outCall, wizardDocument);
                if ((outCall.equalsIgnoreCase("1") || outCall.equalsIgnoreCase("2")) && (responseError == null || responseError.getCode().equals("0")) && (localForm = this.getFormById("local")) != null && this.isInOutForms(localForm) && !(errorList = (response = this.constructResponse(theDocument = this.storeLPS(wizardDocument))).getErrorList()).isEmpty()) {
                    responseError = (ResponseError)errorList.get(0);
                }
                if (responseError == null || responseError.getCode().equals("0")) continue;
                return responseError;
            }
            return new ResponseError(null, null, "0", null);
        }
        return new ResponseError(null, null, "0", null);
    }

    private Document output() {
        Document wizardDocument = this.buildWizardDocument();
        if (wizardDocument != null) {
            // empty if block
        }
        return wizardDocument;
    }

    public ResponseError outCall(String outCall, Document wizardDocument) {
        Document theDocument = null;
        String result = null;
        ResponseError responseError = null;
        String code = null;
        String severity = "";
        String token = null;
        if (outCall.equalsIgnoreCase("1")) {
            String groupYes = AutoReg.findEntry(wizardDocument, "groupLogin");
            if (groupYes != null && groupYes.equalsIgnoreCase("true")) {
                LOG.info("Group ID registration NOT YET SUPPORTED - ");
                ResponseError groupTemporaryResponseError = new ResponseError("Group ID Reg TBD", "user", "9998", "F");
                return groupTemporaryResponseError;
            }
            theDocument = this.authenticateUser(wizardDocument);
            Response response = this.constructResponse(theDocument);
            ArrayList errorList = response.getErrorList();
            if (!errorList.isEmpty()) {
                responseError = (ResponseError)errorList.get(0);
                code = responseError.getCode();
                severity = responseError.getSeverity();
            } else if (this.outAsset) {
                token = response.getText();
                LOG.info("token from user management = " + token);
                theDocument = this.registerAsset(wizardDocument, token);
                response = this.constructResponse(theDocument);
                errorList = response.getErrorList();
                if (!errorList.isEmpty()) {
                    responseError = (ResponseError)errorList.get(0);
                    code = responseError.getCode() + "a";
                    severity = responseError.getSeverity();
                } else {
                    this.assetId = response.getText();
                    code = "0";
                    severity = "";
                }
                LOG.info("asset return code = " + code);
                if (code.equals("0")) {
                    this.assetId = response.getText();
                    this.createResponseFile(wizardDocument, token);
                } else if (code != null) {
                    this.assetId = null;
                    result = MessageTable.getCode(code);
                    if (result == null) {
                        code = "9999";
                        severity = "F";
                    } else {
                        code = result;
                    }
                } else {
                    code = "9999";
                    severity = "F";
                    this.assetId = null;
                }
            } else {
                code = "0";
                severity = "";
            }
        } else if (outCall.equalsIgnoreCase("2")) {
            Response response;
            ArrayList errorList = null;
            if (this.AssetRegistrationFailed) {
                theDocument = this.authenticateUser(wizardDocument);
                response = this.constructResponse(theDocument);
                errorList = response.getErrorList();
                if (!errorList.isEmpty()) {
                    theDocument = this.registerUser(wizardDocument);
                    response = this.constructResponse(theDocument);
                    errorList = response.getErrorList();
                }
            } else {
                theDocument = this.registerUser(wizardDocument);
                response = this.constructResponse(theDocument);
                errorList = response.getErrorList();
            }
            if (!errorList.isEmpty()) {
                responseError = (ResponseError)errorList.get(0);
                code = responseError.getCode();
                severity = responseError.getSeverity();
            } else {
                code = "0";
                severity = "";
            }
            LOG.info("user return code = " + code);
            if (code.equals("0")) {
                token = response.getText();
            } else {
                code = MessageTable.getCode(code);
            }
            if (code != null && code.equals("0") && this.outAsset) {
                LOG.info("token from user management = " + token);
                theDocument = this.registerAsset(wizardDocument, token);
                response = this.constructResponse(theDocument);
                errorList = response.getErrorList();
                if (!errorList.isEmpty()) {
                    responseError = (ResponseError)errorList.get(0);
                    code = responseError.getCode();
                    severity = responseError.getSeverity();
                } else {
                    code = "0";
                    severity = "";
                    this.assetId = response.getText();
                }
                LOG.info("asset return code = " + code);
                if (code.equals("0")) {
                    this.assetId = response.getText();
                    this.AssetRegistrationFailed = false;
                    this.createResponseFile(wizardDocument, token);
                } else {
                    this.AssetRegistrationFailed = true;
                    this.assetId = null;
                    result = MessageTable.getCode(code);
                    if (result == null) {
                        code = "9999";
                        severity = "F";
                    } else {
                        code = result;
                    }
                }
            } else if (code == null) {
                code = "9999";
                severity = "F";
            }
        } else if (outCall.equalsIgnoreCase("3")) {
            theDocument = this.storeLPS(wizardDocument);
            Response response = this.constructResponse(theDocument);
            ArrayList errorList = response.getErrorList();
            if (!errorList.isEmpty()) {
                responseError = (ResponseError)errorList.get(0);
                code = responseError.getCode();
                severity = responseError.getSeverity();
            } else {
                code = "0";
                severity = "";
            }
        } else if (outCall.equalsIgnoreCase("4")) {
            theDocument = this.authenticateUser(wizardDocument);
            Response response = this.constructResponse(theDocument);
            ArrayList errorList = response.getErrorList();
            if (!errorList.isEmpty()) {
                responseError = (ResponseError)errorList.get(0);
                code = responseError.getCode();
                severity = responseError.getSeverity();
            } else {
                token = response.getText();
                LOG.info("token from user management = " + token);
                theDocument = this.registerAsset(wizardDocument, token);
                response = this.constructResponse(theDocument);
                errorList = response.getErrorList();
                if (!errorList.isEmpty()) {
                    responseError = (ResponseError)errorList.get(0);
                    code = responseError.getCode() + "a";
                    severity = responseError.getSeverity();
                } else {
                    code = "0";
                    severity = "";
                }
            }
        } else {
            if (outCall.equalsIgnoreCase("110")) {
                int scnAccountLoginResult;
                String userName = null;
                String password = null;
                if (XMLUtils.containsForm(wizardDocument, "sunAccountOne")) {
                    userName = XMLUtils.getWidgetResponse(wizardDocument, "sunAccountOne", "username");
                    password = XMLUtils.getWidgetResponse(wizardDocument, "sunAccountOne", "password");
                } else if (XMLUtils.containsForm(wizardDocument, "enablePortalOne")) {
                    userName = XMLUtils.getWidgetResponse(wizardDocument, "enablePortalOne", "username");
                    password = XMLUtils.getWidgetResponse(wizardDocument, "enablePortalOne", "password");
                } else if (XMLUtils.containsForm(wizardDocument, "subscription1")) {
                    userName = XMLUtils.getWidgetResponse(wizardDocument, "subscription1", "username");
                    password = XMLUtils.getWidgetResponse(wizardDocument, "subscription1", "password");
                }
                LOG.info(" ** username: " + userName);
                try {
                    scnAccountLoginResult = ClientLoginCacaoAdapter.loginAccount((String)userName, (String)password);
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in SCN/Cacao account login");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return new ResponseError("", "system", "10110", "F");
                }
                return this.createLoginResponseError(scnAccountLoginResult, "102");
            }
            if (outCall.equalsIgnoreCase("130")) {
                int scnCreateAccountLoginResult;
                String string;
                String userName = XMLUtils.getWidgetResponse(wizardDocument, "createAccountOne", "username");
                String password = XMLUtils.getWidgetResponse(wizardDocument, "createAccountOne", "password");
                String firstName = XMLUtils.getWidgetResponse(wizardDocument, "createAccountOne", "firstname");
                String middleName = XMLUtils.getWidgetResponse(wizardDocument, "createAccountOne", "middlename");
                String lastName = XMLUtils.getWidgetResponse(wizardDocument, "createAccountOne", "lastname");
                String email = XMLUtils.getWidgetResponse(wizardDocument, "createAccountOne", "email");
                String securityQuestion = XMLUtils.getWidgetResponse(wizardDocument, "createAccountOne", "question");
                String securityAnswer = XMLUtils.getWidgetResponse(wizardDocument, "createAccountOne", "answer");
                String company = XMLUtils.getWidgetResponse(wizardDocument, "createAccountTwo", "companyname");
                String address1 = XMLUtils.getWidgetResponse(wizardDocument, "createAccountTwo", "address1");
                String address2 = XMLUtils.getWidgetResponse(wizardDocument, "createAccountTwo", "address2");
                String address3 = XMLUtils.getWidgetResponse(wizardDocument, "createAccountTwo", "address3");
                String city = XMLUtils.getWidgetResponse(wizardDocument, "createAccountTwo", "city");
                String state = XMLUtils.getWidgetResponse(wizardDocument, "createAccountTwo", "state");
                String zip = XMLUtils.getWidgetResponse(wizardDocument, "createAccountTwo", "zipcode");
                String country = XMLUtils.getWidgetResponse(wizardDocument, "createAccountTwo", "country");
                if (country != null) {
                    Collector.getInstance();
                    string = Collector.findCountryCodeEntry(country);
                } else {
                    string = null;
                }
                String countryCode = string;
                String phone = XMLUtils.getWidgetResponse(wizardDocument, "createAccountTwo", "phonenumber");
                String job = XMLUtils.getWidgetResponse(wizardDocument, "createAccountTwo", "jobtitle");
                if (job == null || job.equals(I18N.JOB_DEFAULT) || job.equals(I18N.JOB_SEPARATOR_ONE) || job.equals(I18N.JOB_SEPARATOR_TWO)) {
                    job = "";
                }
                LOG.info(" ** username: " + userName);
                LOG.info("    first name: " + firstName);
                LOG.info("    middle name: " + middleName);
                LOG.info("    last name: " + lastName);
                LOG.info("    email: " + email);
                LOG.info("    security question: " + securityQuestion);
                LOG.info("    security answer: " + securityAnswer);
                LOG.info("    job: " + job);
                LOG.info("    company: " + company);
                LOG.info("    address 1: " + address1);
                LOG.info("    address 2: " + address2);
                LOG.info("    address 3: " + address3);
                LOG.info("    city: " + city);
                LOG.info("    state: " + state);
                LOG.info("    zip: " + zip);
                LOG.info("    phone: " + phone);
                LOG.info("    country code: " + countryCode);
                try {
                    scnCreateAccountLoginResult = ClientLoginCacaoAdapter.createAccount((String)userName, (String)password, (String)firstName, (String)middleName, (String)lastName, (String)securityQuestion, (String)securityAnswer, (String)company, (String)address1, (String)address2, (String)address3, (String)city, (String)state, (String)zip, (String)countryCode, (String)phone, (String)email, null, (String)job);
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in SCN/Cacao create account");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return new ResponseError("", "system", "10130", "F");
                }
                return this.createLoginResponseError(scnCreateAccountLoginResult, "105");
            }
            if (outCall.equalsIgnoreCase("132")) {
                boolean scnUpdateContactResult;
                String contactSelect = XMLUtils.getWidgetResponse(wizardDocument, "contactselect");
                boolean contactOk = contactSelect != null && contactSelect.equals("true");
                LOG.info(" ** contact ok: " + contactOk);
                try {
                    scnUpdateContactResult = ClientLoginCacaoAdapter.updateContact((boolean)contactOk);
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in SCN/Cacao update contact");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return new ResponseError("", "system", "10132", "F");
                }
                if (scnUpdateContactResult) {
                    return new ResponseError(null, null, "0", null);
                }
                return new ResponseError("", "system", "10132", "F");
            }
            if (outCall.equalsIgnoreCase("134")) {
                boolean scnUpdateLicenseResult;
                String licenseSelect = XMLUtils.getWidgetResponse(wizardDocument, "acceptTOU");
                boolean licenseOk = licenseSelect != null && licenseSelect.equals("true");
                LOG.info(" ** license ok: " + licenseOk);
                try {
                    scnUpdateLicenseResult = ClientLoginCacaoAdapter.updateLicense((boolean)licenseOk);
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in SCN/Cacao update license");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return new ResponseError("", "system", "10134", "F");
                }
                if (scnUpdateLicenseResult) {
                    return new ResponseError(null, null, "0", null);
                }
                return new ResponseError("", "system", "10134", "F");
            }
            if (outCall.equalsIgnoreCase("210")) {
                String offeringName;
                String swupOption = "";
                String localOption = "";
                String solarisOption = "";
                if (XMLUtils.containsForm(wizardDocument, "options")) {
                    CommonUtil.debug();
                    swupOption = XMLUtils.getWidgetResponse(wizardDocument, "options", "regOptionOne");
                    localOption = XMLUtils.getWidgetResponse(wizardDocument, "options", "regOptionTwo");
                    solarisOption = XMLUtils.getWidgetResponse(wizardDocument, "options", "regOptionThree");
                } else if (XMLUtils.containsForm(wizardDocument, "enablePortalOne") || XMLUtils.containsForm(wizardDocument, "subscription1") || XMLUtils.containsForm(wizardDocument, "sunAccountTwo")) {
                    CommonUtil.debug();
                    swupOption = "true";
                } else if (XMLUtils.containsForm(wizardDocument, "local")) {
                    CommonUtil.debug();
                    localOption = "true";
                }
                LOG.info(" ** swup option: " + swupOption);
                LOG.info(" ** local option: " + localOption);
                LOG.info(" ** solaris option: " + solarisOption);
                CmdLineGlobalObject.runModeType = "true".equals(solarisOption) ? "solaris" : "swup";
                if ("true".equals(swupOption)) {
                    offeringName = "Use Sun Update Manager and Sun Update Connection to manage updates";
                } else if ("true".equals(solarisOption)) {
                    offeringName = "Register the Solaris software without choosing an update option";
                } else if ("true".equals(localOption)) {
                    offeringName = "Use Sun Update Manager using a local update source, such as Sun Connection Proxy";
                } else {
                    LOG.severe("Error in SCN/Cacao offering activation");
                    return new ResponseError("", "system", "10210", "F");
                }
                try {
                    if ("true".equals(localOption)) {
                        OfferingCacaoAdapter.myActivate((String)offeringName, null);
                    } else {
                        OfferingCacaoAdapter.activate((String)offeringName, null);
                    }
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in SCN/Cacao offering activation");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return new ResponseError("", "system", "10210", "F");
                }
                return new ResponseError(null, null, "0", null);
            }
            if (outCall.equalsIgnoreCase("322")) {
                String subscriptionKey = null;
                if (XMLUtils.containsForm(wizardDocument, "sunAccountTwo")) {
                    subscriptionKey = XMLUtils.getWidgetResponse(wizardDocument, "sunAccountTwo", "subKey");
                } else if (XMLUtils.containsForm(wizardDocument, "enablePortalOne")) {
                    subscriptionKey = XMLUtils.getWidgetResponse(wizardDocument, "enablePortalOne", "subKey");
                } else if (XMLUtils.containsForm(wizardDocument, "subscription1")) {
                    subscriptionKey = XMLUtils.getWidgetResponse(wizardDocument, "subscription1", "subKey");
                }
                try {
                    SWUPOMCacaoAdapter.setSubscriptionKey((String)subscriptionKey);
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in SWOM/Cacao set subscription key");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return new ResponseError("", "system", "10322", "F");
                }
                return new ResponseError(null, null, "0", null);
            }
            if (outCall.equalsIgnoreCase("333")) {
                String systemDisplayName = null;
                if (XMLUtils.containsForm(wizardDocument, "sunAccountThreeA")) {
                    systemDisplayName = XMLUtils.getWidgetResponse(wizardDocument, "sunAccountThreeA", "system");
                } else if (XMLUtils.containsForm(wizardDocument, "enablePortalOne")) {
                    systemDisplayName = XMLUtils.getWidgetResponse(wizardDocument, "enablePortalOne", "system");
                } else if (XMLUtils.containsForm(wizardDocument, "subscription2")) {
                    systemDisplayName = XMLUtils.getWidgetResponse(wizardDocument, "subscription2", "system");
                }
                if (XMLUtils.containsForm(wizardDocument, "subscription1")) {
                    try {
                        systemDisplayName = SWUPOMCacaoAdapter.getAMSSystemDisplayName();
                    }
                    catch (CacaoAdapterException caEx) {
                        LOG.severe("Error in SWOM/Cacao get AMS system display name");
                        LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    }
                }
                LOG.info(" ** system display name: " + systemDisplayName);
                try {
                    SWUPOMCacaoAdapter.setSystemDisplayName((String)systemDisplayName);
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in SWOM/Cacao set system display name");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return new ResponseError("", "system", "10333", "F");
                }
                return new ResponseError(null, null, "0", null);
            }
            if (outCall.equalsIgnoreCase("344")) {
                String remoteSelect;
                boolean isSWUPPortal = false;
                if (XMLUtils.containsForm(wizardDocument, "sunAccountThreeA")) {
                    remoteSelect = XMLUtils.getWidgetResponse(wizardDocument, "sunAccountThreeA", "systemselect");
                    isSWUPPortal = remoteSelect != null && remoteSelect.equals("true");
                } else if (XMLUtils.containsForm(wizardDocument, "subscription2")) {
                    remoteSelect = XMLUtils.getWidgetResponse(wizardDocument, "subscription2", "systemselect");
                    isSWUPPortal = remoteSelect != null && remoteSelect.equals("true");
                } else if (XMLUtils.containsForm(wizardDocument, "enablePortalOne")) {
                    isSWUPPortal = true;
                } else if (XMLUtils.containsForm(wizardDocument, "subscription1")) {
                    isSWUPPortal = true;
                }
                LOG.info(" ** SWUP Portal Enabled: " + isSWUPPortal);
                try {
                    SWUPOMCacaoAdapter.setSWUPPortalEnabled((boolean)isSWUPPortal);
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in SWOM/Cacao set SWUP portal enabled");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return new ResponseError("", "system", "10344", "F");
                }
                return new ResponseError(null, null, "0", null);
            }
            if (outCall.equalsIgnoreCase("311")) {
                String lpsURLString = null;
                if (XMLUtils.containsForm(wizardDocument, "local")) {
                    lpsURLString = XMLUtils.getWidgetResponse(wizardDocument, "patchURL");
                } else if (XMLUtils.containsForm(wizardDocument, "localreg")) {
                    lpsURLString = XMLUtils.getWidgetResponse(wizardDocument, "patchURL");
                }
                LOG.info(" ** LPS URL: " + lpsURLString);
                try {
                    SWUPOMCacaoAdapter.setLPSURL((String)lpsURLString);
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in SWOM/Cacao set SWUP LPS URL");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return new ResponseError("", "system", "10311", "F");
                }
                return new ResponseError(null, null, "0", null);
            }
            if (outCall.equalsIgnoreCase("555")) {
                int registerSystemResult;
                try {
                    registerSystemResult = XMLUtils.containsForm(wizardDocument, "solarisSystemRegistration") ? PROMCacaoAdapter.registerSystem() : SWUPOMCacaoAdapter.registerSystem();
                }
                catch (CacaoAdapterException caEx) {
                    LOG.severe("Error in PROM/Cacao register system");
                    LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
                    return new ResponseError("", "system", "10555", "F");
                }
                if (registerSystemResult != 0) {
                    return this.createRegisterResponseError(registerSystemResult, "10555");
                }
                try {
                    token = ClientLoginCacaoAdapter.getRegistrationToken();
                }
                catch (CacaoAdapterException caEx) {
                    return new ResponseError(null, null, "0", null);
                }
                LOG.info("ClientLoginCacaoAdapter.getRegistrationToken()= " + token);
                this.createResponseFile(wizardDocument, token);
                return new ResponseError(null, null, "0", null);
            }
            LOG.severe("Invalid outCall " + outCall);
            code = "9999";
            severity = "F";
        }
        LOG.info("message code = " + code);
        responseError = responseError != null ? new ResponseError(responseError.getText(), responseError.getType(), code, severity) : new ResponseError(null, "user", code, severity);
        return responseError;
    }

    private ResponseError createLoginResponseError(int loginResult, String defaultCode) {
        ResponseError responseError;
        LOG.info("login result int: " + loginResult);
        switch (loginResult) {
            case 0: {
                responseError = new ResponseError(null, null, "0", null);
                break;
            }
            case 1: {
                responseError = new ResponseError("", "user", "102", "F");
                break;
            }
            case 2: {
                responseError = new ResponseError("", "user", "106", "F");
                break;
            }
            case 3: {
                responseError = new ResponseError("", "system", "245", "F");
                break;
            }
            default: {
                responseError = new ResponseError("", "system", defaultCode, "F");
            }
        }
        return responseError;
    }

    private ResponseError createRegisterResponseError(int registerResult, String defaultCode) {
        ResponseError responseError;
        LOG.info("register result int: " + registerResult);
        switch (registerResult) {
            case 0: {
                responseError = new ResponseError(null, null, "0", null);
                break;
            }
            case 1: {
                responseError = new ResponseError("", "user", "10559", "F");
                break;
            }
            case 2: {
                responseError = new ResponseError("", "user", "10557", "F");
                break;
            }
            case 3: {
                responseError = new ResponseError("", "system", "245", "F");
                break;
            }
            default: {
                responseError = new ResponseError("", "system", defaultCode, "F");
            }
        }
        return responseError;
    }

    private Document storeLPS(Document wizardDocument) {
        Document result = null;
        try {
            Class<?> c = Class.forName("com.sun.cns.basicreg.adapter.LPSAdapter");
            Object[] initArgs = new Object[]{wizardDocument};
            Constructor<?> cons = c.getConstructor(Document.class);
            Object obj = cons.newInstance(initArgs);
            Method setURL = c.getMethod("setURL", new Class[0]);
            result = (Document)setURL.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
        return result;
    }

    private void createResponseFile(Document theDocument, String companyID) {
        if (AutoReg.findEntry(theDocument, "autoreg").equals("") || AutoReg.findEntry(theDocument, "autoreg").equals("false")) {
            LOG.info("do not create a response file");
            return;
        }
        LOG.info("now creating a response file");
        Element responseElm = new Element("registrationprofile");
        Document result = new Document(responseElm, new DocType("registrationprofile", "dtd/registrationprofile.dtd"));
        Comment comment = new Comment("this profile should be treated as sensitive data and should not be posted on public web sites, broadcast on email aliases");
        List content = result.getContent();
        content.add(0, comment);
        Element tokenElm = new Element("token");
        CDATA token = new CDATA(companyID);
        tokenElm.addContent((Content)token);
        Element offeringElm = new Element("offering");
        offeringElm.setAttribute("type", CmdLineGlobalObject.runModeType);
        Element portalEnabledElm = new Element("portalenabled");
        CDATA portalEnabled = null;
        portalEnabled = !AutoReg.findEntry(theDocument, "system").equals("") ? new CDATA("true") : new CDATA("false");
        portalEnabledElm.addContent((Content)portalEnabled);
        Element lpsElement = new Element("lps");
        CDATA lpsData = new CDATA(AutoReg.findEntry(theDocument, "patchURL"));
        lpsElement.addContent((Content)lpsData);
        Element proxyElm = new Element("proxy");
        Element hostNameElm = new Element("hostname");
        try {
            CDATA hostName = new CDATA(NetworkProxyCacaoAdapter.getProxyHost());
            hostNameElm.addContent((Content)hostName);
            Element portElm = new Element("port");
            CDATA port = new CDATA(NetworkProxyCacaoAdapter.getProxyPort());
            portElm.addContent((Content)port);
            Element userNameElm = new Element("username");
            CDATA userName = new CDATA(NetworkProxyCacaoAdapter.getProxyAuthUser());
            if (NetworkProxyCacaoAdapter.getProxyAuthUser() != null) {
                proxyElm.setAttribute("auth", "yes");
            } else {
                proxyElm.setAttribute("auth", "no");
            }
            userNameElm.addContent((Content)userName);
            Element passwordElm = new Element("password");
            String proxyPassword = NetworkProxyCacaoAdapter.getProxyAuthPass();
            if (proxyPassword != null && proxyPassword.trim().length() >= 1) {
                XOR xor = new XOR(companyID.getBytes(), proxyPassword.getBytes(), companyID.length(), proxyPassword.length());
                proxyPassword = new String(xor.encrypt());
                proxyPassword = Base64.byteArrayToBase64((byte[])proxyPassword.getBytes(), (boolean)false);
            }
            CDATA password = new CDATA(proxyPassword);
            passwordElm.addContent((Content)password);
            proxyElm.addContent((Content)hostNameElm);
            proxyElm.addContent((Content)portElm);
            proxyElm.addContent((Content)userNameElm);
            proxyElm.addContent((Content)passwordElm);
        }
        catch (CacaoAdapterException caEx) {
            LOG.severe("Error obtaining Cacao network proxy information");
            LOG.severe(CommonUtil.getStackTrace((Throwable)caEx));
        }
        Element subscriptionKeyElm = new Element("subscriptionkey");
        CDATA subscriptionKey = new CDATA(AutoReg.findEntry(theDocument, "subKey"));
        subscriptionKeyElm.addContent((Content)subscriptionKey);
        offeringElm.addContent((Content)portalEnabledElm);
        offeringElm.addContent((Content)lpsElement);
        responseElm.addContent((Content)tokenElm);
        responseElm.addContent((Content)offeringElm);
        responseElm.addContent((Content)proxyElm);
        responseElm.addContent((Content)subscriptionKeyElm);
        if (result != null) {
            File profileDir = new File("/usr/lib/breg/data");
            if (profileDir.exists()) {
                DocOutputter.output("/usr/lib/breg/data/autoRegistrationProfile.xml", result);
                CmdLineWizard.setfileMod("/usr/lib/breg/data/autoRegistrationProfile.xml", 1536);
            } else if (profileDir.mkdirs()) {
                DocOutputter.output("/usr/lib/breg/data/autoRegistrationProfile.xml", result);
                CmdLineWizard.setfileMod("/usr/lib/breg/data/autoRegistrationProfile.xml", 1536);
            } else {
                LOG.severe("unable to create the directory/usr/lib/breg/data");
            }
        }
    }

    private Document authenticateUser(Document wizardDocument) {
        Document result = null;
        try {
            Class<?> c = Class.forName("com.sun.cns.basicreg.adapter.eCRAdapter");
            Object[] initArgs = new Object[]{wizardDocument};
            Constructor<?> cons = c.getConstructor(Document.class);
            Object obj = cons.newInstance(initArgs);
            Method authenticateUser = c.getMethod("authenticateUser", new Class[0]);
            result = (Document)authenticateUser.invoke(obj, new Object[0]);
        }
        catch (Exception ex) {
            LOG.severe("USER AUTHENTICATION FAILED: " + ex.toString());
        }
        return result;
    }

    private Document registerUser(Document wizardDocument) {
        Document result = null;
        try {
            Class<?> c = Class.forName("com.sun.cns.basicreg.adapter.eCRAdapter");
            Object[] initArgs = new Object[]{wizardDocument};
            Constructor<?> cons = c.getConstructor(Document.class);
            Object obj = cons.newInstance(initArgs);
            Method registerUser = c.getMethod("registerUser", new Class[0]);
            result = (Document)registerUser.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
        return result;
    }

    private Document registerAsset(Document wizardDocument) {
        boolean isAuthenticated = false;
        Document result = null;
        try {
            Class<?> c = Class.forName("com.sun.cns.basicreg.adapter.AssetAdapter");
            Object[] initArgs = new Object[]{wizardDocument};
            Constructor<?> cons = c.getConstructor(Document.class);
            Object obj = cons.newInstance(initArgs);
            Method registerAsset = c.getMethod("registerAsset", new Class[0]);
            result = (Document)registerAsset.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
        return result;
    }

    private Document registerAsset(Document wizardDocument, String token) {
        boolean isAuthenticated = false;
        Document result = null;
        try {
            Class<?> c = Class.forName("com.sun.cns.basicreg.adapter.AssetAdapter");
            Object[] initArgs = new Object[]{wizardDocument};
            Constructor<?> cons = c.getConstructor(Document.class);
            Object obj = cons.newInstance(initArgs);
            initArgs = new Object[]{token};
            Method registerAsset = c.getMethod("registerXMLAsset", String.class);
            result = (Document)registerAsset.invoke(obj, initArgs);
        }
        catch (Exception e) {
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
        return result;
    }

    public void closeCSMAuthFrame() {
        try {
            Class<?> csmauthClass = Class.forName("com.sun.cns.basicreg.adapter.CSMAuthAdapter");
            Method getInstance = csmauthClass.getMethod("getInstance", new Class[0]);
            Object csmauthObject = getInstance.invoke(new Object(), new Object[0]);
            Method closeFrame = csmauthClass.getMethod("closeFrame", new Class[0]);
            closeFrame.invoke(csmauthObject, new Object[0]);
            LOG.info("CSMAuth frame is closed");
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
    }

    private Response constructResponse(Document theDocument) {
        Response response = null;
        ArrayList<ResponseError> errorList = new ArrayList<ResponseError>();
        String result = "";
        ElementFilter filter = new ElementFilter("Response");
        Iterator theIter = theDocument.getDescendants((Filter)filter);
        while (theIter.hasNext()) {
            try {
                Element element = (Element)theIter.next();
                String type = element.getAttributeValue("type");
                String text = element.getText();
                response = new Response(text, type);
                ElementFilter errorFilter = new ElementFilter("Error");
                Iterator theErrorIter = theDocument.getDescendants((Filter)errorFilter);
                while (theErrorIter.hasNext()) {
                    try {
                        Element elementError = (Element)theErrorIter.next();
                        ResponseError responseError = new ResponseError(elementError.getText(), elementError.getAttributeValue("type"), elementError.getAttributeValue("code"), elementError.getAttributeValue("severity"));
                        errorList.add(responseError);
                    }
                    catch (NullPointerException npe) {}
                }
                response.setErrorList(errorList);
            }
            catch (NullPointerException npe) {}
        }
        return response;
    }

    private void initialize() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this.identifier);
        SAXBuilder builder = new SAXBuilder();
        Document document = null;
        try {
            document = builder.build(inputStream);
        }
        catch (JDOMException e) {
            LOG.severe(e.getMessage());
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
        }
        this.forms = new ArrayList();
        if (document != null) {
            Element rootElm = document.getRootElement();
            this.outputFile = CmdLineWizard.getAttributeValue(rootElm, "outputFile");
            this.title = CmdLineWizard.getAttributeValue(rootElm, "title");
            List formElms = rootElm.getChildren("form");
            Iterator i = formElms.iterator();
            while (i.hasNext()) {
                this.forms.add(this.createForm((Element)i.next()));
            }
        }
        this.globalObject = CmdLineGlobalObject.getInstance();
        String formId = null;
        Object storedFormReload = null;
        if (CmdLineGlobalObject.forms != null) {
            LOG.info("restore from global object");
            int formIndex = 0;
            for (Form form : this.forms) {
                if (form.isReLoad() && (formId = this.getFormIdentifier(formIndex)) != null) {
                    storedFormReload = CmdLineGlobalObject.forms.get(formId);
                    if (storedFormReload != null) {
                        this.formReload = storedFormReload;
                        form.setReLoad(this.formReload);
                    }
                }
                ++formIndex;
            }
        } else {
            CmdLineGlobalObject.forms = new HashMap();
            LOG.info("initialize global object");
            int formIndex = 0;
            for (Form form : this.forms) {
                CmdLineGlobalObject.forms.put(this.getFormIdentifier(formIndex), new Boolean(form.isReLoad()));
                ++formIndex;
            }
        }
    }

    private Form createForm(Element element) {
        CmdLineForm result = new CmdLineForm(this, CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "popup"), CmdLineWizard.getAttributeValue(element, "modal"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "start"), CmdLineWizard.getAttributeValue(element, "finish"), CmdLineWizard.getAttributeValue(element, "confirm"), CmdLineWizard.getAttributeValue(element, "navigator"), CmdLineWizard.getAttributeValue(element, "backId"), CmdLineWizard.getAttributeValue(element, "nextId"), CmdLineWizard.getAttributeValue(element, "initialFocusWID"), CmdLineWizard.getAttributeValue(element, "outcall"), CmdLineWizard.getAttributeValue(element, "outforms"), CmdLineWizard.getAttributeValue(element, "setVarList"), CmdLineWizard.getAttributeValue(element, "reLayout"));
        List widgetElms = element.getChildren();
        Iterator i = widgetElms.iterator();
        while (i.hasNext()) {
            result.addWidget(this.createWidget((Element)i.next(), result));
        }
        return result;
    }

    private Widget createWidget(Element element, Form form) {
        CmdLineWidget result = new CmdLineUnknownWidget("");
        String name = element.getName();
        result = name.equalsIgnoreCase(WidgetType.MESSAGE.toString()) ? new CmdLineMessageWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), "no", CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "columns"), CmdLineWizard.getAttributeValue(element, "rows"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "leftAt"), CmdLineWizard.getAttributeValue(element, "rightTo"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "isDisplayed")) : (name.equalsIgnoreCase(WidgetType.FIELD.toString()) ? new CmdLineFieldWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "length"), CmdLineWizard.getAttributeValue(element, "default"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "leftAt"), CmdLineWizard.getAttributeValue(element, "rightTo"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "toolTip"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "mnemonic"), CmdLineWizard.getAttributeValue(element, "isDisplayed")) : (name.equalsIgnoreCase(WidgetType.PASSWORD.toString()) ? new CmdLinePasswordWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "length"), CmdLineWizard.getAttributeValue(element, "default"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "leftAt"), CmdLineWizard.getAttributeValue(element, "rightTo"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "toolTip"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "mnemonic"), CmdLineWizard.getAttributeValue(element, "isDisplayed")) : (name.equalsIgnoreCase(WidgetType.SELECT.toString()) ? new CmdLineSelectWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "leftAt"), CmdLineWizard.getAttributeValue(element, "rightTo"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "slaveId"), CmdLineWizard.getAttributeValue(element, "slaveValue"), CmdLineWizard.getAttributeValue(element, "continueCheck"), CmdLineWizard.getAttributeValue(element, "selectType"), CmdLineWizard.getAttributeValue(element, "groupId"), CmdLineWizard.getAttributeValue(element, "selected"), CmdLineWizard.getAttributeValue(element, "setVarListIfSelected"), CmdLineWizard.getAttributeValue(element, "setVarListIfDeselected"), CmdLineWizard.getAttributeValue(element, "toolTip"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "mnemonic"), CmdLineWizard.getAttributeValue(element, "isDisplayed")) : (name.equalsIgnoreCase(WidgetType.RADIOBOX.toString()) ? new CmdLineRadioBoxWidget(form, CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "reload"), element, CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "orientation"), CmdLineWizard.getAttributeValue(element, "default"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "leftAt"), CmdLineWizard.getAttributeValue(element, "rightTo"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "isDisplayed")) : (name.equalsIgnoreCase(WidgetType.COMBOBOX.toString()) ? new CmdLineComboBoxWidget(form, CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "reload"), element, CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "load"), CmdLineWizard.getAttributeValue(element, "default"), CmdLineWizard.getAttributeValue(element, "size"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "leftAt"), CmdLineWizard.getAttributeValue(element, "rightTo"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "toolTip"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "mnemonic"), CmdLineWizard.getAttributeValue(element, "isDisplayed")) : (name.equalsIgnoreCase(WidgetType.INFORMATION.toString()) ? new CmdLineInformationWidget(form, CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "columns"), CmdLineWizard.getAttributeValue(element, "rows"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "leftAt"), CmdLineWizard.getAttributeValue(element, "rightTo"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "isDisplayed")) : (name.equalsIgnoreCase(WidgetType.JUMP.toString()) ? new CmdLineJumpWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "toformid"), CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "showButton"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "leftAt"), CmdLineWizard.getAttributeValue(element, "rightTo"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "toolTip"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "mnemonic"), CmdLineWizard.getAttributeValue(element, "isDisplayed")) : (name.equalsIgnoreCase(WidgetType.LINK.toString()) ? new CmdLineLinkWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "url"), CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "showButton"), CmdLineWizard.getAttributeValue(element, "endsWizard"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "leftAt"), CmdLineWizard.getAttributeValue(element, "rightTo"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "toolTip"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "mnemonic"), CmdLineWizard.getAttributeValue(element, "isDisplayed")) : (name.equalsIgnoreCase(WidgetType.TEXTICONLABEL.toString()) ? new CmdLineTextIconLabelWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "labeliconfilename"), CmdLineWizard.getAttributeValue(element, "labelicondescription"), CmdLineWizard.getAttributeValue(element, "xText"), CmdLineWizard.getAttributeValue(element, "yText"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "leftAt"), CmdLineWizard.getAttributeValue(element, "rightTo"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "toolTip"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "isDisplayed")) : (name.equalsIgnoreCase(WidgetType.HTML.toString()) ? new CmdLineHTMLWidget(form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "title"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "scrollable"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "isDisplayed")) : (name.equalsIgnoreCase(WidgetType.HIDDEN.toString()) ? new CmdLineHiddenWidget(CmdLineWizard.getText(element)) : (name.equalsIgnoreCase(WidgetType.REFLECTION.toString()) ? new CmdLineReflectionWidget(form, CmdLineWizard.getAttributeValue(element, "type"), CmdLineWizard.getChildText(element, "className"), CmdLineWizard.getChildText(element, "methodName"), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "id"), CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "leftAt"), CmdLineWizard.getAttributeValue(element, "rightTo"), CmdLineWizard.getAttributeValue(element, "fontcolor"), CmdLineWizard.getAttributeValue(element, "toolTip"), CmdLineWizard.getAttributeValue(element, "s508Name"), CmdLineWizard.getAttributeValue(element, "s508Desc"), CmdLineWizard.getAttributeValue(element, "mnemonic"), CmdLineWizard.getAttributeValue(element, "parentid"), CmdLineWizard.getAttributeValue(element, "asset"), CmdLineWizard.getAttributeValue(element, "htmlformid"), CmdLineWizard.getAttributeValue(element, "limitedhtmlformid"), CmdLineWizard.getAttributeValue(element, "solarishtmlformid")) : new CmdLineUnknownWidget(CmdLineWizard.getText(element))))))))))))));
        return result;
    }

    private Widget createWidget(WidgetType type, String text, String id, String parentId, boolean asset, boolean isReload, String htmlFormId, String limitedHtmlFormId, String solarisHtmlFormId) {
        CmdLineWidget result;
        String i18nText = CmdLineWizard.getI18NValue(text);
        if (type == WidgetType.MESSAGE) {
            result = new CmdLineMessageWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(limitedHtmlFormId);
            result.setSolarisHTMLFormId(solarisHtmlFormId);
        } else if (type == WidgetType.FIELD) {
            result = new CmdLineFieldWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(limitedHtmlFormId);
            result.setSolarisHTMLFormId(solarisHtmlFormId);
        } else if (type == WidgetType.PASSWORD) {
            result = new CmdLinePasswordWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(limitedHtmlFormId);
            result.setSolarisHTMLFormId(solarisHtmlFormId);
        } else if (type == WidgetType.SELECT) {
            result = new CmdLineSelectWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(limitedHtmlFormId);
            result.setSolarisHTMLFormId(solarisHtmlFormId);
        } else if (type == WidgetType.RADIOBOX) {
            result = new CmdLineRadioBoxWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(limitedHtmlFormId);
            result.setSolarisHTMLFormId(solarisHtmlFormId);
        } else if (type == WidgetType.COMBOBOX) {
            result = new CmdLineComboBoxWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(limitedHtmlFormId);
            result.setSolarisHTMLFormId(solarisHtmlFormId);
        } else if (type == WidgetType.INFORMATION) {
            result = new CmdLineInformationWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(limitedHtmlFormId);
            result.setSolarisHTMLFormId(solarisHtmlFormId);
        } else if (type == WidgetType.HIDDEN) {
            result = new CmdLineHiddenWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
            result.setReload(isReload);
            result.setHTMLFormId(htmlFormId);
            result.setLimitedHTMLFormId(limitedHtmlFormId);
            result.setSolarisHTMLFormId(solarisHtmlFormId);
        } else {
            result = new CmdLineUnknownWidget(i18nText);
            result.setId(id);
            result.setParentId(parentId);
            result.setAsset(asset);
        }
        return result;
    }

    private void processReflectionWidgets(Form form, int index) {
        if (form.isProcessed()) {
            return;
        }
        List widgets = form.getWidgets();
        ArrayList<Widget> newWidgets = new ArrayList<Widget>();
        for (Widget widget : widgets) {
            if (widget instanceof ReflectionWidget && !form.isReLoad() || widget instanceof ReflectionWidget && !widget.isReload()) {
                Object result = null;
                ReflectionWidget reflectWidget = (ReflectionWidget)((Object)widget);
                try {
                    Class<?> clazz = Class.forName(reflectWidget.getClassName());
                    Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                    Object object = constructor.newInstance(new Object[0]);
                    Method method = clazz.getMethod(reflectWidget.getMethodName(), new Class[0]);
                    result = method.invoke(object, new Object[0]);
                }
                catch (Exception e) {
                    LOG.severe("Reflection Exception: " + e.getMessage());
                }
                if (result != null) {
                    if (result instanceof List) {
                        List results = (List)result;
                        Iterator j = results.iterator();
                        while (j.hasNext()) {
                            StringReader stringReader;
                            String content = j.next().toString();
                            newWidgets.add(this.createWidget(reflectWidget.getTargetType(), content, widget.getId(), widget.getParentId(), widget.isAsset(), widget.isReload(), widget.getHTMLFormId(), widget.getLimitedHTMLFormId(), widget.getSolarisHTMLFormId()));
                            if (widget.getHTMLFormId() != null) {
                                stringReader = new StringReader(content);
                                this.convertXML2HTML(stringReader, widget.getHTMLFormId(), "F");
                            }
                            if (widget.getLimitedHTMLFormId() != null) {
                                stringReader = new StringReader(content);
                                this.convertXML2HTML(stringReader, widget.getLimitedHTMLFormId(), "P");
                            }
                            if (widget.getSolarisHTMLFormId() == null) continue;
                            stringReader = new StringReader(content);
                            this.convertXML2HTML(stringReader, widget.getSolarisHTMLFormId(), "S");
                        }
                        continue;
                    }
                    if (!(result instanceof Object)) continue;
                    newWidgets.add(this.createWidget(reflectWidget.getTargetType(), result.toString(), widget.getId(), widget.getParentId(), widget.isAsset(), widget.isReload(), widget.getHTMLFormId(), widget.getLimitedHTMLFormId(), widget.getSolarisHTMLFormId()));
                    continue;
                }
                newWidgets.add(this.createWidget(reflectWidget.getTargetType(), "", widget.getId(), widget.getParentId(), widget.isAsset(), widget.isReload(), widget.getHTMLFormId(), widget.getLimitedHTMLFormId(), widget.getSolarisHTMLFormId()));
                continue;
            }
            if (!(widget instanceof ReflectionWidget) || !widget.isReload()) continue;
            ReflectionWidget reflectWidget = (ReflectionWidget)((Object)widget);
            newWidgets.add(this.createWidget(reflectWidget.getTargetType(), "", widget.getId(), widget.getParentId(), widget.isAsset(), widget.isReload(), widget.getHTMLFormId(), widget.getLimitedHTMLFormId(), widget.getSolarisHTMLFormId()));
            if (index != 0) continue;
            this.forceToReload = true;
        }
        Iterator i = newWidgets.iterator();
        while (i.hasNext()) {
            form.addWidget((Widget)i.next());
        }
    }

    private void convertXML2HTML(StringReader stringReader, String htmlFormId, String docControl) {
        LOG.info("convertXML2HTML for form: " + htmlFormId);
        SAXBuilder builder = new SAXBuilder();
        Document document = null;
        try {
            document = builder.build((Reader)stringReader);
        }
        catch (JDOMException e) {
            LOG.severe(e.getMessage());
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
        }
        if (document != null) {
            LOG.finest("it is ready to convert");
            Element rootElm = document.getRootElement();
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream inputStream = docControl.equalsIgnoreCase("F") ? classLoader.getResourceAsStream("wizards/asset.xsl") : (docControl.equalsIgnoreCase("P") ? classLoader.getResourceAsStream("wizards/limitedasset.xsl") : (docControl.equalsIgnoreCase("S") ? classLoader.getResourceAsStream("wizards/solarisasset.xsl") : classLoader.getResourceAsStream("wizards/asset.xsl")));
            Document outDocument = null;
            try {
                XSLTransformer transformer = new XSLTransformer(inputStream);
                outDocument = transformer.transform(document);
                if (new Boolean(this.globalObject.getPropertyValue("asset.enabled", "false")).booleanValue()) {
                    this.location = this.globalObject.getPropertyValue("asset.location", "/tmp/");
                    this.dateTimeStampBoolean = new Boolean(this.globalObject.getPropertyValue("asset.datetimestamp", "true"));
                    this.fileNamePrefix = this.globalObject.getPropertyValue("asset.filename.prefix", "asset-output");
                    this.fileNameSuffix = this.globalObject.getPropertyValue("asset.filename.suffix", ".html");
                    this.dateTimeStamp = CommonUtil.getDateTimeStamp();
                    this.filePattern = this.dateTimeStampBoolean ? this.location + this.fileNamePrefix + this.dateTimeStamp + this.fileNameSuffix : this.location + this.fileNamePrefix + this.fileNameSuffix;
                    DocOutputter.output(this.filePattern, outDocument);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DocOutputter.output(byteArrayOutputStream, outDocument);
                this.SetHTMLForForms(htmlFormId, byteArrayOutputStream.toString(), docControl);
            }
            catch (Exception e) {
                LOG.severe(e.getMessage());
            }
        }
    }

    private void SetHTMLForForms(String htmlFormId, String htmlText, String docControl) {
        LOG.info("SetHTMLForForms for form: " + htmlFormId);
        if (htmlFormId != null) {
            StringTokenizer st = new StringTokenizer(htmlFormId, ",");
            try {
                while (st.hasMoreElements()) {
                    String htmlFormEntity = (String)st.nextElement();
                    this.SetHTML(htmlFormEntity, htmlText, docControl);
                }
            }
            catch (NoSuchElementException e) {
                LOG.severe(CommonUtil.getStackTrace((Throwable)e));
            }
        }
    }

    private void SetHTML(String htmlFormId, String htmlText, String docControl) {
        LOG.info("SetHTML for form " + htmlFormId + ", docControl: " + docControl);
        Form form2 = null;
        for (Form form2 : this.forms) {
            if (form2.getFormIdentifier() == null || !form2.getFormIdentifier().equals(htmlFormId)) continue;
            List widgets = form2.getWidgets();
            for (Widget widget : widgets) {
                if (!(widget instanceof HTMLWidget)) continue;
                LOG.info("FOUND HTML WIDGET: " + widget.getId());
                String htmlCleanText = htmlText;
                if (htmlText.startsWith("<?xml")) {
                    htmlCleanText = htmlText.substring(htmlText.indexOf(10) + 1);
                }
                LOG.finest("  >>>> SetHTML on html widget " + htmlFormId + " to: " + htmlCleanText);
                String i18nAssetInfo = "F";
                if (docControl.equalsIgnoreCase("F")) {
                    i18nAssetInfo = "F";
                } else if (docControl.equalsIgnoreCase("P")) {
                    i18nAssetInfo = "P";
                } else if (docControl.equalsIgnoreCase("S")) {
                    i18nAssetInfo = "S";
                }
                String i18nHtmlText = I18N.getI18NAssetInfoHTML(htmlCleanText, i18nAssetInfo);
                widget.setText(i18nHtmlText);
            }
        }
    }

    public static String getAttributeValue(Element element, String attributeName) {
        String literalValue = element.getAttributeValue(attributeName);
        return CmdLineWizard.getI18NValue(literalValue);
    }

    public static String getText(Element element) {
        String literalValue = element.getText();
        return CmdLineWizard.getI18NValue(literalValue);
    }

    public static String getChildText(Element element, String childName) {
        String literalValue = element.getChildText(childName);
        return CmdLineWizard.getI18NValue(literalValue);
    }

    public static String getI18NValue(String literalValue) {
        if (literalValue == null) {
            return null;
        }
        if (literalValue.trim().startsWith("_i18n")) {
            return I18N.getXMLValueString(literalValue.trim());
        }
        return literalValue;
    }

    public static ArrayList getListOfActualValues(String literalCSV) {
        ArrayList<String> actualValues = new ArrayList<String>();
        if (literalCSV == null) {
            return actualValues;
        }
        StringTokenizer st = new StringTokenizer(literalCSV, ",");
        try {
            while (st.hasMoreElements()) {
                String listEntity = (String)st.nextElement();
                String listEntityValue = VariableMap.getActualValue(listEntity);
                if (listEntityValue == null) {
                    LOG.severe("No actual value found for: " + listEntity);
                    continue;
                }
                StringTokenizer st2 = new StringTokenizer(listEntityValue, ",");
                while (st2.hasMoreElements()) {
                    actualValues.add((String)st2.nextElement());
                }
            }
        }
        catch (NoSuchElementException e) {
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
        return actualValues;
    }

    public Document getDocument() {
        Document wizardDocument = this.buildWizardDocument();
        if (wizardDocument != null && new Boolean(this.globalObject.getPropertyValue("profile.enabled", "false")).booleanValue()) {
            this.location = this.globalObject.getPropertyValue("profile.location", "/tmp/");
            this.dateTimeStampBoolean = new Boolean(this.globalObject.getPropertyValue("profile.datetimestamp", "true"));
            this.fileNamePrefix = this.globalObject.getPropertyValue("profile.filename.prefix", this.outputFile);
            if (this.fileNamePrefix.trim() == null || this.fileNamePrefix.trim().equals("")) {
                this.fileNamePrefix = this.outputFile;
            }
            this.fileNameSuffix = this.globalObject.getPropertyValue("profile.filename.suffix", ".xml");
            if (this.fileNameSuffix.trim() == null || this.fileNameSuffix.trim().equals("")) {
                this.fileNameSuffix = ".xml";
            }
            this.dateTimeStamp = CommonUtil.getDateTimeStamp();
            this.filePattern = this.dateTimeStampBoolean ? this.location + this.fileNamePrefix + this.dateTimeStamp + this.fileNameSuffix : this.location + this.fileNamePrefix + this.fileNameSuffix;
        }
        return wizardDocument;
    }

    private Document buildWizardDocument() {
        this.outAsset = false;
        boolean outAssetID = false;
        Document result = null;
        Element wizardElm = null;
        Form form2 = null;
        for (Form form2 : this.forms) {
            if (!this.isInOutForms(form2)) continue;
            if (!outAssetID) {
                result = new Document();
                wizardElm = this.createDoc();
                outAssetID = true;
            }
            LOG.info("add content for form: " + form2.getFormIdentifier());
            wizardElm.addContent((Content)this.buildFormElement(form2));
        }
        if (outAssetID) {
            result.setRootElement(wizardElm);
        }
        return result;
    }

    private Element createDoc() {
        Element wizardElm = new Element("wizard");
        wizardElm.setAttribute("outputfile", this.outputFile);
        Element formElm = new Element("form");
        formElm.setAttribute("title", "asset id information");
        Element widget = new Element("widget");
        widget.setAttribute("id", "assetId");
        Element response = new Element("response");
        CDATA data = new CDATA(this.assetId);
        response.addContent((Content)data);
        widget.addContent((Content)response);
        formElm.addContent((Content)widget);
        wizardElm.addContent((Content)formElm);
        return wizardElm;
    }

    private boolean isInOutForms(Form form) {
        String formId = form.getFormIdentifier();
        String outFormEntity2 = null;
        if (this.outForms == null) {
            return false;
        }
        for (String outFormEntity2 : this.outForms) {
            if (!outFormEntity2.equals(formId)) continue;
            return true;
        }
        return false;
    }

    private Element buildFormElement(Form form) {
        Element result = new Element("form");
        result.setAttribute("id", form.getFormIdentifier());
        result.setAttribute("title", form.getTitle());
        List widgets = form.getWidgets();
        for (Widget widget : widgets) {
            if (widget instanceof ReflectionWidget || !this.isBuildWidgetElement(widget, form)) continue;
            result.addContent((Content)this.buildWidgetElement(widget));
        }
        return result;
    }

    private boolean isBuildWidgetElement(Widget widget, Form form) {
        boolean outWidget;
        if (widget.getParentId() != null) {
            LOG.finest("parentid = " + widget.getParentId());
            LOG.finest("asset = " + widget.isAsset());
            if (this.checkParentStatus(widget.getParentId(), form)) {
                outWidget = true;
                if (widget.isAsset()) {
                    this.outAsset = true;
                }
            } else {
                outWidget = false;
            }
        } else {
            outWidget = true;
            if (widget.isAsset()) {
                this.outAsset = true;
            }
        }
        return outWidget;
    }

    private Element buildWidgetElement(Widget widget) {
        Element result = new Element("widget");
        result.setAttribute("type", widget.getType().toString());
        if (widget.getId() != null) {
            result.setAttribute("id", widget.getId());
        }
        CDATA text = new CDATA(widget.getText());
        Element textElm = new Element("text");
        textElm.setContent((Content)text);
        result.addContent((Content)textElm);
        if (widget instanceof ResponseWidget) {
            CDATA response = new CDATA(((ResponseWidget)((Object)widget)).getResponse());
            Element responseElm = new Element("response");
            responseElm.setContent((Content)response);
            result.addContent((Content)responseElm);
        } else if (widget instanceof SelectWidget) {
            Element selectedElm = new Element("response");
            selectedElm.setText(Boolean.toString(((SelectWidget)widget).isSelected()));
            result.addContent((Content)selectedElm);
        } else if (widget instanceof RadioBoxWidget || widget instanceof ComboBoxWidget) {
            List widgetsBox = null;
            if (widget instanceof RadioBoxWidget) {
                widgetsBox = ((CmdLineRadioBoxWidget)widget).getWidgets();
            } else if (widget instanceof ComboBoxWidget) {
                widgetsBox = ((CmdLineComboBoxWidget)widget).getWidgets();
            }
            for (Widget widgetInBox : widgetsBox) {
                if (!((SelectWidget)widgetInBox).isSelected()) continue;
                CDATA select = new CDATA(((CmdLineSelectWidget)widgetInBox).getText());
                Element selectedElm = new Element("response");
                selectedElm.setContent((Content)select);
                result.addContent((Content)selectedElm);
            }
        } else if (widget instanceof CmdLineHiddenWidget) {
            Element hiddenElm = new Element("response");
            hiddenElm.setText("NONE");
            result.addContent((Content)hiddenElm);
        }
        return result;
    }

    private boolean checkParentStatus(String id, Form form) {
        if (id.equals("$YES$")) {
            return true;
        }
        List widgets = form.getWidgets();
        for (Widget widget : widgets) {
            if (widget.getId() == null || !widget.getId().equals(id) || !(widget instanceof CmdLineSelectWidget)) continue;
            if (((CmdLineSelectWidget)widget).isSelected()) {
                LOG.finest("it is selected");
                return true;
            }
            LOG.finest("it is not selected");
            return false;
        }
        return false;
    }

    private void repeat(String text, int times) {
        for (int i = 0; i < times; ++i) {
            System.out.print(text);
        }
    }

    private static void setfileMod(String file, int mod) {
        String chmodcmd = String.format("/bin/chmod %x %s", mod, file);
        try {
            LOG.info("in setfileMod(" + file + "," + mod);
            Process p = Runtime.getRuntime().exec(chmodcmd);
            p.waitFor();
        }
        catch (Exception e) {
            LOG.severe("Cannot exec " + chmodcmd);
            LOG.severe(CommonUtil.getStackTrace((Throwable)e));
        }
    }
}

